/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.lang.reflect.Field;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R1.ChatComponentText;
import net.minecraft.server.v1_8_R1.EnumTitleAction;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutTitle;
import org.bukkit.entity.Player;

public class DisplayTitle {
    private static final Field title_action;
    private static final Field chat_component;
    private static final Field fade_in_ticks;
    private static final Field stay_ticks;
    private static final Field fade_out_ticks;

    public static PacketPlayOutTitle getTitlePacket(String title) {
        PacketPlayOutTitle titlePacket = new PacketPlayOutTitle();
        try {
            title_action.set(titlePacket, EnumTitleAction.TITLE);
            chat_component.set(titlePacket, new ChatComponentText(title));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return titlePacket;
    }

    public static PacketPlayOutTitle getSubtitlePacket(String subtitle) {
        PacketPlayOutTitle titlePacket = new PacketPlayOutTitle();
        try {
            title_action.set(titlePacket, EnumTitleAction.SUBTITLE);
            chat_component.set(titlePacket, new ChatComponentText(subtitle));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return titlePacket;
    }

    public static PacketPlayOutTitle getTimesPacket(int fade_in, int stay, int fade_out) {
        PacketPlayOutTitle titlePacket = new PacketPlayOutTitle();
        try {
            title_action.set(titlePacket, EnumTitleAction.TIMES);
            fade_in_ticks.set(titlePacket, fade_in);
            stay_ticks.set(titlePacket, stay);
            fade_out_ticks.set(titlePacket, fade_out);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return titlePacket;
    }

    public static void showTitle(Player player, String title, String subtitle, int fade_in, int stay, int fade_out) {
        PacketPlayOutTitle titlePacketTimes = DisplayTitle.getTimesPacket(fade_in, stay, fade_out);
        PacketHelper.sendPacket(player, (Packet)titlePacketTimes);
        if (title != null) {
            PacketPlayOutTitle titlePacketTitle = DisplayTitle.getTitlePacket(title);
            PacketHelper.sendPacket(player, (Packet)titlePacketTitle);
        }
        if (subtitle != null) {
            PacketPlayOutTitle titlePacketSubtitle = DisplayTitle.getSubtitlePacket(subtitle);
            PacketHelper.sendPacket(player, (Packet)titlePacketSubtitle);
        }
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutTitle.class);
        title_action = fields.get("a");
        chat_component = fields.get("b");
        fade_in_ticks = fields.get("c");
        stay_ticks = fields.get("d");
        fade_out_ticks = fields.get("e");
    }
}

