/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutSetSlot;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_8_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ItemChangeMessage
implements Listener {
    private static final Field slot_inventoryId;
    private static final Field slot_slotId;
    private static final Field slot_item;
    private static final Map<UUID, Integer> slotChanged;

    public static PacketPlayOutSetSlot getSlotPacket(UUID player, int nmsSlot, ItemStack item) {
        PacketPlayOutSetSlot slotPacket = new PacketPlayOutSetSlot();
        try {
            slot_inventoryId.set(slotPacket, 0);
            slotChanged.put(player, nmsSlot);
            slot_slotId.set(slotPacket, nmsSlot);
            slot_item.set(slotPacket, CraftItemStack.asNMSCopy((ItemStack)item));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return slotPacket;
    }

    public static void sendMessage(Player player, String message) {
        ItemStack item = player.getItemInHand();
        if (item == null || item.getType() == Material.AIR) {
            item = new ItemStack(Material.STAINED_GLASS_PANE);
            item.getData().setData((byte)8);
        } else {
            item = item.clone();
        }
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(message);
        item.setItemMeta(meta);
        PacketPlayOutSetSlot slotPacket = ItemChangeMessage.getSlotPacket(player.getUniqueId(), player.getInventory().getHeldItemSlot() + 36, item);
        PacketHelper.sendPacket(player, (Packet)slotPacket);
    }

    public static void resetItem(Player player) {
        if (player == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        if (slotChanged.containsKey(uuid)) {
            PacketPlayOutSetSlot slotPacket = ItemChangeMessage.getSlotPacket(uuid, slotChanged.get(uuid), player.getItemInHand());
            PacketHelper.sendPacket(player, (Packet)slotPacket);
            slotChanged.remove(uuid);
        }
    }

    @EventHandler
    public void playerItemHeld(PlayerItemHeldEvent event) {
        ItemChangeMessage.resetItem(event.getPlayer());
    }

    @EventHandler
    public void inventoryOpen(InventoryOpenEvent event) {
        if (event.getPlayer() instanceof Player) {
            ItemChangeMessage.resetItem((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void blockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player != null && slotChanged.containsKey(player.getUniqueId())) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (player != null && slotChanged.containsKey(player.getUniqueId())) {
            slotChanged.remove(player.getUniqueId());
        }
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutSetSlot.class);
        slot_inventoryId = fields.get("a");
        slot_slotId = fields.get("b");
        slot_item = fields.get("c");
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)new ItemChangeMessage(), (Plugin)DenizenAPI.getCurrentInstance());
        slotChanged = new HashMap<UUID, Integer>();
    }
}

