/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.utilities.packets;

import java.lang.reflect.Field;
import java.util.Map;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.packets.PacketHelper;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutExperience;
import net.minecraft.server.v1_8_R1.PacketPlayOutUpdateHealth;
import org.bukkit.entity.Player;

public class PlayerBars {
    private static final Field xp_current;
    private static final Field xp_total;
    private static final Field xp_level;
    private static final Field health_health;
    private static final Field health_food;
    private static final Field health_saturation;

    public static PacketPlayOutExperience getExperiencePacket(float exp, int level) {
        PacketPlayOutExperience experiencePacket = new PacketPlayOutExperience();
        try {
            xp_current.set(experiencePacket, Float.valueOf(exp));
            xp_level.set(experiencePacket, level);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return experiencePacket;
    }

    public static PacketPlayOutUpdateHealth getHealthPacket(float health, int food, float food_saturation) {
        PacketPlayOutUpdateHealth healthPacket = new PacketPlayOutUpdateHealth();
        try {
            health_health.set(healthPacket, Float.valueOf(health));
            health_food.set(healthPacket, food);
            health_saturation.set(healthPacket, Float.valueOf(food_saturation));
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        return healthPacket;
    }

    public static void showHealth(Player player, float health, int food, float food_saturation) {
        PacketPlayOutUpdateHealth healthPacket = PlayerBars.getHealthPacket(health, food, food_saturation);
        PacketHelper.sendPacket(player, (Packet)healthPacket);
    }

    public static void showExperience(Player player, float experience, int level) {
        PacketPlayOutExperience experiencePacket = PlayerBars.getExperiencePacket(experience, level);
        PacketHelper.sendPacket(player, (Packet)experiencePacket);
    }

    public static void resetExperience(Player player) {
        PacketPlayOutExperience experiencePacket = PlayerBars.getExperiencePacket(player.getExp(), player.getLevel());
        PacketHelper.sendPacket(player, (Packet)experiencePacket);
    }

    public static void resetHealth(Player player) {
        PacketPlayOutUpdateHealth healthPacket = PlayerBars.getHealthPacket((float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
        PacketHelper.sendPacket(player, (Packet)healthPacket);
    }

    static {
        Map<String, Field> fields = PacketHelper.registerFields(PacketPlayOutExperience.class);
        xp_current = fields.get("a");
        xp_total = fields.get("b");
        xp_level = fields.get("c");
        fields = PacketHelper.registerFields(PacketPlayOutUpdateHealth.class);
        health_health = fields.get("a");
        health_food = fields.get("b");
        health_saturation = fields.get("c");
    }
}

