/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Duration
implements dObject {
    static final Pattern match = Pattern.compile("(?:d@)?(\\d+.\\d+|.\\d+|\\d+)(t|m|s|h|d|w)?(?:(?:-\\d+.\\d+|.\\d+|\\d+)(?:t|m|s|h|d|w)?)?", 2);
    public static final Duration ZERO = new Duration(0);
    private double seconds;
    private String prefix = "Duration";

    public static Duration valueOf(String string) {
        return Duration.valueOf(string, null);
    }

    @Fetchable(value="d")
    public static Duration valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] split = (string = string.replace("d@", "")).split("-", 2);
        if (split.length == 2 && Duration.matches(split[0]) && Duration.matches(split[1])) {
            Duration low = Duration.valueOf(split[0]);
            Duration high = Duration.valueOf(split[1]);
            if (low != null && high != null && low.getSecondsAsInt() < high.getSecondsAsInt()) {
                int seconds = CoreUtilities.getRandom().nextInt(high.getSecondsAsInt() - low.getSecondsAsInt() + 1) + low.getSecondsAsInt();
                return new Duration(seconds);
            }
            return null;
        }
        Matcher m = match.matcher(string);
        if (m.matches()) {
            if (m.group().toLowerCase().endsWith("t")) {
                return new Duration(Double.valueOf(m.group(1)) * 0.05);
            }
            if (m.group().toLowerCase().endsWith("d")) {
                return new Duration(Double.valueOf(m.group(1)) * 86400.0);
            }
            if (m.group().toLowerCase().endsWith("w")) {
                return new Duration(Double.valueOf(m.group(1)) * 604800.0);
            }
            if (m.group().toLowerCase().endsWith("m")) {
                return new Duration(Double.valueOf(m.group(1)) * 60.0);
            }
            if (m.group().toLowerCase().endsWith("h")) {
                return new Duration(Double.valueOf(m.group(1)) * 3600.0);
            }
            return new Duration(Double.valueOf(m.group(1)));
        }
        return null;
    }

    public static boolean matches(String string) {
        Matcher m = match.matcher(string);
        return m.matches();
    }

    public Duration(double seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(int seconds) {
        this.seconds = seconds;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public Duration(long ticks) {
        this.seconds = ticks / 20L;
        if (this.seconds < 0.0) {
            this.seconds = 0.0;
        }
    }

    public long getTicks() {
        return (long)(this.seconds * 20.0);
    }

    public int getTicksAsInt() {
        return (int)(this.seconds * 20.0);
    }

    public long getMillis() {
        Double millis = this.seconds * 1000.0;
        return millis.longValue();
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getSecondsAsInt() {
        if (this.seconds < 1.0 && this.seconds > 0.0) {
            return 1;
        }
        return this.round(this.seconds);
    }

    private int round(double d) {
        int i;
        double dAbs = Math.abs(d);
        double result = dAbs - (double)(i = (int)dAbs);
        if (result < 0.5) {
            return d < 0.0 ? -i : i;
        }
        return d < 0.0 ? -(i + 1) : i + 1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getObjectType() {
        return "duration";
    }

    @Override
    public String identify() {
        return "d@" + this.getTicks() + "t";
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("in_years") || attribute.startsWith("years")) {
            return new Element(this.seconds / 3.1536E7).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_weeks") || attribute.startsWith("weeks")) {
            return new Element(this.seconds / 604800.0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_days") || attribute.startsWith("days")) {
            return new Element(this.seconds / 86400.0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_hours") || attribute.startsWith("hours")) {
            return new Element(this.seconds / 3600.0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_minutes") || attribute.startsWith("minutes")) {
            return new Element(this.seconds / 60.0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_seconds") || attribute.startsWith("seconds")) {
            return new Element(this.getTicks() / 20L).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_milliseconds") || attribute.startsWith("milliseconds")) {
            return new Element(this.getTicks() * 50L).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_ticks") || attribute.startsWith("ticks")) {
            return new Element(this.getTicks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("sub") && attribute.hasContext(1)) {
            return new Duration(this.getTicks() - Duration.valueOf(attribute.getContext(1)).getTicks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("add") && attribute.hasContext(1)) {
            return new Duration(this.getTicks() + Duration.valueOf(attribute.getContext(1)).getTicks()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time")) {
            Date currentDate = new Date(this.getTicks() * 50L);
            SimpleDateFormat format = new SimpleDateFormat();
            if ((attribute = attribute.fulfill(1)).startsWith("year")) {
                return new Element(currentDate.getYear() + 1900).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("month")) {
                return new Element(currentDate.getMonth() + 1).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("day")) {
                return new Element(currentDate.getDate()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("hour")) {
                return new Element(currentDate.getHours()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("minute")) {
                return new Element(currentDate.getMinutes()).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("second")) {
                return new Element(currentDate.getSeconds()).getAttribute(attribute.fulfill(1));
            }
            format.applyPattern("EEE, d MMM yyyy HH:mm:ss");
            return new Element(format.format(currentDate)).getAttribute(attribute);
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Duration").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("formatted") || attribute.startsWith("value")) {
            return new Element(this.formatted()).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public String formatted() {
        long seconds = (long)this.seconds;
        long days = seconds / 86400L;
        long hours = (seconds - days * 86400L) / 3600L;
        long minutes = (seconds - days * 86400L - hours * 3600L) / 60L;
        seconds = seconds - days * 86400L - hours * 3600L - minutes * 60L;
        String timeString = "";
        if (days > 0L) {
            timeString = String.valueOf(days) + "d ";
        }
        if (hours > 0L) {
            timeString = timeString + String.valueOf(hours) + "h ";
        }
        if (minutes > 0L && days == 0L) {
            timeString = timeString + String.valueOf(minutes) + "m ";
        }
        if (seconds > 0L && minutes < 10L && hours == 0L && days == 0L) {
            timeString = timeString + String.valueOf(seconds) + "s";
        }
        if (timeString.isEmpty()) {
            timeString = "forever";
        }
        return timeString.trim();
    }
}

