/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ObjectFetcher {
    private static Map<String, Class> objects = new HashMap<String, Class>();
    static Map<Class, Method> matches = new WeakHashMap<Class, Method>();
    static Map<Class, Method> valueof = new WeakHashMap<Class, Method>();
    private static ArrayList<Class> fetchable_objects = new ArrayList();
    static final Pattern PROPERTIES_PATTERN = Pattern.compile("([^\\[]+)\\[(.+=.+)\\]", 42);
    public static final Pattern DESCRIBED_PATTERN = Pattern.compile("[^\\[]+\\[.+=.+\\]", 40);

    public static void _initialize() throws IOException, ClassNotFoundException {
        if (fetchable_objects.isEmpty()) {
            return;
        }
        HashMap<String, Class> adding = new HashMap<String, Class>();
        for (Class dClass : fetchable_objects) {
            try {
                String[] identifiers;
                Method method = dClass.getMethod("valueOf", String.class, TagContext.class);
                if (!method.isAnnotationPresent(Fetchable.class)) continue;
                for (String identifier : identifiers = method.getAnnotation(Fetchable.class).value().split(",")) {
                    adding.put(identifier.trim().toLowerCase(), dClass);
                    dB.log("Registered: " + dClass.getSimpleName() + " as " + identifier);
                }
            }
            catch (Throwable e) {
                dB.echoError("Failed to initialize an object type(" + dClass.getSimpleName() + "): ");
                dB.echoError(e);
            }
        }
        objects.putAll(adding);
        dB.echoApproval("Added objects to the ObjectFetcher " + adding.keySet().toString());
        fetchable_objects.clear();
    }

    public static void _registerCoreObjects() throws NoSuchMethodException, ClassNotFoundException, IOException {
        ObjectFetcher.registerWithObjectFetcher(dList.class);
        ObjectFetcher.registerWithObjectFetcher(dScript.class);
        ObjectFetcher.registerWithObjectFetcher(Element.class);
        ObjectFetcher.registerWithObjectFetcher(Duration.class);
        ObjectFetcher.registerWithObjectFetcher(ScriptQueue.class);
        ObjectFetcher._initialize();
    }

    public static void registerWithObjectFetcher(Class dObject2) {
        try {
            fetchable_objects.add(dObject2);
            matches.put(dObject2, dObject2.getMethod("matches", String.class));
            valueof.put(dObject2, dObject2.getMethod("valueOf", String.class, TagContext.class));
        }
        catch (Throwable e) {
            dB.echoError("Failed to register an object type (" + dObject2.getSimpleName() + "): ");
            dB.echoError(e);
        }
    }

    public static boolean canFetch(String id) {
        return objects.containsKey(CoreUtilities.toLowerCase(id));
    }

    public static Class getObjectClass(String id) {
        if (ObjectFetcher.canFetch(id)) {
            return objects.get(CoreUtilities.toLowerCase(id));
        }
        return null;
    }

    public static boolean checkMatch(Class<? extends dObject> dClass, String value) {
        if (value == null || dClass == null) {
            return false;
        }
        Matcher m = PROPERTIES_PATTERN.matcher(value);
        try {
            return (Boolean)matches.get(dClass).invoke(null, m.matches() ? m.group(1) : value);
        }
        catch (Exception e) {
            dB.echoError(e);
            return false;
        }
    }

    @Deprecated
    public static <T extends dObject> T getObjectFrom(Class<T> dClass, String value) {
        return ObjectFetcher.getObjectFrom(dClass, value, DenizenCore.getImplementation().getTagContext(null));
    }

    public static List<String> separateProperties(String input) {
        if (input.indexOf(91) == -1 || input.lastIndexOf(93) != input.length() - 1) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        int start = 0;
        boolean needObject = true;
        int brackets = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '[' && needObject) {
                needObject = false;
                output.add(input.substring(start, i));
                start = i + 1;
                continue;
            }
            if (input.charAt(i) == '[') {
                ++brackets;
                continue;
            }
            if (input.charAt(i) == ']' && brackets > 0) {
                --brackets;
                continue;
            }
            if (input.charAt(i) != ';' && input.charAt(i) != ']' || brackets != 0) continue;
            output.add(input.substring(start, i));
            start = i + 1;
        }
        return output;
    }

    public static <T extends dObject> T getObjectFrom(Class<T> dClass, String value, TagContext context) {
        try {
            List<String> matches = ObjectFetcher.separateProperties(value);
            boolean matched = matches != null && Adjustable.class.isAssignableFrom(dClass);
            dObject gotten = (dObject)valueof.get(dClass).invoke(null, matched ? matches.get(0) : value, context);
            if (gotten != null && matched) {
                for (int i = 1; i < matches.size(); ++i) {
                    List<String> data = CoreUtilities.split(matches.get(i), '=', 2);
                    if (data.size() != 2) {
                        dB.echoError("Invalid property string '" + matches.get(i) + "'!");
                        continue;
                    }
                    ((Adjustable)((Object)gotten)).applyProperty(new Mechanism(new Element(data.get(0)), new Element(data.get(1).replace('\u2011', ';'))));
                }
            }
            return (T)gotten;
        }
        catch (Exception e) {
            dB.echoError(e);
            return null;
        }
    }

    public static dObject pickObjectFor(String value) {
        Class toFetch;
        Object fetched;
        String type;
        if (value.contains("@") && ObjectFetcher.canFetch(type = value.split("@", 2)[0]) && (fetched = ObjectFetcher.getObjectFrom(toFetch = ObjectFetcher.getObjectClass(type), value)) != null) {
            return fetched;
        }
        return new Element(value);
    }
}

