/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.interfaces.RegistrationableInstance;
import net.aufdemrand.denizencore.interfaces.dRegistry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DefineCommand;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.commands.core.ForeachCommand;
import net.aufdemrand.denizencore.scripts.commands.core.IfCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public abstract class CommandRegistry
implements dRegistry {
    public final Map<String, AbstractCommand> instances = new HashMap<String, AbstractCommand>();
    public final Map<Class<? extends AbstractCommand>, String> classes = new HashMap<Class<? extends AbstractCommand>, String>();

    @Override
    public boolean register(String commandName, RegistrationableInstance commandInstance) {
        this.instances.put(commandName.toUpperCase(), (AbstractCommand)commandInstance);
        this.classes.put(((AbstractCommand)commandInstance).getClass(), commandName.toUpperCase());
        return true;
    }

    public Map<String, AbstractCommand> list() {
        return this.instances;
    }

    @Override
    public AbstractCommand get(String commandName) {
        return this.instances.get(commandName.toUpperCase());
    }

    @Override
    public <T extends RegistrationableInstance> T get(Class<T> clazz) {
        String command = this.classes.get(clazz);
        if (command != null) {
            return (T)((RegistrationableInstance)clazz.cast(this.instances.get(command)));
        }
        return null;
    }

    public void registerCoreCommands() {
        this.registerCoreMember(DefineCommand.class, "DEFINE", "define [<id>] [<value>]", 1);
        this.registerCoreMember(DetermineCommand.class, "DETERMINE", "determine (passively) [<value>]", 1);
        this.registerCoreMember(ForeachCommand.class, "FOREACH", "foreach [stop/next/<object>|...] [<commands>]", 1);
        this.registerCoreMember(IfCommand.class, "IF", "if [<value>] (!)(<operator> <value>) (&&/|| ...) [<commands>] (else <commands>)", 0);
    }

    public <T extends AbstractCommand> void registerCoreMember(Class<T> cmd, String names, String hint, int args) {
        for (String name : names.split(", ")) {
            try {
                ((AbstractCommand)cmd.newInstance()).activate().as(name).withOptions(hint, args);
            }
            catch (Throwable e) {
                dB.echoError("Could not register command " + name + ": " + e.getMessage());
                dB.echoError(e);
            }
        }
    }

    @Override
    public void disableCoreMembers() {
        for (AbstractCommand member : this.instances.values()) {
            try {
                member.onDisable();
            }
            catch (Exception e) {
                dB.echoError("Unable to disable '" + member.getClass().getName() + "'!");
                dB.echoError(e);
            }
        }
    }
}

