/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class Comparable {
    public static final Operator[] OperatorValues = Operator.values();
    public static final Bridge[] BridgeValues = Bridge.values();
    Logic logic = Logic.REGULAR;
    Bridge bridge = Bridge.FIRST;
    Object comparable = null;
    Operator operator = Operator.EQUALS;
    Object comparedto = "true";
    Boolean outcome = null;

    public void setNegativeLogic() {
        this.logic = Logic.NEGATIVE;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setComparable(String arg) {
        this.comparable = arg.length() > 0 && aH.matchesInteger(arg) ? Long.valueOf(aH.getLongFrom(arg)) : (arg.length() > 0 && aH.matchesDouble(arg) ? Double.valueOf(aH.getDoubleFrom(arg)) : (arg.length() > 0 && dList.matches(arg) ? dList.valueOf(arg) : arg));
    }

    public void setComparedto(String arg) {
        if (this.operator == Operator.MATCHES) {
            this.comparable = String.valueOf(this.comparable);
        }
        if (this.comparable instanceof String) {
            this.comparedto = arg;
        } else if (this.comparable instanceof Double || this.comparable instanceof Long) {
            if (aH.matchesInteger(arg)) {
                this.comparedto = aH.getLongFrom(arg);
            } else if (aH.matchesDouble(arg)) {
                this.comparedto = aH.getDoubleFrom(arg);
            } else if (!arg.equalsIgnoreCase("null")) {
                this.comparedto = Double.NaN;
            }
        } else {
            this.comparedto = this.comparable instanceof Boolean ? Boolean.valueOf(aH.getBooleanFrom(arg)) : (this.comparable instanceof dList ? (dList.matches(arg) ? dList.valueOf(arg) : arg) : arg);
        }
    }

    public boolean determineOutcome() {
        this.outcome = false;
        if (this.comparedto.toString().equals("null")) {
            if (this.comparable.toString().equals("null")) {
                this.outcome = true;
            }
        } else if (this.comparable instanceof String) {
            this.compare_as_strings();
        } else if (this.comparable instanceof dList) {
            this.compare_as_list();
        } else if (this.comparable instanceof Double || this.comparable instanceof Long) {
            if (this.comparedto instanceof Double || this.comparedto instanceof Long) {
                this.compare_as_numbers();
            }
        } else if (this.comparable instanceof Boolean && this.comparedto instanceof Boolean) {
            this.outcome = this.comparable.equals(this.comparedto);
        }
        if (this.logic == Logic.NEGATIVE) {
            this.outcome = this.outcome == false;
        }
        return this.outcome;
    }

    private void compare_as_numbers() {
        this.outcome = false;
        Double comparable = this.comparable instanceof Double ? (Double)this.comparable : Double.valueOf(((Long)this.comparable).doubleValue());
        Double comparedto = this.comparedto instanceof Double ? (Double)this.comparedto : Double.valueOf(((Long)this.comparedto).doubleValue());
        switch (this.operator) {
            case EQUALS: {
                if (comparable.doubleValue() != comparedto.doubleValue()) break;
                this.outcome = true;
                break;
            }
            case OR_MORE: {
                if (comparable.compareTo(comparedto) < 0) break;
                this.outcome = true;
                break;
            }
            case OR_LESS: {
                if (comparable.compareTo(comparedto) > 0) break;
                this.outcome = true;
                break;
            }
            case MORE: {
                if (comparable.compareTo(comparedto) <= 0) break;
                this.outcome = true;
                break;
            }
            case LESS: {
                if (comparable.compareTo(comparedto) >= 0) break;
                this.outcome = true;
            }
        }
    }

    private void compare_as_list() {
        this.outcome = false;
        dList comparable = (dList)this.comparable;
        block0 : switch (this.operator) {
            case CONTAINS: {
                for (String string : comparable) {
                    if (this.comparedto instanceof Long) {
                        if (!aH.matchesInteger(string) || aH.getLongFrom(string) != (Long)this.comparedto) continue;
                        this.outcome = true;
                        break block0;
                    }
                    if (this.comparedto instanceof Double) {
                        if (!aH.matchesDouble(string) || aH.getDoubleFrom(string) != (Double)this.comparedto) continue;
                        this.outcome = true;
                        break block0;
                    }
                    if (!(this.comparedto instanceof String) || !string.equalsIgnoreCase((String)this.comparedto)) continue;
                    this.outcome = true;
                    break block0;
                }
                break;
            }
            case OR_MORE: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() >= ((Double)this.comparedto).intValue();
                break;
            }
            case OR_LESS: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() <= ((Double)this.comparedto).intValue();
                break;
            }
            case MORE: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() > ((Double)this.comparedto).intValue();
                break;
            }
            case LESS: {
                if (!(this.comparedto instanceof Double)) break;
                this.outcome = comparable.size() < ((Double)this.comparedto).intValue();
                break;
            }
            case EQUALS: {
                if (!(this.comparedto instanceof dList)) break;
                this.outcome = ((dList)this.comparedto).containsAll(comparable);
            }
        }
    }

    private void compare_as_strings() {
        this.outcome = false;
        String comparable = String.valueOf(this.comparable);
        String comparedto = String.valueOf(this.comparedto);
        if (comparable == null || comparedto == null) {
            return;
        }
        switch (this.operator) {
            case IS_EMPTY: {
                this.outcome = comparable.length() == 0;
                break;
            }
            case EQUALS: {
                this.outcome = comparable.equalsIgnoreCase(comparedto);
                break;
            }
            case CONTAINS: {
                this.outcome = comparable.toLowerCase().contains(comparedto.toLowerCase());
                break;
            }
            case OR_MORE: {
                dB.echoError("Comparing text as if it were a number - calculating based on text length");
                this.outcome = comparable.length() >= comparedto.length();
                break;
            }
            case OR_LESS: {
                dB.echoError("Comparing text as if it were a number - calculating based on text length");
                this.outcome = comparable.length() <= comparedto.length();
                break;
            }
            case MORE: {
                dB.echoError("Comparing text as if it were a number - calculating based on text length");
                this.outcome = comparable.length() > comparedto.length();
                break;
            }
            case LESS: {
                dB.echoError("Comparing text as if it were a number - calculating based on text length");
                this.outcome = comparable.length() < comparedto.length();
                break;
            }
            case MATCHES: {
                comparedto = comparedto.replace("_", "");
                if (comparedto.equalsIgnoreCase("script")) {
                    this.outcome = dScript.matches(comparable);
                    break;
                }
                if (comparedto.equalsIgnoreCase("duration")) {
                    this.outcome = Duration.matches(comparable);
                    break;
                }
                if (comparedto.equalsIgnoreCase("double") || comparedto.equalsIgnoreCase("decimal")) {
                    this.outcome = aH.matchesDouble(comparable);
                    break;
                }
                if (comparedto.equalsIgnoreCase("integer") || comparedto.equalsIgnoreCase("number")) {
                    this.outcome = aH.matchesInteger(comparable);
                    break;
                }
                if (comparedto.equalsIgnoreCase("even integer") || comparedto.equalsIgnoreCase("even number")) {
                    this.outcome = aH.matchesInteger(comparable) && aH.getLongFrom(comparable) % 2L == 0L;
                    break;
                }
                if (comparedto.equalsIgnoreCase("odd integer") || comparedto.equalsIgnoreCase("odd number")) {
                    this.outcome = aH.matchesInteger(comparable) && aH.getLongFrom(comparable) % 2L == 1L;
                    break;
                }
                if (!comparedto.equalsIgnoreCase("boolean")) break;
                this.outcome = comparable.equalsIgnoreCase("true") || comparable.equalsIgnoreCase("false");
            }
        }
    }

    public String log(String str) {
        dB.log("Warning: Unknown comparable type: " + str);
        return str;
    }

    public String toString() {
        return (this.logic != Logic.REGULAR ? "Logic='" + this.logic.toString() + "', " : "") + "Comparable='" + (this.comparable == null ? "null'" : (this.comparable instanceof Double ? "Decimal" : (this.comparable instanceof String ? "Element" : (this.comparable instanceof Long ? "Number" : (this.comparable instanceof dList ? "dList" : this.log(this.comparable.getClass().getSimpleName()))))) + "(<A>" + this.comparable + "<W>)'") + ", Operator='" + this.operator.toString() + "', ComparedTo='" + (this.comparedto == null ? "null'" : (this.comparedto instanceof Double ? "Decimal" : (this.comparedto instanceof String ? "Element" : (this.comparedto instanceof Long ? "Number" : (this.comparedto instanceof dList ? "dList" : this.log(this.comparedto.getClass().getSimpleName()))))) + "(<A>" + this.comparedto + "<W>)' ") + "<Y>--> OUTCOME='" + this.outcome + "'";
    }

    public static enum Logic {
        REGULAR,
        NEGATIVE;

    }

    public static enum Bridge {
        OR,
        AND,
        FIRST,
        THEN,
        ELSE;

    }

    public static enum Operator {
        EQUALS,
        MATCHES,
        OR_MORE,
        OR_LESS,
        MORE,
        LESS,
        CONTAINS,
        IS_EMPTY;

    }
}

