/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.CoreUtilities;

public class Attribute {
    public List<String> attributes;
    public List<String> contexts;
    public List<String> original_attributes;
    public List<String> original_contexts;
    ScriptEntry scriptEntry;
    public String raw_tag;
    String origin;
    int fulfilled = 0;
    public static Pattern CONTEXT_PATTERN = Pattern.compile("\\[.+\\]$", 40);
    private boolean hadAlternative = false;

    private static List<String> separate_attributes(String attributes) {
        ArrayList<String> matches = new ArrayList<String>();
        int x1 = 0;
        int x2 = -1;
        int braced = 0;
        for (int x = 0; x < attributes.length(); ++x) {
            Character chr = Character.valueOf(attributes.charAt(x));
            if (chr.charValue() == '[') {
                ++braced;
            } else if (x == attributes.length() - 1) {
                x2 = x + 1;
            } else if (chr.charValue() == ']') {
                if (braced > 0) {
                    --braced;
                }
            } else if (chr.charValue() == '.' && (attributes.charAt(x + 1) < '0' || attributes.charAt(x + 1) > '9') && braced == 0) {
                x2 = x;
            }
            if (x2 <= -1) continue;
            matches.add(attributes.substring(x1, x2));
            x2 = -1;
            x1 = x + 1;
        }
        return matches;
    }

    public ScriptEntry getScriptEntry() {
        return this.scriptEntry;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Attribute(String attributes, ScriptEntry scriptEntry) {
        this.raw_tag = attributes;
        this.origin = attributes;
        this.scriptEntry = scriptEntry;
        if (attributes == null) {
            this.attributes = Collections.emptyList();
            return;
        }
        this.attributes = Attribute.separate_attributes(attributes);
        this.contexts = new ArrayList<String>(this.attributes.size());
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.contexts.add(null);
        }
        this.original_attributes = new ArrayList<String>(this.attributes);
        this.original_contexts = new ArrayList<String>(this.contexts);
    }

    public boolean matches(String string) {
        if (this.attributes.isEmpty()) {
            return false;
        }
        String attr = this.attributes.get(0);
        if (attr.contains("[") && attr.endsWith("]")) {
            attr = attr.substring(0, attr.indexOf(91));
        }
        return attr.equalsIgnoreCase(string);
    }

    public boolean startsWith(String string) {
        string = CoreUtilities.toLowerCase(string);
        if (this.attributes.isEmpty()) {
            return false;
        }
        return CoreUtilities.toLowerCase(this.raw_tag).startsWith(string);
    }

    public boolean startsWith(String string, int attribute) {
        return CoreUtilities.toLowerCase(this.getAttribute(attribute)).startsWith(string);
    }

    public Attribute fulfill(int attributes) {
        for (int x = attributes; x > 0; --x) {
            this.attributes.remove(0);
            this.contexts.remove(0);
            ++this.fulfilled;
        }
        this.rebuild_raw_tag();
        return this;
    }

    private void rebuild_raw_tag() {
        if (this.attributes.size() == 0) {
            this.raw_tag = "";
        }
        StringBuilder sb = new StringBuilder();
        for (String attribute : this.attributes) {
            sb.append(attribute).append(".");
        }
        this.raw_tag = sb.toString();
        if (this.raw_tag.length() > 1) {
            this.raw_tag = this.raw_tag.substring(0, this.raw_tag.length() - 1);
        }
    }

    public boolean hasContext(int attribute) {
        String text = this.getAttribute(attribute);
        return text.endsWith("]") && text.contains("[");
    }

    public String getContext(int attribute) {
        if (attribute <= this.attributes.size() && attribute > 0 && this.hasContext(attribute)) {
            String text = this.getAttribute(attribute);
            if (this.contexts.get(attribute - 1) != null) {
                return this.contexts.get(attribute - 1);
            }
            Matcher contextMatcher = CONTEXT_PATTERN.matcher(text);
            if (contextMatcher.find()) {
                String tagged = TagManager.cleanOutputFully(TagManager.tag(text.substring(contextMatcher.start() + 1, contextMatcher.end() - 1), DenizenCore.getImplementation().getTagContext(this.scriptEntry)));
                this.contexts.set(attribute - 1, tagged);
                this.original_contexts.set(attribute - 1 + this.fulfilled, tagged);
                return tagged;
            }
        }
        return null;
    }

    public boolean hasAlternative() {
        return this.hadAlternative;
    }

    public void setHadAlternative(boolean hadAlternative) {
        this.hadAlternative = hadAlternative;
    }

    public int getIntContext(int attribute) {
        try {
            if (this.hasContext(attribute)) {
                return Integer.valueOf(this.getContext(attribute));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public double getDoubleContext(int attribute) {
        try {
            if (this.hasContext(attribute)) {
                return Double.valueOf(this.getContext(attribute));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public String getAttribute(int num) {
        if (this.attributes.size() < num || num <= 0) {
            return "";
        }
        return this.attributes.get(num - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.original_attributes.size(); ++i) {
            if (this.original_contexts.get(i) != null) {
                sb.append(this.original_attributes.get(i).substring(0, this.original_attributes.get(i).indexOf(91))).append("[").append(this.original_contexts.get(i)).append("].");
                continue;
            }
            sb.append(this.original_attributes.get(i)).append(".");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }
}

