/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiomeEnterExitScriptEvent
extends ScriptEvent
implements Listener {
    public static BiomeEnterExitScriptEvent instance;
    public dLocation from;
    public dLocation to;
    public Element old_biome;
    public Element new_biome;
    public PlayerMoveEvent event;

    public BiomeEnterExitScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player enters") || lower.startsWith("player exits");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String biome_test = lower.substring(lower.lastIndexOf(" ") + 1);
        String direction = lower.substring(lower.indexOf(" ") + 1, lower.lastIndexOf(" ") - 1);
        return !this.old_biome.toString().toLowerCase().equals(this.new_biome.toString().toLowerCase()) && (biome_test.equals("biome") || direction.equals("enters") && biome_test.equals(this.new_biome.toString().toLowerCase()) || direction.equals("exits") && biome_test.equals(this.old_biome.toString().toLowerCase()));
    }

    @Override
    public String getName() {
        return "BiomeEnterExit";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PlayerMoveEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.event != null ? dEntity.getPlayerFrom((Entity)this.event.getPlayer()) : null, null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("to", this.to);
        context.put("from", this.from);
        context.put("old_biome", this.old_biome);
        context.put("new_biome", this.new_biome);
        return context;
    }

    @EventHandler
    public void onPlayerEntersExitsBiome(PlayerMoveEvent event) {
        this.from = new dLocation(event.getFrom());
        this.to = new dLocation(event.getTo());
        this.old_biome = new Element(this.from.getBlock().getBiome().name());
        this.new_biome = new Element(this.to.getBlock().getBiome().name());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

