/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockBuiltScriptEvent
extends ScriptEvent
implements Listener {
    public static BlockBuiltScriptEvent instance;
    public dLocation location;
    public dMaterial old_material;
    public dMaterial new_material;
    public BlockCanBuildEvent event;

    public BlockBuiltScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains(" being built");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String arg1 = CoreUtilities.getXthArg(0, lower);
        String arg2 = CoreUtilities.getXthArg(4, lower);
        return !(!arg1.equals("block") && !arg1.equals(this.new_material.identifyNoIdentifier()) || lower.contains(" on ") && !arg2.equals("block") && !arg2.equals(this.old_material.identifyNoIdentifier()));
    }

    @Override
    public String getName() {
        return "BlockBuilt";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockCanBuildEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (lower.equals("buildable")) {
            this.cancelled = false;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("new_material", this.new_material);
        context.put("old_material", this.old_material);
        return context;
    }

    @EventHandler
    public void onBlockBuilt(BlockCanBuildEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.old_material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.new_material = dMaterial.getMaterialFrom(event.getMaterial());
        this.cancelled = !event.isBuildable();
        this.event = event;
        this.fire();
        event.setBuildable(!this.cancelled);
    }
}

