/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityChangesBlockScriptEvent
extends ScriptEvent
implements Listener {
    public static EntityChangesBlockScriptEvent instance;
    public dEntity entity;
    public dLocation location;
    public dMaterial old_material;
    public dMaterial new_material;
    public dList cuboids;
    public EntityChangeBlockEvent event;

    public EntityChangesBlockScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String entOne = CoreUtilities.getXthArg(0, lower);
        String mat = CoreUtilities.getXthArg(2, lower);
        List<String> types = Arrays.asList("entity", "player", "npc");
        return !(!CoreUtilities.xthArgEquals(1, lower, "changes") || !types.contains(entOne) && !dEntity.matches(entOne) || !mat.equals("block") && !dMaterial.matches(mat));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String mat;
        String lower = CoreUtilities.toLowerCase(s);
        String entName = CoreUtilities.getXthArg(0, lower);
        if (!this.entity.matchesEntity(entName)) {
            return false;
        }
        String notable = null;
        if (CoreUtilities.xthArgEquals(3, lower, "in")) {
            notable = CoreUtilities.getXthArg(4, lower);
        } else if (CoreUtilities.xthArgEquals(5, lower, "in")) {
            notable = CoreUtilities.getXthArg(6, lower);
        }
        if (notable != null) {
            if (dCuboid.matches(notable)) {
                dCuboid cuboid = dCuboid.valueOf(notable);
                if (!cuboid.isInsideCuboid(this.location)) {
                    return false;
                }
            } else if (dEllipsoid.matches(notable)) {
                dEllipsoid ellipsoid = dEllipsoid.valueOf(notable);
                if (!ellipsoid.contains(this.location)) {
                    return false;
                }
            } else {
                dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "]: '" + s + "' for " + scriptContainer.getName());
                return false;
            }
        }
        return !CoreUtilities.xthArgEquals(3, lower, "into") || (mat = CoreUtilities.getXthArg(4, lower)).equals("block") || mat.equals(this.new_material.identifyFullNoIdentifier());
    }

    @Override
    public String getName() {
        return "EntityChangesBlock";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityChangeBlockEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("cuboids", this.cuboids);
        context.put("location", this.location);
        context.put("new_material", this.new_material);
        context.put("old_material", this.old_material);
        return context;
    }

    @EventHandler
    public void onEntityChangesBlock(EntityChangeBlockEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.location = new dLocation(event.getBlock().getLocation());
        this.old_material = dMaterial.getMaterialFrom(this.location.getBlock().getType(), this.location.getBlock().getData());
        this.new_material = dMaterial.getMaterialFrom(event.getTo());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

