/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPingScriptEvent
extends ScriptEvent
implements Listener {
    public static ListPingScriptEvent instance;
    public Element motd;
    public Element max_players;
    public Element num_players;
    public Element address;
    public ServerListPingEvent event;

    public ListPingScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("server list ping");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    @Override
    public String getName() {
        return "ServerListPing";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        ServerListPingEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            String[] values = determination.split("[\\|" + dList.internal_escape + "]", 2);
            if (new Element(values[0]).isInt()) {
                this.max_players = new Element(values[0]);
                if (values.length == 1) {
                    return true;
                }
            }
            this.motd = values.length == 2 ? new Element(values[1]) : new Element(values[0]);
        }
        return true;
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("motd", this.motd);
        context.put("max_players", this.max_players);
        context.put("num_players", this.num_players);
        context.put("address", this.address);
        return context;
    }

    @EventHandler
    public void onListPing(ServerListPingEvent event) {
        this.motd = new Element(event.getMotd());
        this.max_players = new Element(event.getMaxPlayers());
        this.num_players = new Element(event.getNumPlayers());
        this.address = new Element(event.getAddress().toString());
        this.event = event;
        this.fire();
        event.setMaxPlayers(this.max_players.asInt());
        event.setMotd(this.motd.asString());
    }
}

