/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PotionSplashScriptEvent
extends ScriptEvent
implements Listener {
    public static PotionSplashScriptEvent instance;
    public dItem potion;
    public dList entities;
    public dLocation location;
    public dEntity entity;
    public PotionSplashEvent event;

    public PotionSplashScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(0, lower);
        return lower.equals("potion splash") || lower.equals(mat + " splashes") && dItem.matches(mat);
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.equals("potion splash") || CoreUtilities.getXthArg(0, lower).equals(this.potion.identifyNoIdentifier());
    }

    @Override
    public String getName() {
        return "PotionSplash";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        PotionSplashEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("entities", this.entities);
        context.put("location", this.location);
        context.put("potion", this.potion);
        return context;
    }

    @EventHandler
    public void onPotionSplash(PotionSplashEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.potion = new dItem(event.getPotion().getItem());
        this.location = new dLocation(this.entity.getLocation());
        this.entities = new dList();
        for (LivingEntity e : event.getAffectedEntities()) {
            this.entities.add(new dEntity((Entity)e).identify());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

