/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.scriptevents;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedstoneScriptEvent
extends ScriptEvent
implements Listener {
    public static RedstoneScriptEvent instance;
    public dLocation location;
    public Element old_current;
    public Element new_current;
    public BlockRedstoneEvent event;

    public RedstoneScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("redstone recalculated");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        return true;
    }

    @Override
    public String getName() {
        return "RedstoneRecalculated";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockRedstoneEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        Element power = new Element(determination);
        if (power.isInt()) {
            this.new_current = power;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("old_current", this.old_current);
        context.put("new_current", this.new_current);
        return context;
    }

    @EventHandler
    public void onBlockRedstone(BlockRedstoneEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.old_current = new Element(event.getOldCurrent());
        this.new_current = new Element(event.getNewCurrent());
        this.event = event;
        this.fire();
        event.setNewCurrent(this.new_current.asInt());
    }
}

