/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.DyeColor;

public class dColor
implements dObject {
    static final Pattern rgbPattern = Pattern.compile("(\\d+)[,:](\\d+)[,:](\\d+)");
    private org.bukkit.Color color;
    String prefix = "color";

    public static dColor valueOf(String string) {
        return dColor.valueOf(string, null);
    }

    @Fetchable(value="co")
    public static dColor valueOf(String string, TagContext context) {
        if ((string = string.toUpperCase().replace("CO@", "")).matches("RANDOM")) {
            return new dColor(CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256), CoreUtilities.getRandom().nextInt(256));
        }
        Matcher m = rgbPattern.matcher(string);
        if (m.matches()) {
            return new dColor(aH.getIntegerFrom(m.group(1)), aH.getIntegerFrom(m.group(2)), aH.getIntegerFrom(m.group(3)));
        }
        Field colorField = null;
        try {
            colorField = org.bukkit.Color.class.getField(string.toUpperCase());
        }
        catch (SecurityException e1) {
            dB.echoError("Security exception getting color field!");
        }
        catch (NoSuchFieldException e1) {
            dB.echoError("No such color field!");
        }
        if (colorField != null) {
            return new dColor(colorField);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if ((arg = arg.toUpperCase().replace("CO@", "")).toUpperCase().matches("RANDOM")) {
            return true;
        }
        Matcher m = rgbPattern.matcher(arg);
        if (m.matches()) {
            return true;
        }
        for (Field field : org.bukkit.Color.class.getFields()) {
            if (!arg.toUpperCase().matches(field.getName())) continue;
            return true;
        }
        return false;
    }

    public dColor(int red, int green, int blue) {
        this.color = org.bukkit.Color.fromRGB((int)red, (int)green, (int)blue);
    }

    public dColor(Field field) {
        try {
            this.color = (org.bukkit.Color)field.get(null);
        }
        catch (Exception e) {
            dB.echoError("Exception trying to fetch color!");
        }
    }

    public dColor(org.bukkit.Color color) {
        this.color = color;
    }

    public dColor(DyeColor dyeColor) {
        this.color = dyeColor.getColor();
    }

    public org.bukkit.Color getColor() {
        return this.color;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return this.prefix + "='<A>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return false;
    }

    public String getObjectType() {
        return "Color";
    }

    public String identify() {
        for (Field field : org.bukkit.Color.class.getFields()) {
            try {
                if (((org.bukkit.Color)field.get(null)).asRGB() != this.getColor().asRGB()) continue;
                return "co@" + field.getName();
            }
            catch (Exception e) {
                dB.echoError("Exception trying to fetch color!");
            }
        }
        return "co@" + this.getColor().getRed() + "," + this.getColor().getGreen() + "," + this.getColor().getBlue();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public dObject setPrefix(String prefix) {
        if (prefix != null) {
            this.prefix = prefix;
        }
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute.startsWith("red")) {
            return new Element(this.color.getRed()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("green")) {
            return new Element(this.color.getGreen()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("blue")) {
            return new Element(this.color.getBlue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("rgb")) {
            return new Element(this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("hue")) {
            return new Element(this.ToHSB()[0]).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("saturation")) {
            return new Element(this.ToHSB()[1]).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("brightness")) {
            return new Element(this.ToHSB()[2]).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("hsv")) {
            int[] HSV = this.ToHSB();
            return new Element(HSV[1] + "," + HSV[1] + "," + HSV[2]).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.identify().substring(3)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mix") && attribute.hasContext(1)) {
            dColor mixed_with = dColor.valueOf(attribute.getContext(1));
            if (mixed_with != null) {
                return new dColor(this.color.mixColors(new org.bukkit.Color[]{mixed_with.getColor()})).getAttribute(attribute.fulfill(1));
            }
            dB.echoError("'" + attribute.getContext(1) + "' is not a valid color!");
        }
        if (attribute.startsWith("type")) {
            return new Element("Color").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    int[] ToHSB() {
        float[] base = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        return new int[]{(int)(base[0] * 255.0f), (int)(base[1] * 255.0f), (int)(base[2] * 255.0f)};
    }
}

