/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class dPlugin
implements dObject {
    private Plugin plugin;
    private String prefix = "Plugin";

    public static dPlugin valueOf(String string) {
        return dPlugin.valueOf(string, null);
    }

    @Fetchable(value="pl")
    public static dPlugin valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.toLowerCase().replace("pl@", "");
        try {
            for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
                if (!string.equalsIgnoreCase(plugin.getName())) continue;
                return new dPlugin(plugin);
            }
        }
        catch (Exception e) {
            dB.echoError("Invalid plugin name specified, or plugin is not enabled: " + string);
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg.toLowerCase().startsWith("pl@")) {
            return true;
        }
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            if (!arg.equalsIgnoreCase(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    public dPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getObjectType() {
        return "Plugin";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String debug() {
        return String.format("<G>%s='<Y>%s<G>'  ", this.prefix, this.identify());
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "pl@" + this.plugin.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public dPlugin setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("name")) {
            return new Element(this.plugin.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("version")) {
            return new Element(this.plugin.getDescription().getVersion()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("description")) {
            return new Element(this.plugin.getDescription().getDescription()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("authors")) {
            return new dList(this.plugin.getDescription().getAuthors()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Plugin").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

