/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.entity;

import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class EntityFirework
implements Property {
    dEntity firework;

    public static boolean describes(dObject entity) {
        return entity instanceof dEntity && ((dEntity)entity).getBukkitEntityType() == EntityType.FIREWORK;
    }

    public static EntityFirework getFrom(dObject entity) {
        if (!EntityFirework.describes(entity)) {
            return null;
        }
        return new EntityFirework((dEntity)entity);
    }

    private EntityFirework(dEntity entity) {
        this.firework = entity;
    }

    public String getPropertyString() {
        ItemStack item = new ItemStack(Material.FIREWORK);
        item.setItemMeta((ItemMeta)((Firework)this.firework.getBukkitEntity()).getFireworkMeta());
        return new dItem(item).identify();
    }

    public String getPropertyId() {
        return "firework_item";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("firework_item")) {
            ItemStack item = new ItemStack(Material.FIREWORK);
            item.setItemMeta((ItemMeta)((Firework)this.firework.getBukkitEntity()).getFireworkMeta());
            return new dItem(item).getAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("firework_item") && mechanism.requireObject(dItem.class)) {
            dItem item = mechanism.getValue().asType(dItem.class);
            if (item != null && item.getItemStack().getItemMeta() instanceof FireworkMeta) {
                ((Firework)this.firework.getBukkitEntity()).setFireworkMeta((FireworkMeta)item.getItemStack().getItemMeta());
            } else {
                dB.echoError("'" + mechanism.getValue().asString() + "' is not a valid firework item.");
            }
        }
        if (mechanism.matches("detonate")) {
            ((Firework)this.firework.getBukkitEntity()).detonate();
        }
    }
}

