/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.tags.core;

import java.util.HashMap;
import java.util.Map;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.core.TaskScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.ReplaceableTagEvent;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class ContextTags {
    public ContextTags() {
        TagManager.registerTagEvents(this);
    }

    @TagManager.TagEvents
    public void contextTags(ReplaceableTagEvent event) {
        if (!event.matches("context", "c") || event.getScriptEntry() == null) {
            return;
        }
        String object = event.getType();
        if (event.getScriptEntry().getResidingQueue().hasContext(object)) {
            Attribute attribute = event.getAttributes();
            event.setReplaced(event.getScriptEntry().getResidingQueue().getContext(object).getAttribute(attribute.fulfill(2)));
            return;
        }
        if (!ScriptRegistry.containsScript(event.getScriptEntry().getScript().getName(), TaskScriptContainer.class)) {
            return;
        }
        TaskScriptContainer script = (TaskScriptContainer)ScriptRegistry.getScriptContainer(event.getScriptEntry().getScript().getName());
        ScriptEntry entry = event.getScriptEntry();
        if (entry.hasObject("CONTEXT")) {
            Map<String, Integer> id;
            HashMap context = (HashMap)entry.getObject("CONTEXT");
            if (context.containsKey(String.valueOf((id = script.getContextMap()).get(object.toUpperCase())))) {
                event.setReplaced((String)context.get(String.valueOf(id.get(object.toUpperCase()))));
            }
        } else {
            return;
        }
    }

    @TagManager.TagEvents
    public void savedEntryTags(ReplaceableTagEvent event) {
        if (!event.matches("entry", "e") || event.getScriptEntry() == null || !event.hasNameContext()) {
            return;
        }
        if (event.getScriptEntry().getResidingQueue() != null) {
            String id = event.getNameContext();
            Attribute attribute = event.getAttributes();
            ScriptEntry held = event.getScriptEntry().getResidingQueue().getHeldScriptEntry(id);
            if (held == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Bad saved entry ID '" + id + "'");
            } else if (!held.hasObject(attribute.getAttribute(2)) || held.getdObject(attribute.getAttribute(2)) == null) {
                dB.echoDebug((Debuggable)event.getScriptEntry(), "Missing saved entry object '" + attribute.getAttribute(2) + "'");
            } else {
                event.setReplaced(held.getdObject(attribute.getAttribute(2)).getAttribute(attribute.fulfill(2)));
            }
        }
    }
}

