/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockDispensesScriptEvent
extends ScriptEvent
implements Listener {
    public static BlockDispensesScriptEvent instance;
    public dLocation location;
    public dItem item;
    public Vector velocity;
    public Double power;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains(" dispenses ");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String arg1 = CoreUtilities.getXthArg(0, lower);
        String arg2 = CoreUtilities.getXthArg(2, lower);
        return !(!arg1.equals("block") && !arg1.equals(this.item.identifyNoIdentifier()) || !arg2.equals("item") && !arg2.equals(this.item.identifyNoIdentifier()));
    }

    @Override
    public String getName() {
        return "BlockDispenses";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockDispenseEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            this.power = aH.getDoubleFrom(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("item", this.item);
        return context;
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.item = new dItem(event.getItem());
        this.velocity = event.getVelocity();
        this.cancelled = event.isCancelled();
        this.power = null;
        this.event = event;
        this.fire();
        if (this.power != null) {
            event.setVelocity(this.velocity.multiply(this.power.doubleValue()));
        }
        event.setCancelled(this.cancelled);
    }
}

