/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityExplodesScriptEvent
extends ScriptEvent
implements Listener {
    public static EntityExplodesScriptEvent instance;
    public dEntity entity;
    public dList blocks;
    public dLocation location;
    public Float strength;
    private Boolean blockSet;
    public EntityExplodeEvent event;

    public EntityExplodesScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String entOne = CoreUtilities.getXthArg(0, lower);
        List<String> types = Arrays.asList("entity", "player", "npc");
        return (types.contains(entOne) || dEntity.matches(entOne)) && cmd.equals("explodes");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String target = CoreUtilities.getXthArg(0, CoreUtilities.toLowerCase(s));
        List<String> types = Arrays.asList("entity", "player", "npc");
        return types.contains(target) || this.entity.matchesEntity(target);
    }

    @Override
    public String getName() {
        return "EntityExplodes";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityExplodeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Float)) {
            this.strength = Float.valueOf(aH.getFloatFrom(determination));
            return true;
        }
        if (dList.matches(determination)) {
            this.blocks = new dList();
            this.blockSet = true;
            for (String loc : dList.valueOf(determination)) {
                dLocation location = dLocation.valueOf(loc);
                if (location == null) {
                    dB.echoError("Invalid location '" + loc + "' check [" + this.getName() + "]: '  for " + container.getName());
                    continue;
                }
                this.blocks.add(location.identifySimple());
            }
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("location", this.location);
        context.put("blocks", this.blocks);
        context.put("strength", new Element(this.strength));
        return context;
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.location = new dLocation(event.getLocation());
        this.strength = Float.valueOf(event.getYield());
        this.blocks = new dList();
        this.blockSet = false;
        for (Block block : event.blockList()) {
            this.blocks.add(new dLocation(block.getLocation()).identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        if (this.blockSet.booleanValue()) {
            event.blockList().clear();
            if (this.blocks.size() > 0) {
                event.blockList().clear();
                for (String loc : this.blocks) {
                    dLocation location = dLocation.valueOf(loc);
                    event.blockList().add(location.getWorld().getBlockAt((Location)location));
                }
            }
        }
        event.setYield(this.strength.floatValue());
    }
}

