/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTargetsScriptEvent
extends ScriptEvent
implements Listener {
    public static EntityTargetsScriptEvent instance;
    public dEntity entity;
    public Element reason;
    public dEntity target;
    public dList cuboids;
    private dLocation location;
    public EntityTargetEvent event;

    public EntityTargetsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String attacker = CoreUtilities.getXthArg(0, lower);
        String cmd = CoreUtilities.getXthArg(1, lower);
        List<String> types = Arrays.asList("entity", "player", "npc");
        return cmd.equals("targets") && (types.contains(attacker) || dEntity.matches(attacker));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String it;
        Integer end;
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.entity.matchesEntity(CoreUtilities.getXthArg(0, lower))) {
            return false;
        }
        String victim = CoreUtilities.getXthArg(2, lower);
        if (!(victim.equals("in") || victim.equals("because") || this.target == null || victim.length() <= 0 || this.target.matchesEntity(victim))) {
            return false;
        }
        Integer pos = lower.indexOf(" in ") + 4;
        if (pos > 4) {
            end = lower.indexOf(" ", (int)pos) < 0 ? lower.length() : lower.indexOf(" ", (int)pos);
            it = lower.substring(pos, end);
            if (dCuboid.matches(it)) {
                dCuboid cuboid = dCuboid.valueOf(it);
                if (!cuboid.isInsideCuboid(this.location)) {
                    return false;
                }
            } else if (dEllipsoid.matches(it)) {
                dEllipsoid ellipsoid = dEllipsoid.valueOf(it);
                if (!ellipsoid.contains(this.location)) {
                    return false;
                }
            } else {
                dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "]: '" + s + "' for " + scriptContainer.getName());
                return false;
            }
        }
        if ((pos = Integer.valueOf(lower.indexOf(" because ") + 9)) > 9) {
            end = lower.indexOf(" ", (int)pos) < 0 ? lower.length() : lower.indexOf(" ", (int)pos);
            it = lower.substring(pos, end);
            if (!it.equals(this.reason.toString().toLowerCase())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "EntityTargets";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityTargetEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dEntity.matches(determination)) {
            this.target = dEntity.valueOf(determination);
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("reason", this.reason);
        if (this.target != null) {
            context.put("target", this.target);
        }
        context.put("cuboids", this.cuboids);
        return context;
    }

    @EventHandler
    public void onEntityTargets(EntityTargetEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.reason = new Element(event.getReason().toString());
        this.target = event.getTarget() != null ? new dEntity(event.getTarget()) : null;
        this.location = new dLocation(event.getEntity().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

