/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VehicleCollidesEntityScriptEvent
extends ScriptEvent
implements Listener {
    public static VehicleCollidesEntityScriptEvent instance;
    public dEntity vehicle;
    public dEntity entity;
    public Boolean pickup_cancel;
    public VehicleEntityCollisionEvent event;

    public VehicleCollidesEntityScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String arg = lower.substring(lower.lastIndexOf("with ") + 5);
        return lower.contains(" collides with ") && (arg.equals("entity") || dEntity.matches(arg));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String ent = CoreUtilities.getXthArg(0, s);
        if (!this.vehicle.matchesEntity(ent)) {
            return false;
        }
        ent = CoreUtilities.getXthArg(0, s);
        return this.entity.matchesEntity(ent);
    }

    @Override
    public String getName() {
        return "VehicleCollidesEntity";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        VehicleEntityCollisionEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        aH.Argument arg = aH.Argument.valueOf(determination);
        if (arg.matchesPrefix("pickup")) {
            this.pickup_cancel = !arg.asElement().asBoolean();
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null, this.entity.isCitizensNPC() ? this.entity.getDenizenNPC() : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("vehicle", this.vehicle);
        context.put("entity", this.entity);
        context.put("pickup", new Element(this.pickup_cancel == false));
        return context;
    }

    @EventHandler
    public void onVehicleCollidesEntity(VehicleEntityCollisionEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.vehicle = new dEntity((Entity)event.getVehicle());
        this.pickup_cancel = event.isPickupCancelled();
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setPickupCancelled(this.pickup_cancel.booleanValue());
    }
}

