/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.Arrays;
import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.tags.core.EscapeTags;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerChangesSignScriptEvent
extends ScriptEvent
implements Listener {
    public static PlayerChangesSignScriptEvent instance;
    public dLocation location;
    public dList new_sign;
    public dList old_sign;
    public dMaterial material;
    public dList cuboids;
    private dList new_text;
    public SignChangeEvent event;

    public PlayerChangesSignScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String sign = CoreUtilities.getXthArg(2, lower);
        return lower.startsWith("player changes") && (sign.equals("sign") || dMaterial.matches(sign));
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(2, lower);
        if (!(mat.equals("sign") || mat.equals(this.material.identifyNoIdentifier()) || this.event.getBlock().getState() instanceof Sign)) {
            return false;
        }
        if (CoreUtilities.xthArgEquals(3, lower, "in")) {
            String it = CoreUtilities.getXthArg(4, lower);
            if (dCuboid.matches(it)) {
                dCuboid cuboid = dCuboid.valueOf(it);
                if (!cuboid.isInsideCuboid(this.location)) {
                    return false;
                }
            } else if (dEllipsoid.matches(it)) {
                dEllipsoid ellipsoid = dEllipsoid.valueOf(it);
                if (!ellipsoid.contains(this.location)) {
                    return false;
                }
            } else {
                dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "]: '" + s + "' for " + scriptContainer.getName());
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return "PlayerChangesSign";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        SignChangeEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (determination.length() > 0 && !determination.equalsIgnoreCase("none")) {
            this.new_text = dList.valueOf(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("material", this.material);
        context.put("new_sign", this.new_sign);
        context.put("old_sign", this.old_sign);
        context.put("cuboids", this.cuboids);
        return context;
    }

    @EventHandler
    public void onPlayerChangesSign(SignChangeEvent event) {
        Sign sign = (Sign)event.getBlock().getState();
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.location = new dLocation(event.getBlock().getLocation());
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.old_sign = new dList(Arrays.asList(sign.getLines()));
        this.new_sign = new dList(Arrays.asList(event.getLines()));
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        if (this.new_text != null) {
            for (int i = 0; i < 4 && i < this.new_text.size(); ++i) {
                event.setLine(i, EscapeTags.unEscape((String)this.new_text.get(i)));
            }
        }
    }
}

