/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnaceSmeltsItemScriptEvent
extends ScriptEvent
implements Listener {
    public static FurnaceSmeltsItemScriptEvent instance;
    public dItem source_item;
    public dItem result_item;
    public dLocation location;
    public FurnaceSmeltEvent event;

    public FurnaceSmeltsItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.toLowerCase(s).startsWith("furnace smelts");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String srcItem = CoreUtilities.getXthArg(2, lower);
        if (!(srcItem.equals("item") || dItem.matches(srcItem) || srcItem.equals(this.source_item.identifyNoIdentifier()))) {
            return false;
        }
        String resItem = CoreUtilities.getXthArg(4, lower);
        return resItem.equals("item") || dItem.matches(resItem) || resItem.equals(this.result_item.identifyNoIdentifier());
    }

    @Override
    public String getName() {
        return "FurnaceSmelts";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        FurnaceSmeltEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.result_item = dItem.valueOf(determination);
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("source_item", this.source_item);
        context.put("result_item", this.result_item);
        return context;
    }

    @EventHandler
    public void onFurnaceSmelts(FurnaceSmeltEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.source_item = new dItem(event.getSource());
        this.result_item = new dItem(event.getResult());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setResult(this.result_item.getItemStack());
        event.setCancelled(this.cancelled);
    }
}

