/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemMoveScriptEvent
extends ScriptEvent
implements Listener {
    public static ItemMoveScriptEvent instance;
    public dInventory origin;
    public dInventory destination;
    public dInventory initiator;
    public dItem item;
    public boolean itemSet;
    public InventoryMoveItemEvent event;

    public ItemMoveScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("moves from");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String itemName = this.item.getMaterialName();
        String originType = this.origin.getInventoryType().name();
        String destinationType = this.destination.getInventoryType().name();
        return lower.equals("item moves from inventory") || lower.equals(itemName + " moves from inventory") || lower.equals(itemName + " moves from " + originType) || lower.equals(itemName + " moves from " + originType + " to " + destinationType) || lower.equals(itemName + " moves from inventory to " + destinationType) || lower.equals("item moves from " + originType) || lower.equals("item moves from " + originType + " to " + destinationType) || lower.equals("item moves from inventory to " + destinationType);
    }

    @Override
    public String getName() {
        return "ItemMoves";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        InventoryMoveItemEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (dItem.matches(determination)) {
            this.item = dItem.valueOf(determination);
            this.itemSet = true;
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("origin", this.origin);
        context.put("destination", this.destination);
        context.put("initiator", this.initiator);
        context.put("item", this.item);
        return context;
    }

    @EventHandler
    public void onInventoryMoveItemEvent(InventoryMoveItemEvent event) {
        this.origin = dInventory.mirrorBukkitInventory(event.getSource());
        this.destination = dInventory.mirrorBukkitInventory(event.getDestination());
        this.initiator = dInventory.mirrorBukkitInventory(event.getInitiator());
        this.item = new dItem(event.getItem());
        this.itemSet = false;
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
        if (this.itemSet) {
            event.setItem(this.item.getItemStack());
        }
    }
}

