/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.scripts.commands.Holdable;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.npc.ai.BlockBreaker;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;

public class BreakCommand
extends AbstractCommand
implements Holdable {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("entity") && arg.matchesArgumentType(dEntity.class)) {
                scriptEntry.addObject("entity", arg.asType(dEntity.class));
                continue;
            }
            if (!scriptEntry.hasObject("radius") && arg.matchesPrimitive(aH.PrimitiveType.Double)) {
                scriptEntry.addObject("radius", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Must specify a location!");
        }
        scriptEntry.defaultObject("entity", ((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getDenizenEntity() : null);
        if (!scriptEntry.hasObject("entity")) {
            throw new InvalidArgumentsException("Must specify an entity!");
        }
        scriptEntry.defaultObject("radius", new Element(2));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getObject("location");
        final dEntity entity = (dEntity)scriptEntry.getObject("entity");
        Element radius = scriptEntry.getElement("radius");
        final HashMap<String, dObject> context = new HashMap<String, dObject>();
        dMaterial material = dMaterial.getMaterialFrom(location.getBlock().getType(), location.getBlock().getData());
        context.put("location", location);
        context.put("material", material);
        dB.report(scriptEntry, this.getName(), location.debug() + entity.debug() + radius.debug());
        final ScriptEntry se = scriptEntry;
        BlockBreaker.Configuration config = new BlockBreaker.Configuration();
        config.item(entity.getLivingEntity().getEquipment().getItemInHand());
        config.radius(radius.asDouble());
        config.callback(new Runnable(){

            public void run() {
                if (entity.isCitizensNPC()) {
                    DenizenAPI.getDenizenNPC(entity.getDenizenNPC().getCitizen()).action("dig", null, context);
                    se.setFinished(true);
                }
            }
        });
        BlockBreaker breaker = BlockBreaker.createWithConfiguration((LivingEntity)entity.getLivingEntity(), (Block)location.getBlock(), (BlockBreaker.Configuration)config);
        if (breaker.shouldExecute()) {
            TaskRunnable run = new TaskRunnable(breaker);
            run.taskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), (Runnable)run, 0L, 1L);
        }
    }

    private static class TaskRunnable
    implements Runnable {
        private int taskId;
        private final BlockBreaker breaker;

        public TaskRunnable(BlockBreaker breaker) {
            this.breaker = breaker;
        }

        public void run() {
            if (this.breaker.run() != BehaviorStatus.RUNNING) {
                Bukkit.getScheduler().cancelTask(this.taskId);
                this.breaker.reset();
            }
        }
    }
}

