/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.objects;

import java.util.List;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import org.json.JSONObject;

public class dScript
implements dObject {
    private ScriptContainer container;
    private String prefix = "Container";
    private boolean valid = false;
    private String name = null;

    public static dScript valueOf(String string) {
        return dScript.valueOf(string, null);
    }

    @Fetchable(value="s")
    public static dScript valueOf(String string, TagContext context) {
        dScript script;
        if (string.startsWith("s@")) {
            string = string.substring(2);
        }
        if ((script = new dScript(string)).isValid()) {
            return script;
        }
        return null;
    }

    public static boolean matches(String string) {
        if (string.toLowerCase().startsWith("s@")) {
            return true;
        }
        dScript script = new dScript(string);
        return script.isValid();
    }

    public dScript(String scriptName) {
        if (ScriptRegistry.getScriptContainer(scriptName) != null) {
            this.container = ScriptRegistry.getScriptContainer(scriptName);
            this.name = scriptName.toUpperCase();
            this.valid = true;
        }
    }

    public dScript(ScriptContainer container) {
        this.container = container;
        this.name = container.getName().toUpperCase();
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getType() {
        return this.container != null ? this.container.getContainerType() : "invalid";
    }

    public String getName() {
        return this.name;
    }

    public ScriptContainer getContainer() {
        return this.container;
    }

    @Override
    public String getObjectType() {
        return "Container";
    }

    @Override
    public String identify() {
        return "s@" + this.name;
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dObject setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return String.format("<G>%s='<A>%s<Y>(%s)<G>'  ", this.prefix, this.name, this.getType());
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("container_type")) {
            return new Element(this.container.getContainerType()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.name).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("relative_filename")) {
            try {
                return new Element(this.container.getFileName().replace(DenizenCore.getImplementation().getScriptFolder().getParentFile().getCanonicalPath(), "").replace("\\", "/")).getAttribute(attribute.fulfill(1));
            }
            catch (Exception e) {
                dB.echoError(e);
            }
        }
        if (attribute.startsWith("filename")) {
            return new Element(this.container.getFileName().replace("\\", "/")).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("original_name")) {
            return new Element(this.container.getOriginalName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cons")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            YamlConfiguration section = this.getContainer().getConfigurationSection("default constants");
            if (section == null) {
                return null;
            }
            Object obj = section.get(attribute.getContext(1).toUpperCase());
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                dList list = new dList();
                for (Object each : (List)obj) {
                    if (each == null) {
                        each = "null";
                    }
                    list.add(TagManager.tag(each.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
                }
                return list.getAttribute(attribute.fulfill(1));
            }
            return new Element(TagManager.tag(obj.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry()))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("yaml_key") && attribute.hasContext(1)) {
            ScriptContainer container = this.getContainer();
            if (container == null) {
                dB.echoError("Missing script container?!");
                return new Element(this.identify()).getAttribute(attribute);
            }
            YamlConfiguration section = container.getConfigurationSection("");
            if (section == null) {
                dB.echoError("Missing YAML section?!");
                return new Element(this.identify()).getAttribute(attribute);
            }
            Object obj = section.get(attribute.getContext(1).toUpperCase());
            if (obj == null) {
                return null;
            }
            if (obj instanceof List) {
                dList list = new dList();
                for (Object each : (List)obj) {
                    if (each == null) {
                        each = "null";
                    }
                    list.add(TagManager.tag(each.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry())));
                }
                return list.getAttribute(attribute.fulfill(1));
            }
            return new Element(TagManager.tag(obj.toString(), DenizenCore.getImplementation().getTagContext(attribute.getScriptEntry()))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_keys")) {
            return new dList(this.getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "").getKeys(false)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_deep_keys")) {
            return new dList(this.getContainer().getConfigurationSection(attribute.hasContext(1) ? attribute.getContext(1) : "").getKeys(true)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("to_json")) {
            JSONObject jsobj = new JSONObject(this.container.getConfigurationSection("").getMap());
            jsobj.remove("TYPE");
            return new Element(jsobj.toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Script").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }
}

