/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import net.aufdemrand.denizencore.exceptions.ScriptEntryCreationException;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public abstract class BracedCommand
extends AbstractCommand {
    public static List<BracedData> getBracedCommands(ScriptEntry scriptEntry) {
        aH.Argument arg;
        int i;
        boolean hyperdebug = dB.verbose;
        ArrayList<BracedData> bracedSections = new ArrayList<BracedData>();
        List<BracedData> entryBracedSet = scriptEntry.getBracedSet();
        if (entryBracedSet != null) {
            try {
                for (BracedData entry : entryBracedSet) {
                    ArrayList<ScriptEntry> array = new ArrayList<ScriptEntry>(entry.value.size());
                    for (ScriptEntry sEntry : entry.value) {
                        ScriptEntry newEntry = sEntry.clone();
                        newEntry.entryData.transferDataFrom(scriptEntry.entryData);
                        array.add(newEntry);
                    }
                    BracedData data = new BracedData();
                    data.key = entry.key;
                    data.args = new ArrayList<String>(entry.args);
                    data.value = array;
                    bracedSections.add(data);
                }
                return bracedSections;
            }
            catch (CloneNotSupportedException e) {
                dB.echoError(scriptEntry.getResidingQueue(), e);
            }
        }
        TreeMap commandList = new TreeMap();
        int bracesEntered = 0;
        boolean newCommand = true;
        boolean waitingForDash = false;
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "Starting getBracedCommands...");
        }
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "...with first command name: " + scriptEntry.getCommandName());
        }
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "...with first command arguments: " + scriptEntry.getArguments());
        }
        ScriptEntry entry = scriptEntry;
        if (hyperdebug) {
            dB.echoDebug((Debuggable)scriptEntry, "Entry found: " + entry.getCommandName());
        }
        List<aH.Argument> argList = aH.interpret(entry.getArguments());
        String bracesName = scriptEntry.getCommandName().toUpperCase();
        ArrayList<String> bracesArgs = new ArrayList<String>();
        bracesArgs.add(bracesName);
        int startArg = 0;
        for (i = 0; i < argList.size(); ++i) {
            arg = argList.get(i);
            if (!arg.asElement().asString().equals("{")) continue;
            startArg = i;
            break;
        }
        for (i = startArg; i < argList.size(); ++i) {
            arg = argList.get(i);
            if (hyperdebug) {
                dB.echoDebug((Debuggable)scriptEntry, "Arg found: " + arg.raw_value);
            }
            if (arg.matches("{")) {
                newCommand = false;
                boolean bl = waitingForDash = ++bracesEntered == 1;
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Opened brace; " + String.valueOf(bracesEntered) + " now");
                }
                if (bracesEntered <= 1) continue;
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                continue;
            }
            if (arg.matches("}")) {
                --bracesEntered;
                newCommand = false;
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Closed brace; " + String.valueOf(bracesEntered) + " now");
                }
                if (bracesEntered > 0) {
                    ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                    continue;
                }
                BracedData temp = new BracedData();
                temp.key = bracesName;
                if (bracedSections.contains(temp)) {
                    dB.echoError(scriptEntry.getResidingQueue(), "You may not have braced commands with the same arguments.");
                    break;
                }
                ArrayList<ScriptEntry> bracesSection = new ArrayList<ScriptEntry>();
                for (ArrayList command : commandList.values()) {
                    try {
                        if (command.isEmpty()) {
                            if (!hyperdebug) continue;
                            dB.echoError(scriptEntry.getResidingQueue(), "Empty command?");
                            continue;
                        }
                        String cmd = (String)command.get(0);
                        if (hyperdebug) {
                            dB.echoDebug((Debuggable)scriptEntry, "Calculating " + cmd);
                        }
                        command.remove(0);
                        String[] args = new String[command.size()];
                        args = command.toArray(args);
                        bracesSection.add(new ScriptEntry(cmd, args, scriptEntry.getScript() != null ? scriptEntry.getScript().getContainer() : null));
                        bracesSection.get((int)(bracesSection.size() - 1)).entryData.transferDataFrom(scriptEntry.entryData);
                        if (!hyperdebug) continue;
                        dB.echoDebug((Debuggable)scriptEntry, "Command added: " + cmd + ", with " + String.valueOf(args.length) + " arguments");
                    }
                    catch (ScriptEntryCreationException e) {
                        dB.echoError(scriptEntry.getResidingQueue(), e.getMessage());
                    }
                }
                if (hyperdebug) {
                    dB.echoDebug((Debuggable)scriptEntry, "Adding section " + bracesName);
                }
                BracedData bd = new BracedData();
                bd.key = bracesName;
                bd.args = bracesArgs;
                bd.value = bracesSection;
                bracedSections.add(bd);
                bracesName = "";
                bracesArgs = new ArrayList();
                commandList = new TreeMap();
                continue;
            }
            if (newCommand && bracesEntered == 1) {
                commandList.put(commandList.size(), new ArrayList());
                ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
                newCommand = false;
                if (!hyperdebug) continue;
                dB.echoDebug((Debuggable)scriptEntry, "Treating as new command");
                continue;
            }
            if (arg.matches("-") && bracesEntered == 1) {
                newCommand = true;
                waitingForDash = false;
                if (!hyperdebug) continue;
                dB.echoDebug((Debuggable)scriptEntry, "Assuming following is a new command");
                continue;
            }
            if (bracesEntered == 0) {
                bracesName = bracesName + arg.raw_value + " ";
                bracesArgs.add(arg.raw_value);
                continue;
            }
            if (waitingForDash) {
                dB.echoError(scriptEntry.getResidingQueue(), "Malformed braced section! Missing a - symbol!");
                break;
            }
            newCommand = false;
            ((ArrayList)commandList.get(commandList.lastKey())).add(arg.raw_value);
            if (!hyperdebug) continue;
            dB.echoDebug((Debuggable)scriptEntry, "Adding to the command");
        }
        scriptEntry.setBracedSet(bracedSections);
        return bracedSections;
    }

    public static class BracedData {
        public String key;
        public List<String> args;
        public List<ScriptEntry> value;

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BracedData) {
                return this.key.equals(((BracedData)o).key);
            }
            return false;
        }
    }
}

