/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import java.util.HashMap;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockPhysicsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockPhysicsScriptEvent instance;
    public dLocation location;
    public dMaterial new_material;
    public dMaterial old_material;
    public BlockPhysicsEvent event;

    public BlockPhysicsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("physics");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        dMaterial mat;
        String lower = CoreUtilities.toLowerCase(s);
        if (lower.equals("block physics")) {
            return true;
        }
        if (!lower.startsWith("block") && !this.old_material.matchesMaterialData((mat = dMaterial.valueOf(CoreUtilities.getXthArg(0, lower))).getMaterialData())) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    @Override
    public String getName() {
        return "BlockPhysics";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockPhysicsEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("new_material", this.new_material);
        return context;
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.new_material = dMaterial.getMaterialFrom(event.getChangedType());
        this.old_material = dMaterial.getMaterialFrom(this.location.getBlock().getType(), this.location.getBlock().getData());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

