/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HangingBreaksScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HangingBreaksScriptEvent instance;
    public Element cause;
    public dEntity entity;
    public dEntity hanging;
    public dList cuboids;
    public dLocation location;
    public HangingBreakEvent event;

    public HangingBreaksScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("breaks");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String hangCheck = CoreUtilities.getXthArg(0, lower);
        if (!hangCheck.equals("hanging") && this.hanging.matchesEntity(hangCheck)) {
            return false;
        }
        if (CoreUtilities.xthArgEquals(2, lower, "because") && !CoreUtilities.getXthArg(3, lower).equals(CoreUtilities.toLowerCase(this.cause.asString()))) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.location);
    }

    @Override
    public String getName() {
        return "HangingBreaks";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        HangingBreakEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("cause", this.cause);
        context.put("entity", this.entity);
        context.put("hanging", this.hanging);
        context.put("cuboids", this.cuboids);
        context.put("location", this.location);
        return context;
    }

    @EventHandler
    public void onHangingBreaks(HangingBreakEvent event) {
        this.hanging = new dEntity((Entity)event.getEntity());
        this.cause = new Element(event.getCause().name());
        this.location = new dLocation(this.hanging.getLocation());
        if (event instanceof HangingBreakByEntityEvent) {
            this.entity = new dEntity(((HangingBreakByEntityEvent)event).getRemover());
        }
        this.cuboids = new dList();
        for (dCuboid cuboid : dCuboid.getNotableCuboidsContaining(this.location)) {
            this.cuboids.add(cuboid.identifySimple());
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

