/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.scripts.commands.core.FailCommand;
import net.aufdemrand.denizen.scripts.commands.core.FinishCommand;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.PlayerProfileEditor;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.nbt.ImprovedOfflinePlayer;
import net.aufdemrand.denizen.utilities.packets.ActionBar;
import net.aufdemrand.denizen.utilities.packets.BossHealthBar;
import net.aufdemrand.denizen.utilities.packets.DisplayHeaderFooter;
import net.aufdemrand.denizen.utilities.packets.EntityEquipment;
import net.aufdemrand.denizen.utilities.packets.ItemChangeMessage;
import net.aufdemrand.denizen.utilities.packets.OpenBook;
import net.aufdemrand.denizen.utilities.packets.PlayerBars;
import net.aufdemrand.denizen.utilities.packets.PlayerSpectateEntity;
import net.aufdemrand.denizen.utilities.packets.SignEditor;
import net.aufdemrand.denizen.utilities.packets.SignUpdate;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutGameStateChange;
import org.bukkit.Achievement;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.map.MapView;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.BlockIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class dPlayer
implements dObject,
Adjustable {
    static Map<String, UUID> playerNames = new HashMap<String, UUID>();
    OfflinePlayer offlinePlayer = null;
    private String prefix = "Player";

    public static dPlayer mirrorBukkitPlayer(OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        return new dPlayer(player);
    }

    public static void notePlayer(OfflinePlayer player) {
        if (player.getName() == null) {
            dB.echoError("Null player " + player.toString());
            return;
        }
        if (!playerNames.containsKey(player.getName().toLowerCase())) {
            playerNames.put(player.getName().toLowerCase(), player.getUniqueId());
        }
    }

    public static boolean isNoted(OfflinePlayer player) {
        return playerNames.containsValue(player.getUniqueId());
    }

    public static Map<String, UUID> getAllPlayers() {
        return playerNames;
    }

    public static dPlayer valueOf(String string) {
        return dPlayer.valueOf(string, null);
    }

    @Fetchable(value="p")
    public static dPlayer valueOf(String string, TagContext context) {
        return dPlayer.valueOfInternal(string, context == null || context.debug);
    }

    static dPlayer valueOfInternal(String string, boolean announce) {
        if (string == null) {
            return null;
        }
        if ((string = string.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null) {
                    return new dPlayer(player);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (playerNames.containsKey(string.toLowerCase())) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)playerNames.get(string.toLowerCase()));
            return new dPlayer(player);
        }
        if (announce) {
            dB.echoError("Invalid Player! '" + string + "' could not be found.");
        }
        return null;
    }

    public static boolean matches(String arg) {
        if (arg == null) {
            return false;
        }
        if (arg.toLowerCase().startsWith("p@")) {
            return true;
        }
        if ((arg = arg.replace("p@", "").replace("P@", "")).indexOf(45) >= 0) {
            try {
                OfflinePlayer player;
                UUID uuid = UUID.fromString(arg);
                if (uuid != null && (player = Bukkit.getOfflinePlayer((UUID)uuid)) != null && player.hasPlayedBefore()) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean playerNameIsValid(String name) {
        return playerNames.containsKey(name.toLowerCase());
    }

    public dPlayer(OfflinePlayer player) {
        this.offlinePlayer = player;
    }

    public dPlayer(UUID uuid) {
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)uuid);
    }

    public dPlayer(Player player) {
        this((OfflinePlayer)player);
        if (dEntity.isNPC((Entity)player)) {
            throw new IllegalStateException("NPCs are not allowed as dPlayer objects!");
        }
    }

    public boolean isValid() {
        return this.getPlayerEntity() != null || this.getOfflinePlayer() != null;
    }

    public Player getPlayerEntity() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)this.offlinePlayer.getUniqueId());
    }

    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public ImprovedOfflinePlayer getNBTEditor() {
        return new ImprovedOfflinePlayer(this.getOfflinePlayer());
    }

    public dEntity getDenizenEntity() {
        return new dEntity((Entity)this.getPlayerEntity());
    }

    public dNPC getSelectedNPC() {
        NPC npc;
        if (Depends.citizens != null && (npc = CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)this.getPlayerEntity())) != null) {
            return dNPC.mirrorCitizensNPC(npc);
        }
        return null;
    }

    public String getName() {
        if (this.offlinePlayer == null) {
            return null;
        }
        return this.offlinePlayer.getName();
    }

    public String getSaveName() {
        if (this.offlinePlayer == null) {
            return "00.UNKNOWN";
        }
        String baseID = this.offlinePlayer.getUniqueId().toString().toUpperCase().replace("-", "");
        return baseID.substring(0, 2) + "." + baseID;
    }

    public dLocation getLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getLocation());
        }
        return new dLocation(this.getNBTEditor().getLocation());
    }

    public int getRemainingAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getRemainingAir();
        }
        return this.getNBTEditor().getRemainingAir();
    }

    public int getMaximumAir() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getMaximumAir();
        }
        return 300;
    }

    public dLocation getEyeLocation() {
        if (this.isOnline()) {
            return new dLocation(this.getPlayerEntity().getEyeLocation());
        }
        return null;
    }

    public PlayerInventory getBukkitInventory() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getInventory();
        }
        return this.getNBTEditor().getInventory();
    }

    public dInventory getInventory() {
        if (this.isOnline()) {
            return new dInventory((Inventory)this.getPlayerEntity().getInventory());
        }
        return new dInventory(this.getNBTEditor());
    }

    public CraftingInventory getBukkitWorkbench() {
        if (this.isOnline() && (this.getPlayerEntity().getOpenInventory().getType() == InventoryType.WORKBENCH || this.getPlayerEntity().getOpenInventory().getType() == InventoryType.CRAFTING)) {
            return (CraftingInventory)this.getPlayerEntity().getOpenInventory().getTopInventory();
        }
        return null;
    }

    public dInventory getWorkbench() {
        CraftingInventory workbench;
        if (this.isOnline() && (workbench = this.getBukkitWorkbench()) != null) {
            return new dInventory((Inventory)workbench, (InventoryHolder)this.getPlayerEntity());
        }
        return null;
    }

    public Inventory getBukkitEnderChest() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getEnderChest();
        }
        return this.getNBTEditor().getEnderChest();
    }

    public dInventory getEnderChest() {
        if (this.isOnline()) {
            return new dInventory(this.getPlayerEntity().getEnderChest(), (InventoryHolder)this.getPlayerEntity());
        }
        return new dInventory(this.getNBTEditor(), true);
    }

    public World getWorld() {
        if (this.isOnline()) {
            return this.getPlayerEntity().getWorld();
        }
        return null;
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().decrementStatistic(statistic, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().decrementStatistic(statistic, entity, amount);
        }
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().decrementStatistic(statistic, material, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().incrementStatistic(statistic, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().incrementStatistic(statistic, entity, amount);
        }
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().incrementStatistic(statistic, material, amount);
        }
    }

    public void setStatistic(Statistic statistic, int amount) {
        if (this.isOnline()) {
            this.getPlayerEntity().setStatistic(statistic, amount);
        }
    }

    public void setStatistic(Statistic statistic, EntityType entity, int amount) {
        if (this.isOnline() && statistic.getType() == Statistic.Type.ENTITY) {
            this.getPlayerEntity().setStatistic(statistic, entity, amount);
        }
    }

    public void setStatistic(Statistic statistic, Material material, int amount) {
        if (this.isOnline() && (statistic.getType() == Statistic.Type.BLOCK || statistic.getType() == Statistic.Type.ITEM)) {
            this.getPlayerEntity().setStatistic(statistic, material, amount);
        }
    }

    public boolean isOnline() {
        return this.getPlayerEntity() != null;
    }

    public void setBedSpawnLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().setBedSpawnLocation(location);
        } else {
            this.getNBTEditor().setBedSpawnLocation(location, this.getNBTEditor().isSpawnForced());
        }
    }

    public void setLocation(Location location) {
        if (this.isOnline()) {
            this.getPlayerEntity().teleport(location);
        } else {
            this.getNBTEditor().setLocation(location);
        }
    }

    public void setMaximumAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setMaximumAir(air);
        } else {
            dB.echoError("Cannot set the maximum air of an offline player!");
        }
    }

    public void setRemainingAir(int air) {
        if (this.isOnline()) {
            this.getPlayerEntity().setRemainingAir(air);
        } else {
            this.getNBTEditor().setRemainingAir(air);
        }
    }

    public void setLevel(int level) {
        if (this.isOnline()) {
            this.getPlayerEntity().setLevel(level);
        } else {
            this.getNBTEditor().setLevel(level);
        }
    }

    public void setFlySpeed(float speed) {
        if (this.isOnline()) {
            this.getPlayerEntity().setFlySpeed(speed);
        } else {
            this.getNBTEditor().setFlySpeed(speed);
        }
    }

    public void setGameMode(GameMode mode) {
        if (this.isOnline()) {
            this.getPlayerEntity().setGameMode(mode);
        } else {
            this.getNBTEditor().setGameMode(mode);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public dPlayer setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String debug() {
        return this.prefix + "='<A>" + this.identifySimple() + "<G>'  ";
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "Player";
    }

    @Override
    public String identify() {
        return "p@" + this.offlinePlayer.getUniqueId().toString();
    }

    @Override
    public String identifySimple() {
        return "p@" + this.offlinePlayer.getName();
    }

    public String toString() {
        return this.identify();
    }

    @Override
    public String getAttribute(Attribute attribute) {
        dScript script;
        if (attribute == null) {
            return "null";
        }
        if (this.offlinePlayer == null) {
            return null;
        }
        if (attribute.startsWith("is_player")) {
            return Element.TRUE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("debug.log")) {
            dB.log(this.debug());
            return new Element(Boolean.TRUE.toString()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug.no_color")) {
            return new Element(ChatColor.stripColor((String)this.debug())).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("debug")) {
            return new Element(this.debug()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix")) {
            return new Element(this.prefix).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history_list")) {
            return new dList(PlayerTags.playerChatHistory.get(this.getName())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("chat_history")) {
            int x = 1;
            if (attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1))) {
                x = attribute.getIntContext(1);
            }
            if (!PlayerTags.playerChatHistory.containsKey(this.getName())) {
                return null;
            }
            return new Element(PlayerTags.playerChatHistory.get(this.getName()).get(x - 1)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            if (attribute.getAttribute(2).equalsIgnoreCase("is_expired") || attribute.startsWith("isexpired")) {
                return new Element(!FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).equalsIgnoreCase("size") && !FlagManager.playerHasFlag(this, flag_name)) {
                return new Element(0).getAttribute(attribute.fulfill(2));
            }
            if (FlagManager.playerHasFlag(this, flag_name)) {
                FlagManager.Flag flag = DenizenAPI.getCurrentInstance().flagManager().getPlayerFlag(this, flag_name);
                return new dList(flag.toString(), true, flag.values()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("has_flag")) {
            if (!attribute.hasContext(1)) {
                return null;
            }
            String flag_name = attribute.getContext(1);
            return new Element(FlagManager.playerHasFlag(this, flag_name)).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list_flags")) {
            dList allFlags = new dList(DenizenAPI.getCurrentInstance().flagManager().listPlayerFlags(this));
            dList searchFlags = null;
            if (!allFlags.isEmpty() && attribute.hasContext(1)) {
                searchFlags = new dList();
                String search = attribute.getContext(1);
                if (search.startsWith("regex:")) {
                    try {
                        Pattern pattern = Pattern.compile(search.substring(6), 2);
                        for (String flag : allFlags) {
                            if (!pattern.matcher(flag).matches()) continue;
                            searchFlags.add(flag);
                        }
                    }
                    catch (Exception e) {
                        dB.echoError(e);
                    }
                } else {
                    search = CoreUtilities.toLowerCase(search);
                    for (String flag : allFlags) {
                        if (!flag.toLowerCase().contains(search)) continue;
                        searchFlags.add(flag);
                    }
                }
            }
            return searchFlags == null ? allFlags.getAttribute(attribute.fulfill(1)) : searchFlags.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("current_step")) {
            String outcome = "null";
            if (attribute.hasContext(1)) {
                try {
                    outcome = DenizenAPI.getCurrentInstance().getSaves().getString("Players." + this.getName() + ".Scripts." + dScript.valueOf(attribute.getContext(1)).getName() + ".Current Step");
                }
                catch (Exception e) {
                    outcome = "null";
                }
            }
            return new Element(outcome).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("money")) {
            if (Depends.economy != null) {
                if (attribute.startsWith("money.currency_singular")) {
                    return new Element(Depends.economy.currencyNameSingular()).getAttribute(attribute.fulfill(2));
                }
                if (attribute.startsWith("money.currency")) {
                    return new Element(Depends.economy.currencyNamePlural()).getAttribute(attribute.fulfill(2));
                }
                return new Element(Depends.economy.getBalance(this.getName())).getAttribute(attribute.fulfill(1));
            }
            if (!attribute.hasAlternative()) {
                dB.echoError("No economy loaded! Have you installed Vault and a compatible economy plugin?");
            }
            return null;
        }
        if (attribute.startsWith("target")) {
            BlockIterator bi;
            int range = 50;
            int attribs = 1;
            if (attribute.getAttribute(2).startsWith("within") && attribute.hasContext(2) && aH.matchesInteger(attribute.getContext(2))) {
                attribs = 2;
                range = attribute.getIntContext(2);
            }
            List entities = this.getPlayerEntity().getNearbyEntities((double)range, (double)range, (double)range);
            ArrayList<LivingEntity> possibleTargets = new ArrayList<LivingEntity>();
            for (Entity entity : entities) {
                if (!(entity instanceof LivingEntity)) continue;
                if (attribute.hasContext(1)) {
                    String context = attribute.getContext(1);
                    if (context.toLowerCase().startsWith("li@")) {
                        context = context.substring(3);
                    }
                    for (String ent : context.split("\\|")) {
                        boolean valid = false;
                        if (ent.equalsIgnoreCase("npc") && dEntity.isCitizensNPC(entity)) {
                            valid = true;
                        } else if (dEntity.matches(ent)) {
                            if (dEntity.valueOf(ent).isGeneric()) {
                                if (dEntity.isCitizensNPC(entity)) {
                                    valid = true;
                                }
                            } else {
                                valid = true;
                            }
                        }
                        if (!valid) continue;
                        possibleTargets.add((LivingEntity)entity);
                    }
                    continue;
                }
                possibleTargets.add((LivingEntity)entity);
                entity.getType();
            }
            try {
                bi = new BlockIterator((LivingEntity)this.getPlayerEntity(), range);
            }
            catch (IllegalStateException e) {
                return null;
            }
            while (bi.hasNext()) {
                Block b = bi.next();
                int bx = b.getX();
                int by = b.getY();
                int bz = b.getZ();
                if (b.getType() != Material.AIR) break;
                for (LivingEntity possibleTarget : possibleTargets) {
                    Location l = possibleTarget.getLocation();
                    double ex = l.getX();
                    double ey = l.getY();
                    double ez = l.getZ();
                    if (!((double)bx - 0.5 <= ex) || !(ex <= (double)bx + 1.5) || !((double)bz - 0.5 <= ez) || !(ez <= (double)bz + 1.5) || !((double)(by - 1) <= ey) || !(ey <= (double)by + 2.5)) continue;
                    return new dEntity((Entity)possibleTarget).getAttribute(attribute.fulfill(attribs));
                }
            }
            return null;
        }
        if (attribute.startsWith("list_effects")) {
            dList effects = new dList();
            for (PotionEffect effect : this.getPlayerEntity().getActivePotionEffects()) {
                effects.add(effect.getType().getName() + "," + effect.getAmplifier() + "," + effect.getDuration() + "t");
            }
            return effects.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("list")) {
            ArrayList<String> players = new ArrayList<String>();
            if (attribute.startsWith("list.online")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    players.add(player.getName());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            if (attribute.startsWith("list.offline")) {
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    if (player.isOnline()) continue;
                    players.add("p@" + player.getUniqueId().toString());
                }
                return new dList((List<String>)players).getAttribute(attribute.fulfill(2));
            }
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                players.add("p@" + player.getUniqueId().toString());
            }
            return new dList((List<String>)players).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name") && !this.isOnline()) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("uuid") && !this.isOnline()) {
            return new Element(this.offlinePlayer.getUniqueId().toString()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Player").getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("save_name")) {
            return new Element(this.getSaveName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("bed_spawn")) {
            if (this.getOfflinePlayer().getBedSpawnLocation() == null) {
                return null;
            }
            return new dLocation(this.getOfflinePlayer().getBedSpawnLocation()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("location") && !this.isOnline()) {
            return this.getLocation().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("first_played")) {
            if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                return new Element(this.getOfflinePlayer().getFirstPlayed()).getAttribute(attribute.fulfill(1));
            }
            return new Duration(this.getOfflinePlayer().getFirstPlayed() / 50L).getAttribute(attribute);
        }
        if (attribute.startsWith("has_played_before")) {
            return new Element(true).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health.is_scaled")) {
            return new Element(this.getPlayerEntity().isHealthScaled()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("health.scale")) {
            return new Element(this.getPlayerEntity().getHealthScale()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Duration((long)this.getMaximumAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen")) {
            return new Duration((long)this.getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_banned")) {
            return new Element(this.getOfflinePlayer().isBanned()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_online")) {
            return new Element(this.isOnline()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_op")) {
            return new Element(this.getOfflinePlayer().isOp()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_whitelisted")) {
            return new Element(this.getOfflinePlayer().isWhitelisted()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("last_played")) {
            if ((attribute = attribute.fulfill(1)).startsWith("milliseconds") || attribute.startsWith("in_milliseconds")) {
                return new Element(this.getOfflinePlayer().getLastPlayed()).getAttribute(attribute.fulfill(1));
            }
            return new Duration(this.getOfflinePlayer().getLastPlayed() / 50L).getAttribute(attribute);
        }
        if (attribute.startsWith("groups")) {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            dList list = new dList();
            for (String group : Depends.permissions.getGroups()) {
                if (!Depends.permissions.playerInGroup(null, this.offlinePlayer, group)) continue;
                list.add(group);
            }
            return list.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("in_group")) {
            if (Depends.permissions == null) {
                if (!attribute.hasAlternative()) {
                    dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                }
                return null;
            }
            String group = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                return new Element(Depends.permissions.playerInGroup((World)null, this.getName(), group)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                return new Element(Depends.permissions.playerInGroup(attribute.getContext(2), this.getName(), group)).getAttribute(attribute.fulfill(2));
            }
            if (this.isOnline()) {
                return new Element(Depends.permissions.playerInGroup(this.getPlayerEntity(), group)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("permission") || attribute.startsWith("has_permission")) {
            String permission = attribute.getContext(1);
            if (attribute.getAttribute(2).startsWith("global")) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                return new Element(Depends.permissions.has((World)null, this.getName(), permission)).getAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("world")) {
                if (Depends.permissions == null) {
                    if (!attribute.hasAlternative()) {
                        dB.echoError("No permission system loaded! Have you installed Vault and a compatible permissions plugin?");
                    }
                    return null;
                }
                return new Element(Depends.permissions.has(attribute.getContext(2), this.getName(), permission)).getAttribute(attribute.fulfill(2));
            }
            if (this.isOnline()) {
                return new Element(this.getPlayerEntity().hasPermission(permission)).getAttribute(attribute.fulfill(1));
            }
        }
        if (attribute.startsWith("inventory")) {
            return this.getInventory().getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("enderchest")) {
            return this.getEnderChest().getAttribute(attribute.fulfill(1));
        }
        if (!this.isOnline()) {
            return new Element(this.identify()).getAttribute(attribute);
        }
        if (attribute.startsWith("open_inventory")) {
            return new dInventory(this.getPlayerEntity().getOpenInventory().getTopInventory()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_on_cursor")) {
            return new dItem(this.getPlayerEntity().getItemOnCursor()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("item_in_hand.slot")) {
            return new Element(this.getPlayerEntity().getInventory().getHeldItemSlot() + 1).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("selected_npc")) {
            if (this.getPlayerEntity().hasMetadata("selected")) {
                return this.getSelectedNPC().getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("entity") && !attribute.startsWith("entity_")) {
            return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ip") || attribute.startsWith("host_name")) {
            attribute = attribute.fulfill(1);
            String host = this.getPlayerEntity().getAddress().getHostName();
            if (attribute.startsWith("address")) {
                return new Element(this.getPlayerEntity().getAddress().toString()).getAttribute(attribute.fulfill(1));
            }
            return new Element(host).getAttribute(attribute);
        }
        if (attribute.startsWith("name.display")) {
            return new Element(this.getPlayerEntity().getDisplayName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name.list")) {
            return new Element(this.getPlayerEntity().getPlayerListName()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("name")) {
            return new Element(this.getName()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_finished")) {
            script = dScript.valueOf(attribute.getContext(1));
            if (script == null) {
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return new Element(FinishCommand.getScriptCompletes(this.getName(), script.getName()) > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_failed")) {
            script = dScript.valueOf(attribute.getContext(1));
            if (script == null) {
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return new Element(FailCommand.getScriptFails(this.getName(), script.getName()) > 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("compass_target")) {
            return new dLocation(this.getPlayerEntity().getCompassTarget()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("allowed_flight")) {
            return new Element(this.getPlayerEntity().getAllowFlight()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("fly_speed")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getFlySpeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level.formatted")) {
            double maxHunger = this.getPlayerEntity().getMaxHealth();
            if (attribute.hasContext(2)) {
                maxHunger = attribute.getIntContext(2);
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.1) {
                return new Element("starving").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.4) {
                return new Element("famished").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 0.75) {
                return new Element("parched").getAttribute(attribute.fulfill(2));
            }
            if ((double)this.getPlayerEntity().getFoodLevel() / maxHunger < 1.0) {
                return new Element("hungry").getAttribute(attribute.fulfill(2));
            }
            return new Element("healthy").getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("saturation")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getSaturation())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("food_level")) {
            return new Element(this.getPlayerEntity().getFoodLevel()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("oxygen.max")) {
            return new Element(this.getPlayerEntity().getMaximumAir()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("oxygen")) {
            return new Element(this.getPlayerEntity().getRemainingAir()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("gamemode")) {
            if ((attribute = attribute.fulfill(1)).startsWith("id")) {
                return new Element(this.getPlayerEntity().getGameMode().getValue()).getAttribute(attribute.fulfill(1));
            }
            return new Element(this.getPlayerEntity().getGameMode().name()).getAttribute(attribute);
        }
        if (attribute.startsWith("is_blocking")) {
            return new Element(this.getPlayerEntity().isBlocking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("ping")) {
            return new Element(((CraftPlayer)this.getPlayerEntity()).getHandle().ping).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flying")) {
            return new Element(this.getPlayerEntity().isFlying()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sleeping")) {
            return new Element(this.getPlayerEntity().isSleeping()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sneaking")) {
            return new Element(this.getPlayerEntity().isSneaking()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_sprinting")) {
            return new Element(this.getPlayerEntity().isSprinting()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("statistic")) {
            Statistic statistic = Statistic.valueOf((String)attribute.getContext(1).toUpperCase());
            if (attribute.getAttribute(2).startsWith("qualifier")) {
                if (statistic == null) {
                    return null;
                }
                dObject obj = ObjectFetcher.pickObjectFor(attribute.getContext(2));
                try {
                    if (obj instanceof dMaterial) {
                        return new Element(this.getPlayerEntity().getStatistic(statistic, ((dMaterial)obj).getMaterial())).getAttribute(attribute.fulfill(2));
                    }
                    if (obj instanceof dEntity) {
                        return new Element(this.getPlayerEntity().getStatistic(statistic, ((dEntity)obj).getBukkitEntityType())).getAttribute(attribute.fulfill(2));
                    }
                    return null;
                }
                catch (Exception e) {
                    dB.echoError("Invalid statistic: " + statistic + " for this player!");
                    return null;
                }
            }
            if (statistic == null) {
                return null;
            }
            try {
                return new Element(this.getPlayerEntity().getStatistic(statistic)).getAttribute(attribute.fulfill(1));
            }
            catch (Exception e) {
                dB.echoError("Invalid statistic: " + statistic + " for this player!");
                return null;
            }
        }
        if (attribute.startsWith("time_asleep")) {
            return new Duration(this.getPlayerEntity().getSleepTicks() / 20).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("time")) {
            return new Element(this.getPlayerEntity().getPlayerTime()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("walk_speed")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getWalkSpeed())).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("weather")) {
            if (this.getPlayerEntity().getPlayerWeather() != null) {
                return new Element(this.getPlayerEntity().getPlayerWeather().name()).getAttribute(attribute.fulfill(1));
            }
            return null;
        }
        if (attribute.startsWith("xp.level")) {
            return new Element(this.getPlayerEntity().getLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.to_next_level")) {
            return new Element(this.getPlayerEntity().getExpToLevel()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp.total")) {
            return new Element(this.getPlayerEntity().getTotalExperience()).getAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("xp")) {
            return new Element(Float.valueOf(this.getPlayerEntity().getExp() * 100.0f)).getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new dEntity((Entity)this.getPlayerEntity()).getAttribute(attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a player!");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        String name;
        String[] split;
        Element value = mechanism.getValue();
        if (mechanism.matches("level") && mechanism.requireInteger()) {
            this.setLevel(value.asInt());
        }
        if (mechanism.matches("item_slot") && mechanism.requireInteger()) {
            this.getPlayerEntity().getInventory().setHeldItemSlot(mechanism.getValue().asInt() - 1);
        }
        if (mechanism.matches("award_achievement") && mechanism.requireEnum(false, (Enum<?>[])Achievement.values())) {
            this.getPlayerEntity().awardAchievement(Achievement.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("health_scale") && mechanism.requireDouble()) {
            this.getPlayerEntity().setHealthScale(value.asDouble());
        }
        if (mechanism.matches("scale_health") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setHealthScaled(value.asBoolean());
        }
        if (mechanism.matches("resource_pack") || mechanism.matches("texture_pack")) {
            this.getPlayerEntity().setResourcePack(value.asString());
        }
        if (mechanism.matches("saturation") && mechanism.requireFloat()) {
            this.getPlayerEntity().setSaturation(value.asFloat());
        }
        if (mechanism.matches("send_map") && mechanism.requireInteger()) {
            MapView map = Bukkit.getServer().getMap((short)value.asInt());
            if (map != null) {
                this.getPlayerEntity().sendMap(map);
            } else {
                dB.echoError("No map found for ID " + value.asInt() + "!");
            }
        }
        if (mechanism.matches("food_level") && mechanism.requireInteger()) {
            this.getPlayerEntity().setFoodLevel(value.asInt());
        }
        if (mechanism.matches("bed_spawn_location") && mechanism.requireObject(dLocation.class)) {
            this.setBedSpawnLocation(value.asType(dLocation.class));
        }
        if (mechanism.matches("can_fly") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setAllowFlight(value.asBoolean());
        }
        if (mechanism.matches("fly_speed") && mechanism.requireFloat()) {
            this.setFlySpeed(value.asFloat());
        }
        if (mechanism.matches("flying") && mechanism.requireBoolean()) {
            this.getPlayerEntity().setFlying(value.asBoolean());
        }
        if (mechanism.matches("gamemode") && mechanism.requireEnum(false, (Enum<?>[])GameMode.values())) {
            this.setGameMode(GameMode.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("kick")) {
            this.getPlayerEntity().kickPlayer(mechanism.getValue().asString());
        }
        if (mechanism.matches("weather") && mechanism.requireEnum(false, (Enum<?>[])WeatherType.values())) {
            this.getPlayerEntity().setPlayerWeather(WeatherType.valueOf((String)value.asString().toUpperCase()));
        }
        if (mechanism.matches("reset_weather")) {
            this.getPlayerEntity().resetPlayerWeather();
        }
        if (mechanism.matches("player_list_name")) {
            this.getPlayerEntity().setPlayerListName(value.asString());
        }
        if (mechanism.matches("display_name")) {
            this.getPlayerEntity().setDisplayName(value.asString());
            return;
        }
        if (mechanism.matches("show_workbench") && mechanism.requireObject(dLocation.class)) {
            this.getPlayerEntity().openWorkbench((Location)mechanism.getValue().asType(dLocation.class), true);
            return;
        }
        if (mechanism.matches("location") && mechanism.requireObject(dLocation.class)) {
            this.setLocation(value.asType(dLocation.class));
        }
        if (mechanism.matches("time") && mechanism.requireInteger()) {
            this.getPlayerEntity().setPlayerTime((long)value.asInt(), true);
        }
        if (mechanism.matches("freeze_time")) {
            if (mechanism.requireInteger("Invalid integer specified. Assuming current world time.")) {
                this.getPlayerEntity().setPlayerTime((long)value.asInt(), false);
            } else {
                this.getPlayerEntity().setPlayerTime(this.getPlayerEntity().getWorld().getTime(), false);
            }
        }
        if (mechanism.matches("reset_time")) {
            this.getPlayerEntity().resetPlayerTime();
        }
        if (mechanism.matches("walk_speed") && mechanism.requireFloat()) {
            this.getPlayerEntity().setWalkSpeed(value.asFloat());
        }
        if (mechanism.matches("show_entity") && mechanism.requireObject(dEntity.class)) {
            this.getPlayerEntity().showPlayer((Player)value.asType(dEntity.class).getLivingEntity());
        }
        if (mechanism.matches("hide_entity") && mechanism.requireObject(dEntity.class)) {
            this.getPlayerEntity().hidePlayer((Player)value.asType(dEntity.class).getLivingEntity());
        }
        if (mechanism.matches("show_boss_bar")) {
            if (value.asString().length() > 0) {
                split = value.asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length == 2 && new Element(split[0]).isInt()) {
                    BossHealthBar.displayTextBar(split[1], this.getPlayerEntity(), new Element(split[0]).asInt());
                } else {
                    BossHealthBar.displayTextBar(value.asString(), this.getPlayerEntity(), 200);
                }
            } else {
                BossHealthBar.removeTextBar(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_experience")) {
            if (value.asString().length() > 0) {
                split = value.asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length > 0 && new Element(split[0]).isFloat()) {
                    if (split.length > 1 && new Element(split[1]).isInt()) {
                        PlayerBars.showExperience(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt());
                    } else {
                        PlayerBars.showExperience(this.getPlayerEntity(), new Element(split[0]).asFloat(), this.getPlayerEntity().getLevel());
                    }
                } else {
                    dB.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                PlayerBars.resetExperience(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_health")) {
            if (value.asString().length() > 0) {
                split = value.asString().split("[\\|" + dList.internal_escape + "]", 3);
                if (split.length > 0 && new Element(split[0]).isFloat()) {
                    if (split.length > 1 && new Element(split[1]).isInt()) {
                        if (split.length > 2 && new Element(split[2]).isFloat()) {
                            PlayerBars.showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt(), new Element(split[2]).asFloat());
                        } else {
                            PlayerBars.showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), new Element(split[1]).asInt(), this.getPlayerEntity().getSaturation());
                        }
                    } else {
                        PlayerBars.showHealth(this.getPlayerEntity(), new Element(split[0]).asFloat(), this.getPlayerEntity().getFoodLevel(), this.getPlayerEntity().getSaturation());
                    }
                } else {
                    dB.echoError("'" + split[0] + "' is not a valid decimal number!");
                }
            } else {
                PlayerBars.resetHealth(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("fake_equipment") && value.asString().length() > 0) {
            split = value.asString().split("[\\|" + dList.internal_escape + "]", 3);
            if (split.length > 0 && new Element(split[0]).matchesType(dEntity.class)) {
                if (split.length > 1 && new Element(split[1]).matchesEnum(EntityEquipment.EquipmentSlots.values())) {
                    if (split.length > 2 && new Element(split[2]).matchesType(dItem.class)) {
                        EntityEquipment.showEquipment(this.getPlayerEntity(), new Element(split[0]).asType(dEntity.class).getLivingEntity(), EntityEquipment.EquipmentSlots.valueOf(new Element(split[1]).asString().toUpperCase()), new Element(split[2]).asType(dItem.class).getItemStack());
                    } else if (split.length > 2) {
                        dB.echoError("'" + split[2] + "' is not a valid dItem!");
                    }
                } else if (split.length > 1) {
                    dB.echoError("'" + split[1] + "' is not a valid slot; must be HAND, BOOTS, LEGS, CHEST, or HEAD!");
                } else {
                    EntityEquipment.resetEquipment(this.getPlayerEntity(), new Element(split[0]).asType(dEntity.class).getLivingEntity());
                }
            } else {
                dB.echoError("'" + split[0] + "' is not a valid dEntity!");
            }
        }
        if (mechanism.matches("item_message")) {
            ItemChangeMessage.sendMessage(this.getPlayerEntity(), value.asString());
        }
        if (mechanism.matches("show_endcredits")) {
            ((CraftPlayer)this.getPlayerEntity()).getHandle().viewingCredits = true;
            ((CraftPlayer)this.getPlayerEntity()).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutGameStateChange(4, 0.0f));
        }
        if (mechanism.matches("spectate") && mechanism.requireObject(dEntity.class)) {
            PlayerSpectateEntity.setSpectating(this.getPlayerEntity(), value.asType(dEntity.class).getBukkitEntity());
        }
        if (mechanism.matches("open_book")) {
            OpenBook.openBook(this.getPlayerEntity());
        }
        if (mechanism.matches("edit_sign") && mechanism.requireObject(dLocation.class)) {
            SignEditor.editSign(this.getPlayerEntity(), value.asType(dLocation.class));
        }
        if (mechanism.matches("tab_list_info")) {
            if (value.asString().length() > 0) {
                split = value.asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (split.length > 0) {
                    String header = split[0];
                    String footer = "";
                    if (split.length > 1) {
                        footer = split[1];
                    }
                    DisplayHeaderFooter.showHeaderFooter(this.getPlayerEntity(), header, footer);
                } else {
                    dB.echoError("Must specify a header and footer to show!");
                }
            } else {
                DisplayHeaderFooter.clearHeaderFooter(this.getPlayerEntity());
            }
        }
        if (mechanism.matches("sign_update")) {
            if (value.asString().length() > 0) {
                split = value.asString().split("[\\|" + dList.internal_escape + "]", 2);
                if (dLocation.matches(split[0]) && split.length > 1) {
                    dList lines = dList.valueOf(split[1]);
                    SignUpdate.updateSign(this.getPlayerEntity(), dLocation.valueOf(split[0]), lines.toArray(4));
                } else {
                    dB.echoError("Must specify a valid location and at least one sign line!");
                }
            } else {
                dB.echoError("Must specify a valid location and at least one sign line!");
            }
        }
        if (mechanism.matches("action_bar")) {
            ActionBar.sendActionBarMessage(this.getPlayerEntity(), value.asString());
        }
        if (mechanism.matches("name")) {
            name = value.asString();
            if (name.length() > 16) {
                dB.echoError("Must specify a name with no more than 16 characters.");
            } else {
                PlayerProfileEditor.setPlayerName(this.getPlayerEntity(), value.asString());
            }
        }
        if (mechanism.matches("skin")) {
            name = value.asString();
            if (name.length() > 16) {
                dB.echoError("Must specify a name with no more than 16 characters.");
            } else {
                PlayerProfileEditor.setPlayerSkin(this.getPlayerEntity(), value.asString());
            }
        }
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
        if (!mechanism.fulfilled()) {
            dEntity entity = new dEntity((Entity)this.getPlayerEntity());
            entity.adjust(mechanism);
        }
    }
}

