/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.utilities.blocks.BlockLight;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class LightCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class));
                continue;
            }
            if (!scriptEntry.hasObject("light") && arg.matchesPrimitive(aH.PrimitiveType.Integer)) {
                scriptEntry.addObject("light", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("reset") && arg.matches("reset")) {
                scriptEntry.addObject("reset", new Element(true));
                continue;
            }
            if (scriptEntry.hasObject("duration") || !arg.matchesPrefix("d", "duration") || !arg.matchesArgumentType(Duration.class)) continue;
            scriptEntry.addObject("duration", arg.asType(Duration.class));
        }
        if (!scriptEntry.hasObject("location") || !scriptEntry.hasObject("light") && !scriptEntry.hasObject("reset")) {
            throw new InvalidArgumentsException("Must specify a valid location and light level.");
        }
        scriptEntry.defaultObject("reset", new Element(false));
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dLocation location = (dLocation)scriptEntry.getdObject("location");
        Element light = scriptEntry.getElement("light");
        Element reset = scriptEntry.getElement("reset");
        Duration duration = (Duration)scriptEntry.getdObject("duration");
        dB.report(scriptEntry, this.getName(), location.debug() + reset.debug() + (light != null ? light.debug() : "") + (duration != null ? duration.debug() : ""));
        if (!reset.asBoolean()) {
            int brightness = light.asInt();
            if (brightness < 0 || brightness > 15) {
                throw new CommandExecutionException("Light brightness must be between 0 and 15, inclusive!");
            }
            BlockLight.createLight(location, brightness, duration);
        } else {
            BlockLight.removeLight(location);
        }
    }
}

