/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.bukkit.SavesReloadEvent;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class ViewerCommand
extends AbstractCommand
implements Listener {
    static Map<String, Viewer> viewers = new ConcurrentHashMap<String, Viewer>();

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.values())) {
                scriptEntry.addObject("action", (Object)Action.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("display") && arg.matchesEnum(Display.values())) {
                scriptEntry.addObject("display, d", (Object)Display.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (arg.matchesPrefix("i, id")) {
                scriptEntry.addObject("id", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(dLocation.class)) {
                scriptEntry.addObject("location", arg.asType(dLocation.class).setPrefix("location"));
                continue;
            }
            if (!scriptEntry.hasObject("direction") && arg.matchesPrefix("direction, dir")) {
                scriptEntry.addObject("direction", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", (Object)Action.CREATE);
        }
        if (!scriptEntry.hasObject("display") && scriptEntry.getObject("action").equals((Object)Action.CREATE)) {
            scriptEntry.addObject("display", (Object)Display.LOCATION);
        }
        if (!scriptEntry.hasObject("id")) {
            throw new InvalidArgumentsException("Must specify a Viewer ID!");
        }
        if (!scriptEntry.hasObject("location") && scriptEntry.getObject("action").equals((Object)Action.CREATE)) {
            throw new InvalidArgumentsException("Must specify a Sign location!");
        }
        if (!scriptEntry.hasObject("type") && scriptEntry.getObject("action").equals((Object)Action.CREATE)) {
            scriptEntry.addObject("type", (Object)Type.SIGN_POST);
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dB.echoError(scriptEntry.getResidingQueue(), "This command is deprecated! If you use this, please contact Morphan1 or mcmonkey on irc.esper.net#denizen-dev");
        String direction = scriptEntry.hasObject("direction") ? ((Element)scriptEntry.getObject("direction")).asString() : null;
        Action action = (Action)((Object)scriptEntry.getObject("action"));
        Type type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : null;
        Display display = scriptEntry.hasObject("display") ? (Display)((Object)scriptEntry.getObject("display")) : null;
        final String id = scriptEntry.getObject("id").toString();
        if (viewers.containsKey(id)) {
            ((BukkitScriptEntryData)scriptEntry.entryData).setPlayer(dPlayer.valueOf(ViewerCommand.viewers.get(id).getContent().split("; ")[1]));
        }
        dLocation location = scriptEntry.hasObject("location") ? (dLocation)scriptEntry.getObject("location") : null;
        String content = scriptEntry.hasObject("display") ? display.toString() + "; " + ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getOfflinePlayer().getUniqueId() : null;
        switch (action) {
            case CREATE: {
                if (viewers.containsKey(id)) {
                    dB.echoDebug((Debuggable)scriptEntry, "Viewer ID " + id + " already exists!");
                    return;
                }
                Viewer viewer = new Viewer(id, content, location);
                viewers.put(id, viewer);
                Block sign = location.getBlock();
                sign.setType(Material.valueOf((String)type.name()));
                if (direction != null) {
                    Utilities.setSignRotation(sign.getState(), direction);
                } else {
                    Utilities.setSignRotation(sign.getState());
                }
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    public void run() {
                        Player player = Bukkit.getPlayer((UUID)UUID.fromString(viewers.get(id).getContent().split("; ")[1]));
                        if (player == null) {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{"", viewers.get(id).getContent().split("; ")[1], "is offline.", ""});
                        } else {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{String.valueOf((int)player.getLocation().getX()), String.valueOf((int)player.getLocation().getY()), String.valueOf((int)player.getLocation().getZ()), player.getWorld().getName()});
                        }
                    }
                }, 0L, 20L);
                viewer.setTask(task);
                viewer.save();
                break;
            }
            case MODIFY: {
                if (!viewers.containsKey(id)) {
                    dB.echoDebug((Debuggable)scriptEntry, "Viewer ID " + id + " doesn't exist!");
                    return;
                }
                if (content != null) {
                    viewers.get(id).setContent(content);
                }
                if (location == null) break;
                if (type == null) {
                    type = Type.valueOf(ViewerCommand.viewers.get(id).getLocation().getBlock().getType().name());
                }
                Bukkit.getScheduler().cancelTask(ViewerCommand.viewers.get(id).getTask());
                int newTask = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    public void run() {
                        Player player = Bukkit.getPlayer((UUID)UUID.fromString(viewers.get(id).getContent().split("; ")[1]));
                        if (player == null) {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{"", viewers.get(id).getContent().split("; ")[1], "is offline.", ""});
                        } else {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{String.valueOf((int)player.getLocation().getX()), String.valueOf((int)player.getLocation().getY()), String.valueOf((int)player.getLocation().getZ()), player.getWorld().getName()});
                        }
                    }
                }, 0L, 20L);
                ViewerCommand.viewers.get(id).getLocation().getBlock().setType(Material.AIR);
                viewers.get(id).setLocation(location);
                viewers.get(id).setTask(newTask);
                location.getBlock().setType(Material.valueOf((String)type.name()));
                break;
            }
            case REMOVE: {
                if (!viewers.containsKey(id)) {
                    dB.echoDebug((Debuggable)scriptEntry, "Viewer ID " + id + " doesn't exist!");
                    return;
                }
                Block block = ViewerCommand.viewers.get(id).getLocation().getBlock();
                block.setType(Material.AIR);
                Bukkit.getScheduler().cancelTask(ViewerCommand.viewers.get(id).getTask());
                viewers.get(id).remove();
                viewers.remove(id);
            }
        }
    }

    @EventHandler
    public static void reloadViewers(SavesReloadEvent event) {
        for (Viewer viewer : viewers.values()) {
            Bukkit.getScheduler().cancelTask(viewer.getTask());
        }
        viewers.clear();
        FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
        if (saves.contains("Viewers")) {
            for (final String id : saves.getConfigurationSection("Viewers").getKeys(false)) {
                Viewer viewer = new Viewer(id, saves.getString("Viewers." + id.toLowerCase() + ".content"), dLocation.valueOf(saves.getString("Viewers." + id.toLowerCase() + ".location")));
                viewers.put(id, viewer);
                if (!viewer.getContent().startsWith("LOCATION")) continue;
                int task = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

                    public void run() {
                        Player player = Bukkit.getPlayer((UUID)UUID.fromString(viewers.get(id).getContent().split("; ")[1]));
                        if (player == null) {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{"", viewers.get(id).getContent().split("; ")[1], "is offline.", ""});
                        } else {
                            Utilities.setSignLines((Sign)viewers.get(id).getLocation().getBlock().getState(), new String[]{String.valueOf((int)player.getLocation().getX()), String.valueOf((int)player.getLocation().getY()), String.valueOf((int)player.getLocation().getZ()), player.getWorld().getName()});
                        }
                    }
                }, 0L, 20L);
                viewer.setTask(task);
            }
        }
    }

    @EventHandler
    public static void blockBreak(BlockBreakEvent event) {
        dLocation location = new dLocation(event.getBlock().getLocation());
        for (Viewer viewer : viewers.values()) {
            if (!Utilities.isBlock(location, viewer.getLocation())) continue;
            event.getPlayer().sendMessage(ChatColor.RED + "You're not allowed to break that sign.");
            event.setCancelled(true);
        }
    }

    public void onEnable() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void onDisable() {
        for (Viewer viewer : viewers.values()) {
            viewer.save();
        }
    }

    private static class Viewer {
        private String id;
        private String content;
        private dLocation location;
        private int task;

        private Viewer(String id) {
            this.id = id;
        }

        private Viewer(String id, String content, dLocation location) {
            this.id = id;
            this.content = content;
            this.location = location;
        }

        void setContent(String content) {
            this.content = content;
        }

        void setLocation(dLocation location) {
            this.location = location;
        }

        void setTask(int task) {
            this.task = task;
        }

        private String getContent() {
            return this.content;
        }

        private dLocation getLocation() {
            return this.location;
        }

        private int getTask() {
            return this.task;
        }

        void save() {
            FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
            saves.set("Viewers." + this.id.toLowerCase() + ".content", (Object)this.content);
            saves.set("Viewers." + this.id.toLowerCase() + ".location", (Object)this.location.identify());
        }

        void remove() {
            FileConfiguration saves = DenizenAPI.getCurrentInstance().getSaves();
            saves.set("Viewers." + this.id.toLowerCase(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Display {
        LOCATION,
        SCORE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        SIGN_POST,
        WALL_SIGN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        CREATE,
        MODIFY,
        REMOVE;

    }
}

