/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.containers.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.BlockIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BukkitWorldScriptHelper
implements Listener {
    private final Map<String, Integer> current_time = new HashMap<String, Integer>();

    public BukkitWorldScriptHelper() {
        DenizenAPI.getCurrentInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public static String doEvents(List<String> events, dNPC npc, dPlayer player, Map<String, dObject> context) {
        return BukkitWorldScriptHelper.doEvents(events, npc, player, context, false);
    }

    public static String doEvents(List<String> events, dNPC npc, dPlayer player, Map<String, dObject> context, boolean useids) {
        List<String> determ = useids ? OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context, true) : OldEventManager.doEvents(events, new BukkitScriptEntryData(player, npc), context);
        return determ.size() > 0 ? determ.get(0) : "none";
    }

    public void serverStartEvent() {
        long ticks = Settings.worldScriptTimeEventFrequency().getTicks();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                BukkitWorldScriptHelper.this.timeEvent();
            }
        }, ticks, ticks);
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("server start"), null, null, null);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            Bukkit.getServer().shutdown();
        }
    }

    public void timeEvent() {
        for (World world : Bukkit.getWorlds()) {
            dWorld currentWorld;
            int hour = Double.valueOf(world.getTime() / 1000L).intValue();
            if ((hour += 6) >= 24) {
                hour -= 24;
            }
            if (this.current_time.containsKey((currentWorld = new dWorld(world)).identifySimple()) && this.current_time.get(currentWorld.identifySimple()) == hour) continue;
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("time", new Element(hour));
            context.put("world", currentWorld);
            BukkitWorldScriptHelper.doEvents(Arrays.asList("time changes", "time changes in " + currentWorld.identifySimple(), String.valueOf(hour) + ":00 in " + currentWorld.identifySimple(), "time " + String.valueOf(hour) + " in " + currentWorld.identifySimple()), null, null, context, true);
            this.current_time.put(currentWorld.identifySimple(), hour);
        }
    }

    @EventHandler
    public void projectileHit(ProjectileHitEvent event) {
        dPlayer player = null;
        dNPC npc = null;
        if (event.getEntity() == null) {
            return;
        }
        dEntity projectile = new dEntity((Entity)event.getEntity());
        if (projectile.getLocation() == null) {
            return;
        }
        if (Double.isNaN(projectile.getLocation().getDirection().normalize().getX())) {
            return;
        }
        Block block = null;
        try {
            BlockIterator bi = new BlockIterator(projectile.getLocation().getWorld(), projectile.getLocation().toVector(), projectile.getLocation().getDirection().normalize(), 0.0, 4);
            while (bi.hasNext() && (block = bi.next()).getTypeId() == 0) {
            }
        }
        catch (IllegalStateException ex) {
            return;
        }
        if (block == null) {
            return;
        }
        dEntity shooter = projectile.getShooter();
        dMaterial material = dMaterial.getMaterialFrom(block.getType(), block.getData());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("projectile", projectile);
        context.put("location", new dLocation(block.getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("projectile hits block");
        events.add("projectile hits " + material.identifySimple());
        events.add(projectile.identifyType() + " hits block");
        events.add(projectile.identifyType() + " hits " + material.identifySimple());
        if (shooter != null) {
            context.put("shooter", shooter.getDenizenObject());
            if (shooter.isCitizensNPC()) {
                npc = shooter.getDenizenNPC();
            } else if (shooter.isPlayer()) {
                player = shooter.getDenizenPlayer();
            }
            events.add("entity shoots block");
            events.add("entity shoots block with " + projectile.identifyType());
            events.add("entity shoots " + material.identifySimple() + " with " + projectile.identifyType());
            events.add("entity shoots " + material.identifySimple());
            events.add(shooter.identifyType() + " shoots block");
            events.add(shooter.identifyType() + " shoots block with " + projectile.identifyType());
            events.add(shooter.identifyType() + " shoots " + material.identifySimple() + " with " + projectile.identifyType());
            events.add(shooter.identifyType() + " shoots " + material.identifySimple());
        }
        BukkitWorldScriptHelper.doEvents(events, npc, player, context, true);
    }

    @EventHandler
    public void craftItemEvent(PrepareItemCraftEvent event) {
        dItem result;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        ArrayList<String> events = new ArrayList<String>();
        events.add("item crafted");
        CraftingInventory inventory = event.getInventory();
        context.put("inventory", new dInventory((Inventory)inventory));
        Recipe recipe = event.getRecipe();
        dItem dItem2 = result = recipe.getResult() != null ? new dItem(recipe.getResult()) : null;
        if (result != null) {
            context.put("item", result);
            events.add(result.identifySimple() + " crafted");
            events.add(result.identifyMaterial() + " crafted");
        }
        dList recipeList = new dList();
        for (ItemStack item : inventory.getMatrix()) {
            if (item != null) {
                recipeList.add(new dItem(item).identify());
                continue;
            }
            recipeList.add(new dItem(Material.AIR).identify());
        }
        context.put("recipe", recipeList);
        Player player = (Player)event.getView().getPlayer();
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)player), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            inventory.setResult(null);
            player.updateInventory();
        } else if (dItem.matches(determination)) {
            inventory.setResult(dItem.valueOf(determination).getItemStack());
            player.updateInventory();
        }
    }

    @EventHandler
    public void inventoryClickEvent(InventoryClickEvent event) {
        dItem holding;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        dInventory inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        final dPlayer player = dEntity.getPlayerFrom((Entity)((Player)event.getWhoClicked()));
        String type = event.getInventory().getType().name();
        String click = event.getClick().name();
        String slotType = event.getSlotType().name();
        ArrayList<String> events = new ArrayList<String>();
        events.add("player clicks in inventory");
        events.add("player clicks in " + type);
        events.add("player clicks in " + inventory.identifySimple());
        String interaction = "player " + click + " clicks ";
        events.add(interaction + "in inventory");
        events.add(interaction + "in " + type);
        events.add(interaction + "in " + inventory.identifySimple());
        if (event.getCursor() != null) {
            holding = new dItem(event.getCursor());
            context.put("cursor_item", holding);
            events.add(interaction + "in inventory with " + holding.identifySimple());
            events.add(interaction + "in " + type + " with " + holding.identifySimple());
            events.add(interaction + "in " + inventory.identifySimple() + " with " + holding.identifySimple());
            events.add(interaction + "in inventory with " + holding.identifyMaterial());
            events.add(interaction + "in " + type + " with " + holding.identifyMaterial());
            events.add(interaction + "in " + inventory.identifySimple() + " with " + holding.identifyMaterial());
            events.add("player clicks in inventory with " + holding.identifySimple());
            events.add("player clicks in " + type + " with " + holding.identifySimple());
            events.add("player clicks in " + inventory.identifySimple() + " with " + holding.identifySimple());
            events.add("player clicks in inventory with " + holding.identifyMaterial());
            events.add("player clicks in " + type + " with " + holding.identifyMaterial());
            events.add("player clicks in " + inventory.identifySimple() + " with " + holding.identifyMaterial());
        }
        if (event.getCurrentItem() != null) {
            item = new dItem(event.getCurrentItem());
            events.add("player clicks " + item.identifySimple() + " in inventory");
            events.add(interaction + item.identifySimple() + " in inventory");
            events.add("player clicks " + item.identifySimple() + " in " + type);
            events.add(interaction + item.identifySimple() + " in " + type);
            events.add("player clicks " + item.identifySimple() + " in " + inventory.identifySimple());
            events.add(interaction + item.identifySimple() + " in " + inventory.identifySimple());
            events.add("player clicks " + item.identifyMaterial() + " in inventory");
            events.add(interaction + item.identifyMaterial() + " in inventory");
            events.add("player clicks " + item.identifyMaterial() + " in " + type);
            events.add(interaction + item.identifyMaterial() + " in " + type);
            events.add("player clicks " + item.identifyMaterial() + " in " + inventory.identifySimple());
            events.add(interaction + item.identifyMaterial() + " in " + inventory.identifySimple());
            if (event.getCursor() != null) {
                holding = new dItem(event.getCursor());
                String[] itemStrings = new String[]{item.identifySimple(), item.identifyMaterial()};
                String[] inventoryStrings = new String[]{"inventory", type, inventory.identifySimple()};
                String[] holdingStrings = new String[]{holding.identifySimple(), holding.identifyMaterial()};
                for (String itemString : itemStrings) {
                    for (String inventoryString : inventoryStrings) {
                        for (String holdingString : holdingStrings) {
                            String fullString = itemString + " in " + inventoryString + " with " + holdingString;
                            events.add("player clicks " + fullString);
                            events.add(interaction + fullString);
                        }
                    }
                }
            }
        }
        context.put("item", item);
        context.put("inventory", inventory);
        context.put("click", new Element(click));
        context.put("slot_type", new Element(slotType));
        context.put("slot", new Element(event.getSlot() + 1));
        context.put("raw_slot", new Element(event.getRawSlot() + 1));
        context.put("is_shift_click", new Element(event.isShiftClick()));
        context.put("action", new Element(event.getAction().name()));
        context.put("hotbar_button", new Element(event.getHotbarButton()));
        String determination = BukkitWorldScriptHelper.doEvents(events, null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
            final InventoryHolder holder = event.getInventory().getHolder();
            new BukkitRunnable(){

                public void run() {
                    player.getPlayerEntity().updateInventory();
                    if (holder != null && holder instanceof Player) {
                        ((Player)holder).updateInventory();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
        }
    }

    @EventHandler
    public void inventoryDragEvent(InventoryDragEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = null;
        Inventory inventory = event.getInventory();
        final dPlayer player = dEntity.getPlayerFrom((Entity)((Player)event.getWhoClicked()));
        String type = event.getInventory().getType().name();
        ArrayList<String> events = new ArrayList<String>();
        events.add("player drags");
        events.add("player drags in inventory");
        events.add("player drags in " + type);
        if (event.getOldCursor() != null) {
            item = new dItem(event.getOldCursor());
            events.add("player drags " + item.identifySimple());
            events.add("player drags " + item.identifySimple() + " in inventory");
            events.add("player drags " + item.identifySimple() + " in " + type);
            events.add("player drags " + item.identifyMaterial());
            events.add("player drags " + item.identifyMaterial() + " in inventory");
            events.add("player drags " + item.identifyMaterial() + " in " + type);
        }
        context.put("item", item);
        context.put("inventory", dInventory.mirrorBukkitInventory(inventory));
        dList slots = new dList();
        for (Integer slot : event.getInventorySlots()) {
            slots.add(slot.toString());
        }
        context.put("slots", slots);
        dList raw_slots = new dList();
        for (Integer raw_slot : event.getRawSlots()) {
            raw_slots.add(raw_slot.toString());
        }
        context.put("raw_slots", raw_slots);
        String determination = BukkitWorldScriptHelper.doEvents(events, null, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
            final InventoryHolder holder = inventory.getHolder();
            new BukkitRunnable(){

                public void run() {
                    player.getPlayerEntity().updateInventory();
                    if (holder != null && holder instanceof Player) {
                        ((Player)holder).updateInventory();
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        final String message = ChatColor.DARK_GREEN + "CHAT: " + event.getPlayer().getName() + ": " + event.getMessage();
        Bukkit.getScheduler().runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), new Runnable(){

            public void run() {
                if (dB.record) {
                    dB.log(message);
                }
            }
        }, 1L);
    }

    @EventHandler
    public void playerEditBook(PlayerEditBookEvent event) {
        String determination;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        if (event.isSigning()) {
            context.put("title", new Element(event.getNewBookMeta().getTitle()));
        }
        context.put("pages", new Element(event.getNewBookMeta().getPageCount()));
        context.put("book", new dItem(event.getPlayer().getInventory().getItem(event.getSlot())));
        context.put("signing", new Element(event.isSigning()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player edits book");
        if (event.isSigning()) {
            events.add("player signs book");
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (determination.toUpperCase().startsWith("NOT_SIGNING")) {
            event.setSigning(false);
        } else if (dScript.matches(determination)) {
            dScript script = dScript.valueOf(determination);
            if (script.getContainer() instanceof BookScriptContainer) {
                dItem book = ((BookScriptContainer)script.getContainer()).getBookFrom(dPlayer.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer()), null);
                event.setNewBookMeta((BookMeta)book.getItemStack().getItemMeta());
                if (book.getItemStack().getType() == Material.BOOK_AND_QUILL) {
                    event.setSigning(false);
                }
            } else {
                dB.echoError("Script '" + determination + "' is valid, but not of type 'book'!");
            }
        }
    }

    @EventHandler
    public void playerBreakItem(PlayerItemBreakEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        final ItemStack itemstack = event.getBrokenItem();
        dItem item = new dItem(itemstack);
        context.put("item", item);
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player breaks item", "player breaks " + item.identifySimple(), "player breaks " + item.identifyMaterial()), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context).toUpperCase();
        if (determination.startsWith("CANCELLED")) {
            itemstack.setAmount(itemstack.getAmount() + 1);
            final Player player = event.getPlayer();
            new BukkitRunnable(){

                public void run() {
                    itemstack.setDurability(itemstack.getType().getMaxDurability());
                    player.updateInventory();
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 1L);
        }
    }

    @EventHandler
    public void playerAnimation(PlayerAnimationEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        String animation = event.getAnimationType().name();
        context.put("animation", new Element(animation));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player animates", "player animates " + animation), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedEnter(PlayerBedEnterEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player enters bed"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerBedLeave(PlayerBedLeaveEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getBed().getLocation()));
        BukkitWorldScriptHelper.doEvents(Arrays.asList("player leaves bed"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
    }

    @EventHandler
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld originWorld = new dWorld(event.getFrom());
        dWorld destinationWorld = new dWorld(event.getPlayer().getWorld());
        context.put("origin_world", originWorld);
        context.put("destination_world", destinationWorld);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("player changes world", "player changes world from " + originWorld.identifySimple(), "player changes world to " + destinationWorld.identifySimple(), "player changes world from " + originWorld.identifySimple() + " to " + destinationWorld.identifySimple()), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
    }

    @EventHandler
    public void playerDropItem(PlayerDropItemEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItemDrop().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItemDrop()));
        context.put("location", new dLocation(event.getItemDrop().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player drops item");
        events.add("player drops " + item.identifySimple());
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerEggThrow(PlayerEggThrowEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity egg = new dEntity((Entity)event.getEgg());
        context.put("egg", egg);
        context.put("is_hatching", new Element(event.isHatching()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player throws egg");
        if (event.isHatching()) {
            events.add("player throws hatching egg");
        } else {
            events.add("player throws non-hatching egg");
        }
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.equalsIgnoreCase("CANCELLED")) {
            event.setHatching(false);
        } else if (dEntity.matches(determination)) {
            event.setHatching(true);
            event.setHatchingType(dEntity.valueOf(determination).getBukkitEntityType());
        }
    }

    @EventHandler
    public void playerExpChange(PlayerExpChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("amount", new Element(event.getAmount()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player changes xp"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context).toUpperCase();
        if (determination.equals("CANCELLED")) {
            event.setAmount(0);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Integer)) {
            event.setAmount(Integer.valueOf(determination).intValue());
        }
    }

    @EventHandler
    public void playerFish(PlayerFishEvent event) {
        String determination;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        dNPC npc = null;
        String state = event.getState().name();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("hook", new dEntity((Entity)event.getHook()));
        context.put("state", new Element(state));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player fishes");
        events.add("player fishes while " + state);
        if (event.getCaught() != null) {
            Entity caught = event.getCaught();
            dEntity entity = new dEntity(caught);
            context.put("entity", entity.getDenizenObject());
            if (caught instanceof Item) {
                context.put("item", new dItem(((Item)caught).getItemStack()));
            }
            if (entity.isCitizensNPC()) {
                npc = entity.getDenizenNPC();
            }
            events.add("player fishes " + entity.identifyType());
            events.add("player fishes " + entity.identifyType() + " while " + state);
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, npc, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerGameModeChange(PlayerGameModeChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("gamemode", new Element(event.getNewGameMode().name()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player changes gamemode", "player changes gamemode to " + event.getNewGameMode().name()), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteract(PlayerInteractEvent event) {
        String determination;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        Action action = event.getAction();
        dItem item = null;
        dPlayer player = dEntity.getPlayerFrom((Entity)event.getPlayer());
        ArrayList<String> events = new ArrayList<String>();
        if (event.getBlockFace() != null && event.getClickedBlock() != null) {
            context.put("relative", new dLocation(event.getClickedBlock().getRelative(event.getBlockFace()).getLocation()));
        }
        String[] interactions = action == Action.LEFT_CLICK_AIR || action == Action.LEFT_CLICK_BLOCK ? new String[]{"player left clicks", "player clicks"} : (action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK ? new String[]{"player right clicks", "player clicks"} : new String[]{"player stands on"});
        context.put("click_type", new Element(action.name()));
        for (String interaction : interactions) {
            events.add(interaction);
        }
        if (event.hasItem()) {
            item = new dItem(event.getItem());
            context.put("item", item);
            for (String interaction : interactions) {
                events.add(interaction + " with item");
                events.add(interaction + " with " + item.identifySimple());
                events.add(interaction + " with " + item.identifyMaterial());
            }
        }
        if (event.hasBlock()) {
            Block block = event.getClickedBlock();
            dMaterial blockMaterial = dMaterial.getMaterialFrom(block.getType(), block.getData());
            context.put("location", new dLocation(block.getLocation()));
            for (String interaction : interactions) {
                events.add(interaction + " block");
                events.add(interaction + " " + blockMaterial.identifySimple());
            }
            if (event.hasItem()) {
                for (String interaction : interactions) {
                    events.add(interaction + " block with item");
                    events.add(interaction + " block with " + item.identifySimple());
                    events.add(interaction + " block with " + item.identifyMaterial());
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with item");
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with " + item.identifySimple());
                    events.add(interaction + " " + blockMaterial.identifySimple() + " with " + item.identifyMaterial());
                }
            }
            List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getClickedBlock().getLocation());
            dList cuboid_context = new dList();
            for (String interaction : interactions) {
                if (cuboids.size() > 0) {
                    events.add(interaction + " block in notable cuboid");
                    events.add(interaction + ' ' + blockMaterial.identifySimple() + " in notable cuboid");
                }
                for (dCuboid cuboid : cuboids) {
                    events.add(interaction + " block in " + cuboid.identifySimple());
                    events.add(interaction + ' ' + blockMaterial.identifySimple() + " in " + cuboid.identifySimple());
                }
            }
            for (dCuboid cuboid : cuboids) {
                cuboid_context.add(cuboid.identifySimple());
            }
            context.put("cuboids", cuboid_context);
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, null, player, context, true).toUpperCase()).startsWith("CANCELLED:FALSE")) {
            event.setCancelled(false);
        } else if (determination.startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteractStand(PlayerInteractAtEntityEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getPlayer().getWorld(), event.getClickedPosition().getX(), event.getClickedPosition().getY(), event.getClickedPosition().getZ()));
        dEntity entity = new dEntity(event.getRightClicked());
        context.put("entity", entity);
        dItem item = new dItem(event.getPlayer().getItemInHand());
        context.put("item", item);
        dNPC npc = null;
        if (entity.isCitizensNPC()) {
            npc = entity.getDenizenNPC();
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("player right clicks at entity");
        events.add("player right clicks at " + entity.identifyType());
        events.add("player right clicks at entity with " + item.identifySimple());
        events.add("player right clicks at " + entity.identifyType() + " with " + item.identifySimple());
        events.add("player right clicks at entity with " + item.identifyMaterial());
        events.add("player right clicks at " + entity.identifyType() + " with " + item.identifyMaterial());
        List<dCuboid> cuboids = dCuboid.getNotableCuboidsContaining(event.getRightClicked().getLocation());
        if (cuboids.size() > 0) {
            events.add("player right clicks at entity in notable cuboid");
            events.add("player right clicks at " + entity.identifyType() + " in notable cuboid");
        }
        dList cuboid_context = new dList();
        for (dCuboid cuboid : cuboids) {
            events.add("player right clicks at entity in " + cuboid.identifySimple());
            events.add("player right clicks at " + entity.identifyType() + " in " + cuboid.identifySimple());
            cuboid_context.add(cuboid.identifySimple());
        }
        context.put("cuboids", cuboid_context);
        List<String> determinations = OldEventManager.doEvents(events, new BukkitScriptEntryData(dEntity.getPlayerFrom((Entity)event.getPlayer()), npc), context, true);
        for (String determination : determinations) {
            if (!determination.equalsIgnoreCase("CANCELLED")) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerInteractEntity(PlayerInteractEntityEvent event) {
        List<dCuboid> cuboids;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        dNPC npc = null;
        dItem item = new dItem(event.getPlayer().getItemInHand());
        dEntity entity = new dEntity(event.getRightClicked());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRightClicked().getLocation()));
        context.put("entity", entity.getDenizenObject());
        context.put("item", item);
        if (entity.isCitizensNPC()) {
            npc = entity.getDenizenNPC();
        }
        ArrayList<String> events = new ArrayList<String>();
        events.add("player right clicks entity");
        events.add("player right clicks " + entity.identifyType());
        events.add("player right clicks entity with " + item.identifySimple());
        events.add("player right clicks " + entity.identifyType() + " with " + item.identifySimple());
        events.add("player right clicks entity with " + item.identifyMaterial());
        events.add("player right clicks " + entity.identifyType() + " with " + item.identifyMaterial());
        if (entity.getBukkitEntity() instanceof ItemFrame) {
            dItem itemFrame = new dItem(((ItemFrame)entity.getBukkitEntity()).getItem());
            context.put("itemframe", itemFrame);
            events.add("player right clicks " + entity.identifyType() + " " + itemFrame.identifySimple());
            events.add("player right clicks " + entity.identifyType() + " " + itemFrame.identifyMaterial());
        }
        if ((cuboids = dCuboid.getNotableCuboidsContaining(event.getRightClicked().getLocation())).size() > 0) {
            events.add("player right clicks entity in notable cuboid");
            events.add("player right clicks " + entity.identifyType() + " in notable cuboid");
        }
        dList cuboid_context = new dList();
        for (dCuboid cuboid : cuboids) {
            events.add("player right clicks entity in " + cuboid.identifySimple());
            events.add("player right clicks " + entity.identifyType() + " in " + cuboid.identifySimple());
            cuboid_context.add(cuboid.identifySimple());
        }
        context.put("cuboids", cuboid_context);
        String determination = BukkitWorldScriptHelper.doEvents(events, npc, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerItemConsume(PlayerItemConsumeEvent event) {
        dItem newitem;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        dItem item = new dItem(event.getItem());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("item", item);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player consumes item");
        events.add("player consumes " + item.identifySimple());
        events.add("player consumes " + item.identifyMaterial());
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (dItem.matches(determination) && (newitem = dItem.valueOf(determination, dEntity.getPlayerFrom((Entity)event.getPlayer()), null)) != null) {
            event.setItem(newitem.getItemStack());
        }
    }

    @EventHandler
    public void playerJoinEvent(PlayerJoinEvent event) {
        Scoreboard score;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        Player player = event.getPlayer();
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getJoinMessage()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player joins", "player join"), null, dEntity.getPlayerFrom((Entity)player), context);
        if (!determination.equals("none")) {
            event.setJoinMessage(determination);
        }
        if (ScoreboardHelper.viewerMap.containsKey(player.getName()) && (score = ScoreboardHelper.getScoreboard(ScoreboardHelper.viewerMap.get(player.getName()))) != null) {
            player.setScoreboard(score);
        }
    }

    @EventHandler
    public void playerKick(PlayerKickEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getLeaveMessage()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player kicked"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (!determination.equals("none")) {
            event.setLeaveMessage(determination);
        }
    }

    @EventHandler
    public void playerLeashEntity(PlayerLeashEntityEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("entity", entity);
        context.put("holder", new dEntity(event.getLeashHolder()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player leashes entity", "player leashes " + entity.identifyType()), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.equalsIgnoreCase("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerLevelChange(PlayerLevelChangeEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("level", new Element(event.getNewLevel()));
        BukkitWorldScriptHelper.doEvents(Arrays.asList("player levels up", "player levels up to " + event.getNewLevel(), "player levels up from " + event.getOldLevel()), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
    }

    @EventHandler
    public void playerLogin(PlayerLoginEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        ArrayList<String> events = new ArrayList<String>();
        context.put("hostname", new Element(event.getHostname()));
        if (!dPlayer.isNoted((OfflinePlayer)event.getPlayer())) {
            events.add("player logs in for the first time");
            events.add("player first login");
        }
        dPlayer.notePlayer((OfflinePlayer)event.getPlayer());
        events.add("player logs in");
        events.add("player login");
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("KICKED")) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, determination.length() > 7 ? determination.substring(7) : determination);
        }
    }

    @EventHandler
    public void playerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlock().equals(event.getTo().getBlock())) {
            return;
        }
        String name = NotableManager.getSavedId(new dLocation(event.getTo().getBlock().getLocation()));
        if (name != null) {
            HashMap<String, dObject> context = new HashMap<String, dObject>();
            context.put("notable", new Element(name));
            String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player walks over notable", "player walks over " + name, "walked over notable", "walked over " + name), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
            if (determination.toUpperCase().startsWith("CANCELLED") || determination.toUpperCase().startsWith("FROZEN")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void playerPickupItem(PlayerPickupItemEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dItem item = new dItem(event.getItem().getItemStack());
        context.put("item", item);
        context.put("entity", new dEntity((Entity)event.getItem()));
        context.put("location", new dLocation(event.getItem().getLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player picks up item");
        events.add("player picks up " + item.identifySimple());
        events.add("player picks up " + item.identifyMaterial());
        events.add("player takes item");
        events.add("player takes " + item.identifySimple());
        events.add("player takes " + item.identifyMaterial());
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("message", new Element(event.getQuitMessage()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player quits", "player quit"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (!determination.equals("none")) {
            event.setQuitMessage(determination);
        }
    }

    @EventHandler
    public void playerRespawn(PlayerRespawnEvent event) {
        dLocation location;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("location", new dLocation(event.getRespawnLocation()));
        ArrayList<String> events = new ArrayList<String>();
        events.add("player respawns");
        if (event.isBedSpawn()) {
            events.add("player respawns at bed");
        } else {
            events.add("player respawns elsewhere");
        }
        String determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (dLocation.matches(determination) && (location = dLocation.valueOf(determination)) != null) {
            event.setRespawnLocation((Location)location);
        }
    }

    @EventHandler
    public void playerShearEntity(PlayerShearEntityEvent event) {
        String determination;
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity entity = new dEntity(event.getEntity());
        context.put("entity", entity);
        ArrayList<String> events = new ArrayList<String>();
        events.add("player shears entity");
        events.add("player shears " + entity.identifyType());
        if (entity.getEntityType().equals(EntityType.SHEEP)) {
            String color = ((Sheep)entity.getBukkitEntity()).getColor().name();
            events.add("player shears " + color + " sheep");
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleFlight(PlayerToggleFlightEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isFlying()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player toggles flight", "player " + (event.isFlying() ? "starts" : "stops") + " flying"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSneak(PlayerToggleSneakEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSneaking()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player toggles sneak", "player " + (event.isSneaking() ? "starts" : "stops") + " sneaking"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void playerToggleSprint(PlayerToggleSprintEvent event) {
        if (dEntity.isNPC((Entity)event.getPlayer())) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("state", new Element(event.isSprinting()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("player toggles sprint", "player " + (event.isSprinting() ? "starts" : "stops") + " sprinting"), null, dEntity.getPlayerFrom((Entity)event.getPlayer()), context);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleCreate(VehicleCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        context.put("vehicle", vehicle);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("vehicle created", vehicle.identifyType() + " created", vehicle.identifySimple() + " created"), null, null, context, true);
    }

    @EventHandler
    public void vehicleDamage(VehicleDamageEvent event) {
        String determination;
        dPlayer player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("damage", new Element(event.getDamage()));
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle damaged");
        events.add(vehicle.identifyType() + " damaged");
        events.add(vehicle.identifySimple() + " damaged");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            context.put("entity", entity.getDenizenObject());
            if (entity.isCitizensNPC()) {
                npc = entity.getDenizenNPC();
            } else if (entity.isPlayer()) {
                player = entity.getDenizenPlayer();
            }
            events.add("entity damages vehicle");
            events.add("entity damages " + vehicle.identifyType());
            events.add("entity damages " + vehicle.identifySimple());
            events.add(entity.identifyType() + " damages vehicle");
            events.add(entity.identifyType() + " damages " + vehicle.identifyType());
            events.add(entity.identifyType() + " damages " + vehicle.identifySimple());
            events.add(entity.identifySimple() + " damages vehicle");
            events.add(entity.identifySimple() + " damages " + vehicle.identifyType());
            events.add(entity.identifySimple() + " damages " + vehicle.identifySimple());
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        } else if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Double)) {
            event.setDamage(aH.getDoubleFrom(determination));
        }
    }

    @EventHandler
    public void vehicleDestroy(VehicleDestroyEvent event) {
        String determination;
        dPlayer player = null;
        dNPC npc = null;
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        context.put("vehicle", vehicle);
        ArrayList<String> events = new ArrayList<String>();
        events.add("vehicle destroyed");
        events.add(vehicle.identifyType() + " destroyed");
        events.add(vehicle.identifySimple() + " destroyed");
        if (event.getAttacker() != null) {
            dEntity entity = new dEntity(event.getAttacker());
            context.put("entity", entity.getDenizenObject());
            if (entity.isCitizensNPC()) {
                npc = entity.getDenizenNPC();
            } else if (entity.isPlayer()) {
                player = entity.getDenizenPlayer();
            }
            events.add("entity destroys vehicle");
            events.add("entity destroys " + vehicle.identifyType());
            events.add("entity destroys " + vehicle.identifySimple());
            events.add(entity.identifyType() + " destroys vehicle");
            events.add(entity.identifyType() + " destroys " + vehicle.identifyType());
            events.add(entity.identifyType() + " destroys " + vehicle.identifySimple());
            events.add(entity.identifySimple() + " destroys vehicle");
            events.add(entity.identifySimple() + " destroys " + vehicle.identifyType());
            events.add(entity.identifySimple() + " destroys " + vehicle.identifySimple());
        }
        if ((determination = BukkitWorldScriptHelper.doEvents(events, npc, player, context, true)).toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleEnter(VehicleEnterEvent event) {
        dPlayer player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity(event.getEntered());
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isCitizensNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getDenizenPlayer();
        }
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("entity enters vehicle", entity.identifyType() + " enters vehicle", entity.identifySimple() + " enters vehicle", "entity enters " + vehicle.identifyType(), "entity enters " + vehicle.identifySimple(), entity.identifyType() + " enters " + vehicle.identifyType(), entity.identifySimple() + " enters " + vehicle.identifyType(), entity.identifyType() + " enters " + vehicle.identifySimple(), entity.identifySimple() + " enters " + vehicle.identifySimple()), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void vehicleExit(VehicleExitEvent event) {
        dPlayer player = null;
        dNPC npc = null;
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dEntity vehicle = new dEntity((Entity)event.getVehicle());
        dEntity entity = new dEntity((Entity)event.getExited());
        context.put("vehicle", vehicle);
        context.put("entity", entity.getDenizenObject());
        if (entity.isCitizensNPC()) {
            npc = entity.getDenizenNPC();
        } else if (entity.isPlayer()) {
            player = entity.getDenizenPlayer();
        }
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("entity exits vehicle", "entity exits " + vehicle.identifyType(), "entity exits " + vehicle.identifySimple(), entity.identifyType() + " exits vehicle", entity.identifyType() + " exits " + vehicle.identifyType(), entity.identifyType() + " exits " + vehicle.identifySimple(), entity.identifySimple() + " exits " + vehicle.identifyType(), entity.identifySimple() + " exits " + vehicle.identifySimple()), npc, player, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void lightningStrike(LightningStrikeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("location", new dLocation(event.getLightning().getLocation()));
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("lightning strikes", "lightning strikes in " + world.identifySimple()), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void weatherChange(WeatherChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        ArrayList<String> events = new ArrayList<String>();
        events.add("weather changes");
        events.add("weather changes in " + world.identifySimple());
        if (event.toWeatherState()) {
            context.put("weather", new Element("rain"));
            events.add("weather rains");
            events.add("weather rains in " + world.identifySimple());
        } else {
            context.put("weather", new Element("clear"));
            events.add("weather clears");
            events.add("weather clears in " + world.identifySimple());
        }
        String determination = BukkitWorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void portalCreate(PortalCreateEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String reason = event.getReason().name();
        context.put("world", world);
        context.put("reason", new Element(reason));
        dList list = new dList();
        for (Block block : event.getBlocks()) {
            list.add(new dLocation(block.getLocation()).identify());
        }
        context.put("blocks", list);
        String determination = BukkitWorldScriptHelper.doEvents(Arrays.asList("portal created", "portal created because " + reason, "portal created in " + world.identifySimple(), "portal created in " + world.identifySimple() + " because " + reason), null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void spawnChange(SpawnChangeEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        context.put("old_location", new dLocation(event.getPreviousLocation()));
        context.put("new_location", new dLocation(world.getWorld().getSpawnLocation()));
        BukkitWorldScriptHelper.doEvents(Arrays.asList("spawn changes", "spawn changes in " + world.identifySimple()), null, null, context, true);
    }

    @EventHandler
    public void structureGrow(StructureGrowEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        String treeType = event.getSpecies().name();
        context.put("world", world);
        context.put("location", new dLocation(event.getLocation()));
        context.put("structure", new Element(treeType));
        dList structure = new dList();
        dList mats = new dList();
        for (BlockState state : event.getBlocks()) {
            structure.add(new dLocation(state.getLocation()).identify());
            mats.add(dMaterial.getMaterialFrom(state.getType(), state.getRawData()).identify());
        }
        context.put("blocks", structure);
        context.put("new_materials", mats);
        ArrayList<String> events = new ArrayList<String>();
        events.add("structure grows");
        events.add("structure grows in " + world.identifySimple());
        events.add(treeType + " grows");
        events.add(treeType + " grows in " + world.identifySimple());
        if (event.isFromBonemeal()) {
            events.add("structure grows from bonemeal");
            events.add("structure grows from bonemeal in " + world.identifySimple());
            events.add(treeType + " grows from bonemeal");
            events.add(treeType + " grows from bonemeal in " + world.identifySimple());
        } else {
            events.add("structure grows naturally");
            events.add("structure grows naturally in " + world.identifySimple());
            events.add(treeType + " grows naturally");
            events.add(treeType + " grows naturally in " + world.identifySimple());
        }
        String determination = BukkitWorldScriptHelper.doEvents(events, null, null, context, true);
        if (determination.toUpperCase().startsWith("CANCELLED")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void worldInit(WorldInitEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("world initializes", world.identifySimple() + " initializes"), null, null, context, true);
    }

    @EventHandler
    public void worldLoad(WorldLoadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("world loads", world.identifySimple() + " loads"), null, null, context, true);
    }

    @EventHandler
    public void worldSave(WorldSaveEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("world saves", world.identifySimple() + " saves"), null, null, context, true);
    }

    @EventHandler
    public void worldUnload(WorldUnloadEvent event) {
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        dWorld world = new dWorld(event.getWorld());
        context.put("world", world);
        BukkitWorldScriptHelper.doEvents(Arrays.asList("world unloads", world.identifySimple() + " unloads"), null, null, context, true);
    }
}

