/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.scripts.commands.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.dB;

public class DetermineCommand
extends AbstractCommand {
    public static String DETERMINE_NONE = "none";
    private static Map<Long, List<String>> cache = new ConcurrentHashMap<Long, List<String>>(8, 0.9f, 1);
    public static long uniqueId = 0L;

    public static long getNewId() {
        if (uniqueId == Long.MAX_VALUE) {
            uniqueId = 0L;
        }
        return uniqueId++;
    }

    public static boolean hasOutcome(long id) {
        return cache.containsKey(id) && !cache.get(id).isEmpty();
    }

    public static List<String> getOutcome(long id) {
        List<String> outcome = cache.get(id);
        cache.remove(id);
        return outcome;
    }

    public static String readOutcome(long id) {
        return cache.get(id).isEmpty() ? DETERMINE_NONE : cache.get(id).get(0);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (arg.matches("passive", "passively")) {
                scriptEntry.addObject("passively", new Element(true));
                continue;
            }
            if (!scriptEntry.hasObject("outcome")) {
                scriptEntry.addObject("outcome", new Element(arg.raw_value));
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("passively", new Element(false));
        scriptEntry.defaultObject("outcome", new Element(DETERMINE_NONE));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        List<Object> strs;
        dB.report(scriptEntry, this.getName(), scriptEntry.getElement("outcome").debug() + scriptEntry.getElement("passively").debug());
        String outcome = scriptEntry.getElement("outcome").asString();
        Boolean passively = scriptEntry.getElement("passively").asBoolean();
        Long uniqueId = (Long)scriptEntry.getObject("reqId");
        if (uniqueId == null) {
            dB.echoError(scriptEntry.getResidingQueue(), "Cannot use determine in this queue!");
            return;
        }
        if (cache.containsKey(uniqueId)) {
            strs = cache.get(uniqueId);
        } else {
            strs = new ArrayList();
            cache.put(uniqueId, strs);
        }
        strs.add(outcome);
        if (!passively.booleanValue()) {
            scriptEntry.getResidingQueue().clear();
        }
    }
}

