/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.DenizenCommandHandler;
import net.aufdemrand.denizen.NPCCommandHandler;
import net.aufdemrand.denizen.Settings;
import net.aufdemrand.denizen.events.block.BlockBuiltScriptEvent;
import net.aufdemrand.denizen.events.block.BlockBurnsScriptEvent;
import net.aufdemrand.denizen.events.block.BlockDispensesScriptEvent;
import net.aufdemrand.denizen.events.block.BlockFadesScriptEvent;
import net.aufdemrand.denizen.events.block.BlockFallsScriptEvent;
import net.aufdemrand.denizen.events.block.BlockFormsScriptEvent;
import net.aufdemrand.denizen.events.block.BlockGrowsScriptEvent;
import net.aufdemrand.denizen.events.block.BlockIgnitesScriptEvent;
import net.aufdemrand.denizen.events.block.BlockPhysicsScriptEvent;
import net.aufdemrand.denizen.events.block.BlockSpreadsScriptEvent;
import net.aufdemrand.denizen.events.bukkit.SavesReloadEvent;
import net.aufdemrand.denizen.events.bukkit.ScriptReloadEvent;
import net.aufdemrand.denizen.events.core.CommandSmartEvent;
import net.aufdemrand.denizen.events.core.CuboidEnterExitSmartEvent;
import net.aufdemrand.denizen.events.core.FlagSmartEvent;
import net.aufdemrand.denizen.events.core.NPCNavigationSmartEvent;
import net.aufdemrand.denizen.events.core.PlayerEquipsArmorSmartEvent;
import net.aufdemrand.denizen.events.entity.CreeperPoweredScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityBreaksHangingScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityChangesBlockScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityCombustsScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityCreatePortalScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityDamagedScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityDeathScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityDespawnScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityEntersPortalScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityExitsPortalScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityExplodesScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityExplosionPrimesScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityFoodLevelChangeScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityFormsBlockScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityHealsScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityInteractScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityKilledScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityShootsBowEvent;
import net.aufdemrand.denizen.events.entity.EntitySpawnScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityTamesScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityTargetsScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityTeleportScriptEvent;
import net.aufdemrand.denizen.events.entity.EntityUnleashedScriptEvent;
import net.aufdemrand.denizen.events.entity.HangingBreaksScriptEvent;
import net.aufdemrand.denizen.events.entity.HorseJumpsScriptEvent;
import net.aufdemrand.denizen.events.entity.ItemDespawnsScriptEvent;
import net.aufdemrand.denizen.events.entity.ItemEnchantedScriptEvent;
import net.aufdemrand.denizen.events.entity.ItemSpawnsScriptEvent;
import net.aufdemrand.denizen.events.entity.PigZappedScriptEvent;
import net.aufdemrand.denizen.events.entity.ProjectileLaunchedScriptEvent;
import net.aufdemrand.denizen.events.entity.SheepDyedScriptEvent;
import net.aufdemrand.denizen.events.entity.SheepRegrowsScriptEvent;
import net.aufdemrand.denizen.events.entity.SlimeSplitsScriptEvent;
import net.aufdemrand.denizen.events.entity.VehicleCollidesBlockScriptEvent;
import net.aufdemrand.denizen.events.entity.VehicleCollidesEntityScriptEvent;
import net.aufdemrand.denizen.events.entity.VehicleMoveScriptEvent;
import net.aufdemrand.denizen.events.player.BiomeEnterExitScriptEvent;
import net.aufdemrand.denizen.events.player.ChatScriptEvent;
import net.aufdemrand.denizen.events.player.ItemScrollScriptEvent;
import net.aufdemrand.denizen.events.player.ListPingScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerAnimatesScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerBreaksBlockScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerChangesSignScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerChangesWorldScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerClosesInvScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerConsumesScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerDamagesBlockScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerDropsItemScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerEntersBedScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerJumpScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerLeavesBedScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerOpensInvScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerPlacesBlockScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerPlacesHangingScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerStepsOnScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerTakesFromFurnaceScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerUsesPortalScriptEvent;
import net.aufdemrand.denizen.events.player.PlayerWalkScriptEvent;
import net.aufdemrand.denizen.events.player.ResourcePackStatusScriptEvent;
import net.aufdemrand.denizen.events.world.BrewsScriptEvent;
import net.aufdemrand.denizen.events.world.BucketEmptyScriptEvent;
import net.aufdemrand.denizen.events.world.BucketFillScriptEvent;
import net.aufdemrand.denizen.events.world.ChunkLoadScriptEvent;
import net.aufdemrand.denizen.events.world.ChunkUnloadScriptEvent;
import net.aufdemrand.denizen.events.world.FurnaceBurnsItemScriptEvent;
import net.aufdemrand.denizen.events.world.FurnaceSmeltsItemScriptEvent;
import net.aufdemrand.denizen.events.world.InvPicksUpItemScriptEvent;
import net.aufdemrand.denizen.events.world.ItemMoveScriptEvent;
import net.aufdemrand.denizen.events.world.LeafDecaysScriptEvent;
import net.aufdemrand.denizen.events.world.LightningStrikesScriptEvent;
import net.aufdemrand.denizen.events.world.LiquidSpreadScriptEvent;
import net.aufdemrand.denizen.events.world.PistonExtendsScriptEvent;
import net.aufdemrand.denizen.events.world.PistonRetractsScriptEvent;
import net.aufdemrand.denizen.events.world.PortalCreateScriptEvent;
import net.aufdemrand.denizen.events.world.PotionSplashScriptEvent;
import net.aufdemrand.denizen.events.world.RedstoneScriptEvent;
import net.aufdemrand.denizen.events.world.SpawnChangeScriptEvent;
import net.aufdemrand.denizen.events.world.StructureGrowsScriptEvent;
import net.aufdemrand.denizen.events.world.WeatherChangesScriptEvent;
import net.aufdemrand.denizen.events.world.WorldInitsScriptEvent;
import net.aufdemrand.denizen.events.world.WorldLoadsScriptEvent;
import net.aufdemrand.denizen.events.world.WorldSavesScriptEvent;
import net.aufdemrand.denizen.events.world.WorldUnloadsScriptEvent;
import net.aufdemrand.denizen.flags.FlagManager;
import net.aufdemrand.denizen.listeners.ListenerRegistry;
import net.aufdemrand.denizen.npc.dNPCRegistry;
import net.aufdemrand.denizen.npc.speech.DenizenChat;
import net.aufdemrand.denizen.npc.traits.AssignmentTrait;
import net.aufdemrand.denizen.npc.traits.ChatbotTrait;
import net.aufdemrand.denizen.npc.traits.ConstantsTrait;
import net.aufdemrand.denizen.npc.traits.FishingTrait;
import net.aufdemrand.denizen.npc.traits.HealthTrait;
import net.aufdemrand.denizen.npc.traits.HungerTrait;
import net.aufdemrand.denizen.npc.traits.InvisibleTrait;
import net.aufdemrand.denizen.npc.traits.MobproxTrait;
import net.aufdemrand.denizen.npc.traits.NicknameTrait;
import net.aufdemrand.denizen.npc.traits.ParticlesTrait;
import net.aufdemrand.denizen.npc.traits.PushableTrait;
import net.aufdemrand.denizen.npc.traits.SittingTrait;
import net.aufdemrand.denizen.npc.traits.SleepingTrait;
import net.aufdemrand.denizen.npc.traits.SneakingTrait;
import net.aufdemrand.denizen.npc.traits.TriggerTrait;
import net.aufdemrand.denizen.objects.dBiome;
import net.aufdemrand.denizen.objects.dChunk;
import net.aufdemrand.denizen.objects.dColor;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.objects.dPlugin;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.objects.notable.NotableManager;
import net.aufdemrand.denizen.objects.properties.bukkit.BukkitElementProperties;
import net.aufdemrand.denizen.objects.properties.bukkit.BukkitListProperties;
import net.aufdemrand.denizen.objects.properties.bukkit.BukkitQueueProperties;
import net.aufdemrand.denizen.objects.properties.bukkit.BukkitScriptProperties;
import net.aufdemrand.denizen.objects.properties.entity.EntityAI;
import net.aufdemrand.denizen.objects.properties.entity.EntityAge;
import net.aufdemrand.denizen.objects.properties.entity.EntityAngry;
import net.aufdemrand.denizen.objects.properties.entity.EntityChestCarrier;
import net.aufdemrand.denizen.objects.properties.entity.EntityColor;
import net.aufdemrand.denizen.objects.properties.entity.EntityCritical;
import net.aufdemrand.denizen.objects.properties.entity.EntityElder;
import net.aufdemrand.denizen.objects.properties.entity.EntityEquipment;
import net.aufdemrand.denizen.objects.properties.entity.EntityFirework;
import net.aufdemrand.denizen.objects.properties.entity.EntityFramed;
import net.aufdemrand.denizen.objects.properties.entity.EntityHealth;
import net.aufdemrand.denizen.objects.properties.entity.EntityInfected;
import net.aufdemrand.denizen.objects.properties.entity.EntityInventory;
import net.aufdemrand.denizen.objects.properties.entity.EntityItem;
import net.aufdemrand.denizen.objects.properties.entity.EntityJumpStrength;
import net.aufdemrand.denizen.objects.properties.entity.EntityKnockback;
import net.aufdemrand.denizen.objects.properties.entity.EntityPainting;
import net.aufdemrand.denizen.objects.properties.entity.EntityPotion;
import net.aufdemrand.denizen.objects.properties.entity.EntityPowered;
import net.aufdemrand.denizen.objects.properties.entity.EntityProfession;
import net.aufdemrand.denizen.objects.properties.entity.EntityRotation;
import net.aufdemrand.denizen.objects.properties.entity.EntitySitting;
import net.aufdemrand.denizen.objects.properties.entity.EntitySize;
import net.aufdemrand.denizen.objects.properties.entity.EntitySkeleton;
import net.aufdemrand.denizen.objects.properties.entity.EntitySpeed;
import net.aufdemrand.denizen.objects.properties.entity.EntityTame;
import net.aufdemrand.denizen.objects.properties.inventory.InventoryContents;
import net.aufdemrand.denizen.objects.properties.inventory.InventoryHolder;
import net.aufdemrand.denizen.objects.properties.inventory.InventorySize;
import net.aufdemrand.denizen.objects.properties.inventory.InventoryTitle;
import net.aufdemrand.denizen.objects.properties.item.ItemApple;
import net.aufdemrand.denizen.objects.properties.item.ItemBaseColor;
import net.aufdemrand.denizen.objects.properties.item.ItemBook;
import net.aufdemrand.denizen.objects.properties.item.ItemDisplayname;
import net.aufdemrand.denizen.objects.properties.item.ItemDurability;
import net.aufdemrand.denizen.objects.properties.item.ItemDye;
import net.aufdemrand.denizen.objects.properties.item.ItemEnchantments;
import net.aufdemrand.denizen.objects.properties.item.ItemFirework;
import net.aufdemrand.denizen.objects.properties.item.ItemFlags;
import net.aufdemrand.denizen.objects.properties.item.ItemLore;
import net.aufdemrand.denizen.objects.properties.item.ItemMap;
import net.aufdemrand.denizen.objects.properties.item.ItemPatterns;
import net.aufdemrand.denizen.objects.properties.item.ItemPlantgrowth;
import net.aufdemrand.denizen.objects.properties.item.ItemPotion;
import net.aufdemrand.denizen.objects.properties.item.ItemQuantity;
import net.aufdemrand.denizen.objects.properties.item.ItemSkullskin;
import net.aufdemrand.denizen.objects.properties.item.ItemSpawnEgg;
import net.aufdemrand.denizen.scripts.commands.BukkitCommandRegistry;
import net.aufdemrand.denizen.scripts.containers.core.AssignmentScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BookScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.BukkitWorldScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.CommandScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.CommandScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.EntityScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.FormatScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InteractScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.InventoryScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.ItemScriptHelper;
import net.aufdemrand.denizen.scripts.containers.core.MapScriptContainer;
import net.aufdemrand.denizen.scripts.containers.core.VersionScriptContainer;
import net.aufdemrand.denizen.scripts.requirements.RequirementChecker;
import net.aufdemrand.denizen.scripts.requirements.RequirementRegistry;
import net.aufdemrand.denizen.scripts.triggers.TriggerRegistry;
import net.aufdemrand.denizen.tags.BukkitTagContext;
import net.aufdemrand.denizen.tags.core.AnchorTags;
import net.aufdemrand.denizen.tags.core.ConstantTags;
import net.aufdemrand.denizen.tags.core.CuboidTags;
import net.aufdemrand.denizen.tags.core.EntityTags;
import net.aufdemrand.denizen.tags.core.FlagTags;
import net.aufdemrand.denizen.tags.core.LocationTags;
import net.aufdemrand.denizen.tags.core.NPCTags;
import net.aufdemrand.denizen.tags.core.NotableLocationTags;
import net.aufdemrand.denizen.tags.core.ParseTags;
import net.aufdemrand.denizen.tags.core.PlayerTags;
import net.aufdemrand.denizen.tags.core.ServerTags;
import net.aufdemrand.denizen.tags.core.TextTags;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.MetricsLite;
import net.aufdemrand.denizen.utilities.RuntimeCompiler;
import net.aufdemrand.denizen.utilities.ScoreboardHelper;
import net.aufdemrand.denizen.utilities.Utilities;
import net.aufdemrand.denizen.utilities.command.CommandManager;
import net.aufdemrand.denizen.utilities.command.Injector;
import net.aufdemrand.denizen.utilities.command.messaging.Messaging;
import net.aufdemrand.denizen.utilities.debugging.LogInterceptor;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizen.utilities.depends.Depends;
import net.aufdemrand.denizen.utilities.entity.CraftFakeArrow;
import net.aufdemrand.denizen.utilities.entity.CraftFakePlayer;
import net.aufdemrand.denizen.utilities.entity.CraftItemProjectile;
import net.aufdemrand.denizen.utilities.entity.DenizenEntityType;
import net.aufdemrand.denizen.utilities.maps.DenizenMapManager;
import net.aufdemrand.denizen.utilities.packets.intercept.DenizenPacketListener;
import net.aufdemrand.denizencore.DenizenCore;
import net.aufdemrand.denizencore.DenizenImplementation;
import net.aufdemrand.denizencore.events.OldEventManager;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.interfaces.dExternal;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.ObjectFetcher;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.ScriptHelper;
import net.aufdemrand.denizencore.scripts.ScriptRegistry;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.tags.TagContext;
import net.aufdemrand.denizencore.tags.TagManager;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import net.minecraft.server.v1_8_R3.Block;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.spigotmc.AsyncCatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Denizen
extends JavaPlugin
implements DenizenImplementation {
    public static final int configVersion = 11;
    public static String versionTag = null;
    private boolean startedSuccessful = false;
    public static final LogInterceptor logInterceptor = new LogInterceptor();
    private CommandManager commandManager;
    private BukkitCommandRegistry commandRegistry = new BukkitCommandRegistry();
    private TriggerRegistry triggerRegistry = new TriggerRegistry();
    private RequirementRegistry requirementRegistry = new RequirementRegistry(this);
    private ListenerRegistry listenerRegistry = new ListenerRegistry();
    private dNPCRegistry dNPCRegistry;
    private PropertyParser propertyParser;
    private FlagManager flagManager = new FlagManager(this);
    private TagManager tagManager = new TagManager();
    private NotableManager notableManager = new NotableManager();
    private OldEventManager eventManager;
    public Depends depends = new Depends();
    public RuntimeCompiler runtimeCompiler;
    private BukkitWorldScriptHelper ws_helper;
    public static final long startTime = System.currentTimeMillis();
    private RequirementChecker requirementChecker;
    private FileConfiguration savesConfig = null;
    private File savesConfigFile = null;
    private FileConfiguration scoreboardsConfig = null;
    private File scoreboardsConfigFile = null;
    private FileConfiguration entityConfig = null;
    private File entityConfigFile = null;
    int tT = Integer.MAX_VALUE;

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public BukkitCommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    public dNPCRegistry getNPCRegistry() {
        return this.dNPCRegistry;
    }

    public ListenerRegistry getListenerRegistry() {
        return this.listenerRegistry;
    }

    public RequirementRegistry getRequirementRegistry() {
        return this.requirementRegistry;
    }

    public TriggerRegistry getTriggerRegistry() {
        return this.triggerRegistry;
    }

    public PropertyParser getPropertyParser() {
        return this.propertyParser;
    }

    public OldEventManager eventManager() {
        return this.eventManager;
    }

    public FlagManager flagManager() {
        return this.flagManager;
    }

    public TagManager tagManager() {
        return this.tagManager;
    }

    public NotableManager notableManager() {
        return this.notableManager;
    }

    public RequirementChecker getRequirementChecker() {
        return this.requirementChecker;
    }

    public void onEnable() {
        try {
            Block.getById((int)0);
        }
        catch (NoClassDefFoundError e) {
            this.getLogger().warning("-------------------------------------");
            this.getLogger().warning("This Denizen version is not compatible with this CraftBukkit version! Deactivating Denizen!");
            this.getLogger().warning("-------------------------------------");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            this.startedSuccessful = false;
            return;
        }
        try {
            AsyncCatcher.enabled = false;
        }
        catch (Exception e) {
            dB.echoError("Running not-Spigot?!");
        }
        try {
            versionTag = this.getDescription().getVersion();
            DenizenCore.init(this);
            this.depends.initialize();
            if (Depends.citizens == null || !Depends.citizens.isEnabled()) {
                this.getLogger().warning("Citizens does not seem to be activated! Denizen will have greatly reduced functionality!");
            }
            this.startedSuccessful = true;
            this.requirementChecker = new RequirementChecker();
            dB.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
            dB.log(ChatColor.YELLOW + " _/_ _  ._  _ _  ");
            dB.log(ChatColor.YELLOW + "(/(-/ )/ /_(-/ ) " + ChatColor.GRAY + " scriptable minecraft");
            dB.log("");
            dB.log(ChatColor.GRAY + "by: " + ChatColor.WHITE + "aufdemrand");
            dB.log(ChatColor.GRAY + "version: " + ChatColor.WHITE + versionTag);
            dB.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            MetricsLite metrics = new MetricsLite((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            this.dNPCRegistry = new dNPCRegistry(this);
            this.commandManager = new CommandManager();
            this.commandManager.setInjector(new Injector(this));
            this.commandManager.register(DenizenCommandHandler.class);
            if (Depends.citizens != null) {
                Depends.citizens.registerCommandClass(NPCCommandHandler.class);
            }
            DenizenEntityType.registerEntityType("ITEM_PROJECTILE", CraftItemProjectile.class);
            DenizenEntityType.registerEntityType("FAKE_ARROW", CraftFakeArrow.class);
            DenizenEntityType.registerEntityType("FAKE_PLAYER", CraftFakePlayer.class);
            for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                dPlayer.notePlayer(player);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            DenizenCore.setCommandRegistry(this.getCommandRegistry());
            this.getCommandRegistry().registerCoreMembers();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            ScriptRegistry._registerCoreTypes();
            this.saveDefaultConfig();
            this.reloadConfig();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            ScriptRegistry._registerType("interact", InteractScriptContainer.class);
            ScriptRegistry._registerType("book", BookScriptContainer.class);
            ScriptRegistry._registerType("item", ItemScriptContainer.class);
            ScriptRegistry._registerType("entity", EntityScriptContainer.class);
            ScriptRegistry._registerType("assignment", AssignmentScriptContainer.class);
            ScriptRegistry._registerType("format", FormatScriptContainer.class);
            ScriptRegistry._registerType("inventory", InventoryScriptContainer.class);
            ScriptRegistry._registerType("command", CommandScriptContainer.class);
            ScriptRegistry._registerType("map", MapScriptContainer.class);
            ScriptRegistry._registerType("version", VersionScriptContainer.class);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            new File(this.getDataFolder() + "/scripts").mkdirs();
            new File(this.getDataFolder() + "/midi").mkdirs();
            new File(this.getDataFolder() + "/schematics").mkdirs();
            if (!new File(this.getDataFolder() + "/midi/Denizen.mid").exists()) {
                String sourceFile = URLDecoder.decode(Denizen.class.getProtectionDomain().getCodeSource().getLocation().getFile());
                dB.log("Denizen.mid not found, extracting from " + sourceFile);
                Utilities.extractFile(new File(sourceFile), "Denizen.mid", this.getDataFolder() + "/midi/");
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            if (!this.getConfig().isSet("Config.Version") || this.getConfig().getInt("Config.Version", 0) < 11) {
                dB.echoError("Your Denizen config file is from an older version. Some settings will not be available unless you generate a new one. This is easily done by stopping the server, deleting the current config.yml file in the Denizen folder and restarting the server.");
            }
            this.ws_helper = new BukkitWorldScriptHelper();
            ItemScriptHelper is_helper = new ItemScriptHelper();
            InventoryScriptHelper in_helper = new InventoryScriptHelper();
            EntityScriptHelper es_helper = new EntityScriptHelper();
            CommandScriptHelper cs_helper = new CommandScriptHelper();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(TriggerTrait.class).withName("triggers"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(PushableTrait.class).withName("pushable"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(AssignmentTrait.class).withName("assignment"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(NicknameTrait.class).withName("nickname"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HealthTrait.class).withName("health"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ConstantsTrait.class).withName("constants"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(HungerTrait.class).withName("hunger"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SittingTrait.class).withName("sitting"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(FishingTrait.class).withName("fishing"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SleepingTrait.class).withName("sleeping"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ParticlesTrait.class).withName("particles"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SneakingTrait.class).withName("sneaking"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(InvisibleTrait.class).withName("invisible"));
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(MobproxTrait.class).withName("mobprox"));
                CitizensAPI.getSpeechFactory().register(DenizenChat.class, "denizen_chat");
            }
            if (Depends.hasProgramAB) {
                CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ChatbotTrait.class).withName("chatbot"));
            }
            this.runtimeCompiler = new RuntimeCompiler(this);
            this.runtimeCompiler.loader();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            if (Depends.citizens != null) {
                this.getTriggerRegistry().registerCoreMembers();
            }
            this.getRequirementRegistry().registerCoreMembers();
            this.getListenerRegistry().registerCoreMembers();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            this.tagManager().registerCoreTags();
            new CuboidTags(this);
            new EntityTags(this);
            new LocationTags(this);
            new PlayerTags(this);
            new ServerTags(this);
            new TextTags(this);
            new ParseTags(this);
            if (Depends.citizens != null) {
                new NPCTags(this);
                new AnchorTags(this);
                new ConstantTags(this);
            }
            new FlagTags(this);
            new NotableLocationTags(this);
            this.eventManager = new OldEventManager();
            OldEventManager.registerSmartEvent(new CommandSmartEvent());
            OldEventManager.registerSmartEvent(new CuboidEnterExitSmartEvent());
            OldEventManager.registerSmartEvent(new FlagSmartEvent());
            OldEventManager.registerSmartEvent(new NPCNavigationSmartEvent());
            OldEventManager.registerSmartEvent(new PlayerEquipsArmorSmartEvent());
            this.eventManager().registerCoreMembers();
            ScriptEvent.registerScriptEvent(new BiomeEnterExitScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockBuiltScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockBurnsScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockDispensesScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockFadesScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockFallsScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockFormsScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockGrowsScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockSpreadsScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockIgnitesScriptEvent());
            ScriptEvent.registerScriptEvent(new BlockPhysicsScriptEvent());
            ScriptEvent.registerScriptEvent(new BrewsScriptEvent());
            ScriptEvent.registerScriptEvent(new BucketEmptyScriptEvent());
            ScriptEvent.registerScriptEvent(new BucketFillScriptEvent());
            ScriptEvent.registerScriptEvent(new ChatScriptEvent());
            ScriptEvent.registerScriptEvent(new ChunkLoadScriptEvent());
            ScriptEvent.registerScriptEvent(new ChunkUnloadScriptEvent());
            ScriptEvent.registerScriptEvent(new CreeperPoweredScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityBreaksHangingScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityChangesBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityCreatePortalScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityCombustsScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityDamagedScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityDeathScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityDespawnScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityEntersPortalScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityExitsPortalScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityExplodesScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityExplosionPrimesScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityFoodLevelChangeScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityFormsBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityHealsScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityInteractScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityKilledScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityShootsBowEvent());
            ScriptEvent.registerScriptEvent(new EntitySpawnScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityTamesScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityTargetsScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityTeleportScriptEvent());
            ScriptEvent.registerScriptEvent(new EntityUnleashedScriptEvent());
            ScriptEvent.registerScriptEvent(new FurnaceBurnsItemScriptEvent());
            ScriptEvent.registerScriptEvent(new FurnaceSmeltsItemScriptEvent());
            ScriptEvent.registerScriptEvent(new HangingBreaksScriptEvent());
            ScriptEvent.registerScriptEvent(new HorseJumpsScriptEvent());
            ScriptEvent.registerScriptEvent(new InvPicksUpItemScriptEvent());
            ScriptEvent.registerScriptEvent(new ItemDespawnsScriptEvent());
            ScriptEvent.registerScriptEvent(new ItemEnchantedScriptEvent());
            ScriptEvent.registerScriptEvent(new ItemMoveScriptEvent());
            ScriptEvent.registerScriptEvent(new ItemScrollScriptEvent());
            ScriptEvent.registerScriptEvent(new ItemSpawnsScriptEvent());
            ScriptEvent.registerScriptEvent(new LeafDecaysScriptEvent());
            ScriptEvent.registerScriptEvent(new LightningStrikesScriptEvent());
            ScriptEvent.registerScriptEvent(new LiquidSpreadScriptEvent());
            ScriptEvent.registerScriptEvent(new ListPingScriptEvent());
            ScriptEvent.registerScriptEvent(new PigZappedScriptEvent());
            ScriptEvent.registerScriptEvent(new PistonExtendsScriptEvent());
            ScriptEvent.registerScriptEvent(new PistonRetractsScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerAnimatesScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerBreaksBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerChangesSignScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerChangesWorldScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerClosesInvScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerConsumesScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerDamagesBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerDropsItemScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerEntersBedScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerJumpScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerLeavesBedScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerOpensInvScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerPlacesBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerPlacesHangingScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerStepsOnScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerTakesFromFurnaceScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerUsesPortalScriptEvent());
            ScriptEvent.registerScriptEvent(new PlayerWalkScriptEvent());
            ScriptEvent.registerScriptEvent(new PortalCreateScriptEvent());
            ScriptEvent.registerScriptEvent(new ProjectileLaunchedScriptEvent());
            ScriptEvent.registerScriptEvent(new PotionSplashScriptEvent());
            ScriptEvent.registerScriptEvent(new RedstoneScriptEvent());
            ScriptEvent.registerScriptEvent(new ResourcePackStatusScriptEvent());
            ScriptEvent.registerScriptEvent(new SheepDyedScriptEvent());
            ScriptEvent.registerScriptEvent(new SheepRegrowsScriptEvent());
            ScriptEvent.registerScriptEvent(new SpawnChangeScriptEvent());
            ScriptEvent.registerScriptEvent(new StructureGrowsScriptEvent());
            ScriptEvent.registerScriptEvent(new SlimeSplitsScriptEvent());
            ScriptEvent.registerScriptEvent(new VehicleCollidesBlockScriptEvent());
            ScriptEvent.registerScriptEvent(new VehicleCollidesEntityScriptEvent());
            ScriptEvent.registerScriptEvent(new VehicleMoveScriptEvent());
            ScriptEvent.registerScriptEvent(new WeatherChangesScriptEvent());
            ScriptEvent.registerScriptEvent(new WorldInitsScriptEvent());
            ScriptEvent.registerScriptEvent(new WorldLoadsScriptEvent());
            ScriptEvent.registerScriptEvent(new WorldSavesScriptEvent());
            ScriptEvent.registerScriptEvent(new WorldUnloadsScriptEvent());
            ObjectFetcher.registerWithObjectFetcher(dItem.class);
            ObjectFetcher.registerWithObjectFetcher(dCuboid.class);
            ObjectFetcher.registerWithObjectFetcher(dEntity.class);
            ObjectFetcher.registerWithObjectFetcher(dInventory.class);
            ObjectFetcher.registerWithObjectFetcher(dColor.class);
            ObjectFetcher.registerWithObjectFetcher(dLocation.class);
            ObjectFetcher.registerWithObjectFetcher(dMaterial.class);
            if (Depends.citizens != null) {
                ObjectFetcher.registerWithObjectFetcher(dNPC.class);
            }
            ObjectFetcher.registerWithObjectFetcher(dPlayer.class);
            ObjectFetcher.registerWithObjectFetcher(dWorld.class);
            ObjectFetcher.registerWithObjectFetcher(dChunk.class);
            ObjectFetcher.registerWithObjectFetcher(dPlugin.class);
            ObjectFetcher.registerWithObjectFetcher(dEllipsoid.class);
            ObjectFetcher.registerWithObjectFetcher(dBiome.class);
            ObjectFetcher._registerCoreObjects();
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            dMaterial._initialize();
            this.propertyParser = new PropertyParser();
            this.propertyParser.registerProperty(BukkitScriptProperties.class, dScript.class);
            this.propertyParser.registerProperty(BukkitQueueProperties.class, ScriptQueue.class);
            this.propertyParser.registerProperty(BukkitElementProperties.class, Element.class);
            this.propertyParser.registerProperty(BukkitListProperties.class, dList.class);
            this.propertyParser.registerProperty(EntityAge.class, dEntity.class);
            this.propertyParser.registerProperty(EntityAI.class, dEntity.class);
            this.propertyParser.registerProperty(EntityAngry.class, dEntity.class);
            this.propertyParser.registerProperty(EntityChestCarrier.class, dEntity.class);
            this.propertyParser.registerProperty(EntityColor.class, dEntity.class);
            this.propertyParser.registerProperty(EntityCritical.class, dEntity.class);
            this.propertyParser.registerProperty(EntityElder.class, dEntity.class);
            this.propertyParser.registerProperty(EntityEquipment.class, dEntity.class);
            this.propertyParser.registerProperty(EntityFirework.class, dEntity.class);
            this.propertyParser.registerProperty(EntityFramed.class, dEntity.class);
            this.propertyParser.registerProperty(EntityHealth.class, dEntity.class);
            this.propertyParser.registerProperty(EntityInfected.class, dEntity.class);
            this.propertyParser.registerProperty(EntityInventory.class, dEntity.class);
            this.propertyParser.registerProperty(EntityItem.class, dEntity.class);
            this.propertyParser.registerProperty(EntityJumpStrength.class, dEntity.class);
            this.propertyParser.registerProperty(EntityKnockback.class, dEntity.class);
            this.propertyParser.registerProperty(EntityPainting.class, dEntity.class);
            this.propertyParser.registerProperty(EntityPotion.class, dEntity.class);
            this.propertyParser.registerProperty(EntityPowered.class, dEntity.class);
            this.propertyParser.registerProperty(EntityProfession.class, dEntity.class);
            this.propertyParser.registerProperty(EntityRotation.class, dEntity.class);
            this.propertyParser.registerProperty(EntitySitting.class, dEntity.class);
            this.propertyParser.registerProperty(EntitySize.class, dEntity.class);
            this.propertyParser.registerProperty(EntitySkeleton.class, dEntity.class);
            this.propertyParser.registerProperty(EntitySpeed.class, dEntity.class);
            this.propertyParser.registerProperty(EntityTame.class, dEntity.class);
            this.propertyParser.registerProperty(InventoryHolder.class, dInventory.class);
            this.propertyParser.registerProperty(InventorySize.class, dInventory.class);
            this.propertyParser.registerProperty(InventoryContents.class, dInventory.class);
            this.propertyParser.registerProperty(InventoryTitle.class, dInventory.class);
            this.propertyParser.registerProperty(ItemApple.class, dItem.class);
            this.propertyParser.registerProperty(ItemBaseColor.class, dItem.class);
            this.propertyParser.registerProperty(ItemBook.class, dItem.class);
            this.propertyParser.registerProperty(ItemDisplayname.class, dItem.class);
            this.propertyParser.registerProperty(ItemDurability.class, dItem.class);
            this.propertyParser.registerProperty(ItemDye.class, dItem.class);
            this.propertyParser.registerProperty(ItemEnchantments.class, dItem.class);
            this.propertyParser.registerProperty(ItemFirework.class, dItem.class);
            this.propertyParser.registerProperty(ItemFlags.class, dItem.class);
            this.propertyParser.registerProperty(ItemLore.class, dItem.class);
            this.propertyParser.registerProperty(ItemMap.class, dItem.class);
            this.propertyParser.registerProperty(ItemPatterns.class, dItem.class);
            this.propertyParser.registerProperty(ItemPlantgrowth.class, dItem.class);
            this.propertyParser.registerProperty(ItemPotion.class, dItem.class);
            this.propertyParser.registerProperty(ItemQuantity.class, dItem.class);
            this.propertyParser.registerProperty(ItemSkullskin.class, dItem.class);
            this.propertyParser.registerProperty(ItemSpawnEgg.class, dItem.class);
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        try {
            for (World world : this.getServer().getWorlds()) {
                EntityScriptHelper.linkWorld(world);
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
        DenizenPacketListener.enable();
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            public void run() {
                try {
                    DenizenCore.loadScripts();
                    Denizen.this.notableManager.reloadNotables();
                    Denizen.this.reloadSaves();
                    dB.log(ChatColor.LIGHT_PURPLE + "+-------------------------+");
                    Denizen.this.ws_helper.serverStartEvent();
                }
                catch (Exception e) {
                    dB.echoError(e);
                }
            }
        }, 1L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

            public void run() {
                DenizenCore.tick(50);
            }
        }, 1L, 1L);
    }

    public void onDisable() {
        if (!this.startedSuccessful) {
            return;
        }
        HashMap<String, dObject> context = new HashMap<String, dObject>();
        OldEventManager.doEvents(Arrays.asList("shutdown"), new BukkitScriptEntryData(null, null), context);
        logInterceptor.standardOutput();
        this.notableManager.saveNotables();
        ScoreboardHelper._saveScoreboards();
        EntityScriptHelper.saveEntities();
        InventoryScriptHelper._savePlayerInventories();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.getListenerRegistry().deconstructPlayer(dPlayer.mirrorBukkitPlayer((OfflinePlayer)player));
        }
        for (OfflinePlayer player : this.getServer().getOfflinePlayers()) {
            try {
                this.getListenerRegistry().deconstructPlayer(dPlayer.mirrorBukkitPlayer(player));
            }
            catch (Exception e) {
                if (player == null) {
                    dB.echoError("Tell the Denizen team ASAP about this error! ERR: OPN: " + e.toString());
                    continue;
                }
                dB.echoError("'" + player.getName() + "' is having trouble deconstructing! " + "You might have a corrupt player file!");
            }
        }
        for (dExternal external : RuntimeCompiler.loadedExternals) {
            external.unload();
        }
        RuntimeCompiler.loadedExternals.clear();
        this.getCommandRegistry().disableCoreMembers();
        this.getLogger().log(Level.INFO, " v" + this.getDescription().getVersion() + " disabled.");
        Bukkit.getServer().getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        for (World world : this.getServer().getWorlds()) {
            EntityScriptHelper.unlinkWorld(world);
        }
        this.saveSaves();
    }

    public void reloadSaves() {
        if (this.savesConfigFile == null) {
            this.savesConfigFile = new File(this.getDataFolder(), "saves.yml");
        }
        this.savesConfig = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.savesConfigFile);
        dLocation._recallLocations();
        this.updateSaves();
        if (this.scoreboardsConfigFile == null) {
            this.scoreboardsConfigFile = new File(this.getDataFolder(), "scoreboards.yml");
        }
        this.scoreboardsConfig = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.scoreboardsConfigFile);
        ScoreboardHelper._recallScoreboards();
        if (this.entityConfigFile == null) {
            this.entityConfigFile = new File(this.getDataFolder(), "entities.yml");
        }
        this.entityConfig = org.bukkit.configuration.file.YamlConfiguration.loadConfiguration((File)this.entityConfigFile);
        EntityScriptHelper.reloadEntities();
        DenizenMapManager.reloadMaps();
        Bukkit.getServer().getPluginManager().callEvent((Event)new SavesReloadEvent());
    }

    public void updateSaves() {
        int saves_version = 1;
        if (this.savesConfig.contains("a_saves.version")) {
            saves_version = this.savesConfig.getInt("a_saves.version");
        }
        if (saves_version == 1) {
            dB.log("Updating saves from v1 to v2...");
            ConfigurationSection section = this.savesConfig.getConfigurationSection("Players");
            if (section != null) {
                String key;
                int i;
                ArrayList keyList = new ArrayList(section.getKeys(false));
                for (i = 0; i < keyList.size(); ++i) {
                    key = (String)keyList.get(i);
                    if (key.equals(key.toUpperCase()) || !keyList.contains(key.toUpperCase())) continue;
                    keyList.remove(key.toUpperCase());
                }
                for (i = 0; i < keyList.size(); ++i) {
                    key = (String)keyList.get(i);
                    try {
                        dPlayer player;
                        ConfigurationSection playerSection = this.savesConfig.getConfigurationSection("Players." + key);
                        if (playerSection == null) {
                            dB.echoError("Can't update saves for player '" + key + "' - broken YAML section!");
                            continue;
                        }
                        Map keys = playerSection.getValues(true);
                        if (!key.equals(key.toUpperCase()) && this.savesConfig.contains("Players." + key.toUpperCase())) {
                            keys.putAll(this.savesConfig.getConfigurationSection("Players." + key.toUpperCase()).getValues(true));
                            this.savesConfig.set("Players." + key.toUpperCase(), null);
                        }
                        if ((player = dPlayer.valueOf(key)) == null) {
                            dB.echoError("Can't update saves for player '" + key + "' - invalid name!");
                            this.savesConfig.createSection("PlayersBACKUP." + key, keys);
                        } else {
                            this.savesConfig.createSection("Players." + player.getSaveName(), keys);
                        }
                        this.savesConfig.set("Players." + key, null);
                        continue;
                    }
                    catch (Exception ex) {
                        dB.echoError(ex);
                    }
                }
            }
            if ((section = this.savesConfig.getConfigurationSection("Listeners")) != null) {
                for (String key : section.getKeys(false)) {
                    try {
                        dPlayer player = dPlayer.valueOf(key);
                        if (player == null) {
                            dB.log("Warning: can't update listeners for player '" + key + "' - invalid name!");
                        } else {
                            this.savesConfig.createSection("Listeners." + player.getSaveName(), this.savesConfig.getConfigurationSection("Listeners." + key).getValues(true));
                        }
                        this.savesConfig.set("Listeners." + key, null);
                    }
                    catch (Exception ex) {
                        dB.echoError(ex);
                    }
                }
            }
            this.savesConfig.set("a_saves.version", (Object)"2");
            dB.log("Done!");
        }
    }

    public FileConfiguration getSaves() {
        if (this.savesConfig == null) {
            this.reloadSaves();
        }
        return this.savesConfig;
    }

    public FileConfiguration getScoreboards() {
        if (this.scoreboardsConfig == null) {
            this.reloadSaves();
        }
        return this.scoreboardsConfig;
    }

    public FileConfiguration getEntities() {
        if (this.entityConfig == null) {
            this.reloadSaves();
        }
        return this.entityConfig;
    }

    public void saveSaves() {
        if (this.savesConfig == null || this.savesConfigFile == null) {
            return;
        }
        this.notableManager.saveNotables();
        ScoreboardHelper._saveScoreboards();
        EntityScriptHelper.saveEntities();
        DenizenMapManager.saveMaps();
        try {
            this.savesConfig.save(this.savesConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.savesConfigFile, ex);
        }
        try {
            this.scoreboardsConfig.save(this.scoreboardsConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.scoreboardsConfigFile, ex);
        }
        try {
            this.entityConfig.save(this.entityConfigFile);
        }
        catch (IOException ex) {
            Logger.getLogger(JavaPlugin.class.getName()).log(Level.SEVERE, "Could not save to " + this.entityConfigFile, ex);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        String modifier;
        if (cmdName.equalsIgnoreCase("ex")) {
            ArrayList<Object> entries = new ArrayList<Object>();
            String entry = "";
            for (String arg : args) {
                entry = entry + arg + " ";
            }
            if (entry.length() < 2) {
                sender.sendMessage("/ex <dCommand> (arguments)");
                return true;
            }
            if (Settings.showExHelp()) {
                if (dB.showDebug) {
                    sender.sendMessage(ChatColor.YELLOW + "Executing dCommand... check the console for debug output!");
                } else {
                    sender.sendMessage(ChatColor.YELLOW + "Executing dCommand... to see debug, use /denizen debug");
                }
            }
            entries.add(entry);
            InstantQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId("EXCOMMAND"));
            dNPC npc = null;
            if (Depends.citizens != null && Depends.citizens.getNPCSelector().getSelected(sender) != null) {
                npc = new dNPC(Depends.citizens.getNPCSelector().getSelected(sender));
            }
            List<ScriptEntry> scriptEntries = ScriptBuilder.buildScriptEntries(entries, null, new BukkitScriptEntryData(sender instanceof Player ? new dPlayer((Player)sender) : null, npc));
            queue.addEntries(scriptEntries);
            queue.start();
            return true;
        }
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!this.commandManager.hasCommand(cmd, modifier) && !modifier.isEmpty()) {
            return this.suggestClosestModifier(sender, cmd.getName(), modifier);
        }
        Object[] methodArgs = new Object[]{sender};
        return this.commandManager.executeSafe(cmd, args, sender, methodArgs);
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        String closest = this.commandManager.getClosestCommandModifier(command, modifier);
        if (!closest.isEmpty()) {
            Messaging.send(sender, "<7>Unknown command. Did you mean:");
            Messaging.send(sender, " /" + command + " " + closest);
            return true;
        }
        return false;
    }

    @Override
    public File getScriptFolder() {
        File file = null;
        file = Settings.useDefaultScriptPath() ? new File(DenizenAPI.getCurrentInstance().getDataFolder() + File.separator + "scripts") : new File(Settings.getAlternateScriptPath().replace("/", File.separator));
        return file;
    }

    @Override
    public String getImplementationVersion() {
        return versionTag;
    }

    @Override
    public void debugMessage(String message) {
        dB.log(message);
    }

    @Override
    public void debugException(Throwable ex) {
        dB.echoError(ex);
    }

    @Override
    public void debugError(String error) {
        dB.echoError(error);
    }

    @Override
    public void debugError(ScriptQueue scriptQueue, String s) {
        dB.echoError(scriptQueue, s);
    }

    @Override
    public void debugError(ScriptQueue scriptQueue, Throwable throwable) {
        dB.echoError(scriptQueue, throwable);
    }

    @Override
    public void debugReport(Debuggable debuggable, String s, String s1) {
        dB.report(debuggable, s, s1);
    }

    @Override
    public void debugApproval(String message) {
        dB.echoApproval(message);
    }

    @Override
    public void debugEntry(Debuggable debuggable, String s) {
        dB.echoDebug(debuggable, s);
    }

    @Override
    public void debugEntry(Debuggable debuggable, dB.DebugElement debugElement, String s) {
        dB.echoDebug(debuggable, debugElement, s);
    }

    @Override
    public void debugEntry(Debuggable debuggable, dB.DebugElement debugElement) {
        dB.echoDebug(debuggable, debugElement);
    }

    @Override
    public String getImplementationName() {
        return "Bukkit";
    }

    @Override
    public void preScriptReload() {
        ItemScriptHelper.removeDenizenRecipes();
        CommandScriptHelper.removeDenizenCommands();
    }

    @Override
    public void onScriptReload() {
        Bukkit.getServer().getPluginManager().callEvent((Event)new ScriptReloadEvent());
    }

    @Override
    public void buildCoreContainers(YamlConfiguration config) {
        ScriptRegistry._buildCoreYamlScriptContainers(config);
    }

    @Override
    public List<YamlConfiguration> getOutsideScripts() {
        ArrayList<YamlConfiguration> files = new ArrayList<YamlConfiguration>();
        try {
            files.add(ScriptHelper.loadConfig("Denizen.jar/util.dscript", this.getResource("util.dscript")));
        }
        catch (IOException e) {
            dB.echoError(e);
        }
        return files;
    }

    @Override
    public void handleCommandSpecialCases(ScriptEntry scriptEntry) {
        if (((BukkitScriptEntryData)scriptEntry.entryData).hasNPC() && ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getCitizen() == null) {
            ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(null);
        }
    }

    @Override
    public void debugCommandHeader(ScriptEntry scriptEntry) {
        if (scriptEntry.getOriginalArguments() == null || scriptEntry.getOriginalArguments().size() == 0 || !scriptEntry.getOriginalArguments().get(0).equals("\u0000CALLBACK")) {
            if (((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() != null) {
                dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + "/p@" + ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().getName());
            } else {
                dB.echoDebug(scriptEntry, dB.DebugElement.Header, "Executing dCommand: " + scriptEntry.getCommandName() + (((BukkitScriptEntryData)scriptEntry.entryData).getNPC() != null ? "/n@" + ((BukkitScriptEntryData)scriptEntry.entryData).getNPC().getName() : ""));
            }
        }
    }

    @Override
    public TagContext getTagContextFor(ScriptEntry scriptEntry, boolean b) {
        dPlayer player = scriptEntry != null ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer() : null;
        dNPC npc = scriptEntry != null ? ((BukkitScriptEntryData)scriptEntry.entryData).getNPC() : null;
        return new BukkitTagContext(player, npc, b, scriptEntry, scriptEntry != null ? scriptEntry.shouldDebug() : true, scriptEntry != null ? scriptEntry.getScript() : null);
    }

    @Override
    public boolean handleCustomArgs(ScriptEntry scriptEntry, aH.Argument arg, boolean if_ignore) {
        if (arg.matchesPrefix("player") && !if_ignore) {
            dB.echoDebug((Debuggable)scriptEntry, "...replacing the linked player with " + arg.getValue());
            String value = TagManager.tag(arg.getValue(), new BukkitTagContext(scriptEntry, false));
            dPlayer player = dPlayer.valueOf(value);
            if (player == null || !player.isValid()) {
                dB.echoError(scriptEntry.getResidingQueue(), value + " is an invalid player!");
            }
            ((BukkitScriptEntryData)scriptEntry.entryData).setPlayer(player);
            return true;
        }
        if (arg.matchesPrefix("npc, npcid") && !if_ignore) {
            dB.echoDebug((Debuggable)scriptEntry, "...replacing the linked NPC with " + arg.getValue());
            String value = TagManager.tag(arg.getValue(), new BukkitTagContext(scriptEntry, false));
            dNPC npc = dNPC.valueOf(value);
            if (npc == null || !npc.isValid()) {
                dB.echoError(scriptEntry.getResidingQueue(), value + " is an invalid NPC!");
                return false;
            }
            ((BukkitScriptEntryData)scriptEntry.entryData).setNPC(npc);
            return true;
        }
        return false;
    }

    @Override
    public void refreshScriptContainers() {
        VersionScriptContainer.scripts.clear();
        ItemScriptHelper.item_scripts.clear();
        ItemScriptHelper.item_scripts_by_hash_id.clear();
        InventoryScriptHelper.inventory_scripts.clear();
        this.tT = Integer.MAX_VALUE;
    }

    @Override
    public String scriptQueueSpeed() {
        return Settings.scriptQueueSpeed();
    }

    @Override
    public dList valueOfFlagdList(String string) {
        FlagManager.Flag flag = this.getFlag(string);
        if (flag == null) {
            return null;
        }
        return new dList(flag.toString(), true, flag.values());
    }

    public FlagManager.Flag getFlag(String string) {
        if (string.startsWith("fl")) {
            FlagManager flag_manager = DenizenAPI.getCurrentInstance().flagManager();
            if (string.indexOf(91) == 2) {
                int cb = string.indexOf(93);
                if (cb > 4) {
                    String owner = string.substring(3, cb);
                    String flag = string.substring(cb + 2);
                    if (dPlayer.matches(owner)) {
                        dPlayer player = dPlayer.valueOf(owner);
                        if (FlagManager.playerHasFlag(player, flag)) {
                            return flag_manager.getPlayerFlag(player, flag);
                        }
                        dB.echoError("Player '" + owner + "' flag '" + flag + "' not found.");
                    } else if (Depends.citizens != null && dNPC.matches(owner)) {
                        dNPC npc = dNPC.valueOf(owner);
                        if (FlagManager.npcHasFlag(npc, flag)) {
                            return flag_manager.getNPCFlag(npc.getId(), flag);
                        }
                        dB.echoError("NPC '" + owner + "' flag '" + flag + "' not found.");
                    } else if (dEntity.matches(owner)) {
                        dEntity entity = dEntity.valueOf(owner);
                        if (FlagManager.entityHasFlag(entity, flag)) {
                            return flag_manager.getEntityFlag(entity, flag);
                        }
                        dB.echoError("Entity '" + owner + "' flag '" + flag + "' not found.");
                    }
                } else {
                    dB.echoError("Invalid dFlag format: " + string);
                }
            } else if (string.indexOf(64) == 2) {
                String flag = string.substring(3);
                if (FlagManager.serverHasFlag(flag)) {
                    return flag_manager.getGlobalFlag(flag);
                }
                dB.echoError("Global flag '" + flag + "' not found.");
            }
        }
        return null;
    }

    @Override
    public boolean matchesFlagdList(String arg) {
        boolean flag = false;
        if (arg.startsWith("fl")) {
            if (arg.indexOf(91) == 2) {
                int cb = arg.indexOf(93);
                if (cb > 4 && arg.indexOf(64) == cb + 1) {
                    String owner = arg.substring(3, cb);
                    flag = arg.substring(cb + 2).length() > 0 && (dPlayer.matches(owner) || Depends.citizens != null && dNPC.matches(owner));
                }
            } else if (arg.indexOf(64) == 2) {
                flag = arg.substring(3).length() > 0;
            }
        }
        return flag;
    }

    @Override
    public String getLastEntryFromFlag(String flag) {
        FlagManager.Flag theflag = this.getFlag(flag);
        if (theflag == null || theflag.getLast() == null) {
            return null;
        }
        return theflag.getLast().asString();
    }

    @Override
    public TagContext getTagContext(ScriptEntry scriptEntry) {
        return new BukkitTagContext(scriptEntry, false);
    }

    @Override
    public ScriptEntryData getEmptyScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    @Override
    public int getTagTimeout() {
        if (this.tT == Integer.MAX_VALUE) {
            this.tT = Settings.tagTimeout();
        }
        return this.tT;
    }
}

