/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events;

import java.util.List;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEllipsoid;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Location;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    public boolean runInCheck(ScriptContainer scriptContainer, String s, String lower, Location location) {
        int index;
        List<String> data = CoreUtilities.split(lower, ' ');
        for (index = 0; index < data.size() && !data.get(index).equals("in"); ++index) {
        }
        if (index >= data.size()) {
            return true;
        }
        String it = CoreUtilities.getXthArg(index + 1, s);
        if (it.equalsIgnoreCase("notable")) {
            String subit = CoreUtilities.getXthArg(index + 2, lower);
            if (subit.equalsIgnoreCase("cuboid")) {
                return dCuboid.getNotableCuboidsContaining(location).size() > 0;
            }
            if (subit.equalsIgnoreCase("ellipsoid")) {
                return dEllipsoid.getNotableEllipsoidsContaining(location).size() > 0;
            }
            dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + s + "' for " + scriptContainer.getName());
            return false;
        }
        if (dWorld.matches(it)) {
            return location.getWorld().getName().equalsIgnoreCase(it);
        }
        if (dCuboid.matches(it)) {
            dCuboid cuboid = dCuboid.valueOf(it);
            return cuboid.isInsideCuboid(location);
        }
        if (dEllipsoid.matches(it)) {
            dEllipsoid ellipsoid = dEllipsoid.valueOf(it);
            return ellipsoid.contains(location);
        }
        dB.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in ???'): '" + s + "' for " + scriptContainer.getName());
        return false;
    }

    public boolean runWithCheck(ScriptContainer scriptContainer, String s, String lower, dItem held) {
        String with = this.getSwitch(s, "with");
        if (with != null) {
            if (with.equalsIgnoreCase("item")) {
                return true;
            }
            dItem it = dItem.valueOf(with);
            if (it == null) {
                dB.echoError("Invalid WITH item in " + this.getName() + " for '" + s + "' in " + scriptContainer.getName());
                return false;
            }
            if (held == null || !this.tryItem(held, with)) {
                return false;
            }
        }
        return true;
    }

    public boolean tryItem(dItem item, String comparedto) {
        if (comparedto.equalsIgnoreCase("item")) {
            return true;
        }
        item = new dItem(item.getItemStack().clone());
        item.setAmount(1);
        if (item.identifyNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        if (item.identifyMaterialNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        if (item.identifySimpleNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        item.setDurability((short)0);
        if (item.identifyNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        return item.identifyMaterialNoIdentifier().equalsIgnoreCase(comparedto);
    }

    public boolean tryMaterial(dMaterial mat, String comparedto) {
        if (comparedto == null || comparedto.length() == 0) {
            return false;
        }
        if (comparedto.equalsIgnoreCase("block") || comparedto.equalsIgnoreCase("material")) {
            return true;
        }
        if (mat.identifyNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        if (mat.identifySimpleNoIdentifier().equalsIgnoreCase(comparedto)) {
            return true;
        }
        return mat.identifyFullNoIdentifier().equalsIgnoreCase(comparedto);
    }
}

