/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import java.util.List;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.Conversion;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.entity.Position;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityShootsBowEvent
extends ScriptEvent
implements Listener {
    public static EntityShootsBowEvent instance;
    public dEntity entity;
    public Float force;
    public dItem bow;
    public dEntity projectile;
    public EntityShootBowEvent event;

    public EntityShootsBowEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        return CoreUtilities.getXthArg(1, CoreUtilities.toLowerCase(s)).equals("shoots");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String attacker = CoreUtilities.getXthArg(0, lower);
        String item = CoreUtilities.getXthArg(2, lower);
        if (!this.entity.matchesEntity(attacker)) {
            return false;
        }
        return item.equals("bow") || item.equals(this.bow.identifyNoIdentifier()) || item.equals(this.bow.identifySimpleNoIdentifier()) || item.equals(CoreUtilities.toLowerCase(this.bow.getScriptName()));
    }

    @Override
    public String getName() {
        return "EntityShootsBow";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityShootBowEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.Argument.valueOf(determination).matchesArgumentList(dEntity.class)) {
            List<dEntity> list;
            this.cancelled = true;
            List<dEntity> newProjectiles = list = dList.valueOf(determination).filter(dEntity.class);
            for (dEntity newProjectile : newProjectiles) {
                newProjectile.spawnAt(this.entity.getEyeLocation().add(this.entity.getEyeLocation().getDirection()));
                if (!newProjectile.isProjectile()) continue;
                newProjectile.setShooter(this.entity);
            }
            Position.mount(Conversion.convertEntities(newProjectiles));
            Entity lastProjectile = newProjectiles.get(newProjectiles.size() - 1).getBukkitEntity();
            lastProjectile.setVelocity(this.event.getEntity().getLocation().getDirection().multiply(this.force.floatValue()));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity.isPlayer() ? dEntity.getPlayerFrom((Entity)this.event.getEntity()) : null, this.entity.isCitizensNPC() ? dEntity.getNPCFrom((Entity)this.event.getEntity()) : null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("force", new Element(this.force));
        context.put("bow", this.bow);
        context.put("projectile", this.projectile);
        return context;
    }

    @EventHandler
    public void onEntityShootsBow(EntityShootBowEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.force = Float.valueOf(event.getForce() * 3.0f);
        this.bow = new dItem(event.getBow());
        this.projectile = new dEntity(event.getProjectile());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

