/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorseJumpsScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static HorseJumpsScriptEvent instance;
    public dEntity entity;
    public Element color;
    public Element variant;
    public Float power;
    public HorseJumpEvent event;

    public HorseJumpsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.equals("horse jumps") || lower.endsWith("jumps");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String tamed;
        String lower = CoreUtilities.toLowerCase(s);
        String arg1 = CoreUtilities.getXthArg(0, lower);
        String arg2 = CoreUtilities.getXthArg(1, lower);
        String string = tamed = arg2.equals("jumps") ? arg1 : arg2;
        if (!this.entity.matchesEntity(tamed)) {
            return false;
        }
        return CoreUtilities.getXthArg(2, lower).length() <= 0 || arg1.equals(this.color.toString().toLowerCase()) && arg2.equals(this.variant.toString().toLowerCase());
    }

    @Override
    public String getName() {
        return "HorseJumps";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        HorseJumpEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.Argument.valueOf(determination).matchesPrimitive(aH.PrimitiveType.Float)) {
            this.power = Float.valueOf(aH.getFloatFrom(determination));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("color", this.color);
        context.put("variant", this.variant);
        context.put("power", new Element(this.power));
        return context;
    }

    @EventHandler
    public void onHorseJumps(HorseJumpEvent event) {
        this.entity = new dEntity((Entity)event.getEntity());
        this.color = new Element(event.getEntity().getColor().name());
        this.variant = new Element(event.getEntity().getVariant().name());
        this.power = Float.valueOf(event.getPower());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setPower(this.power.floatValue());
    }
}

