/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.player;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerTakesFromFurnaceScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static PlayerTakesFromFurnaceScriptEvent instance;
    public dLocation location;
    public dItem item;
    public Element xp;
    public FurnaceExtractEvent event;

    public PlayerTakesFromFurnaceScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.startsWith("player takes") && CoreUtilities.getXthArg(4, lower).equals("furnace");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String itemTest = CoreUtilities.getXthArg(2, CoreUtilities.toLowerCase(s));
        return itemTest.equals("block") || !this.tryItem(this.item, itemTest);
    }

    @Override
    public String getName() {
        return "PlayerTakesFromFurnace";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        FurnaceExtractEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        String lower = CoreUtilities.toLowerCase(determination);
        if (aH.Argument.valueOf(lower).matchesPrimitive(aH.PrimitiveType.Integer)) {
            this.xp = aH.Argument.valueOf(lower).asElement();
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new dPlayer(this.event.getPlayer()), null);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("item", this.item);
        return context;
    }

    @EventHandler
    public void onPlayerTakesFromFurnace(FurnaceExtractEvent event) {
        this.item = new dItem(dMaterial.getMaterialFrom(event.getItemType()), event.getItemAmount());
        this.location = new dLocation(event.getBlock().getLocation());
        this.xp = new Element(event.getExpToDrop());
        this.event = event;
        this.fire();
        event.setExpToDrop(this.xp.asInt());
    }
}

