/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.events.ScriptEvent;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PistonRetractsScriptEvent
extends ScriptEvent
implements Listener {
    public static PistonRetractsScriptEvent instance;
    public dLocation location;
    public dMaterial material;
    public dLocation retract_location;
    public dList blocks;
    public Element sticky;
    public dLocation relative;
    public BlockPistonRetractEvent event;

    public PistonRetractsScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(0, lower);
        return lower.contains("piston retracts") || lower.equals(mat + " retracts") && dMaterial.matches(mat);
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String mat = CoreUtilities.getXthArg(0, lower);
        return mat.equals("piston") || this.material.identifySimpleNoIdentifier().toLowerCase().equals(mat);
    }

    @Override
    public String getName() {
        return "PistonRetracts";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        BlockPistonRetractEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("location", this.location);
        context.put("material", this.material);
        context.put("sticky", this.sticky);
        context.put("relative", this.relative);
        context.put("blocks", this.blocks);
        context.put("retract_location", this.retract_location);
        return context;
    }

    @EventHandler
    public void onPistonRetracts(BlockPistonRetractEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.sticky = new Element(event.isSticky() ? "true" : "false");
        this.relative = new dLocation(event.getBlock().getRelative(event.getDirection()).getLocation());
        this.blocks = new dList();
        for (Block block : event.getBlocks()) {
            this.blocks.add(new dLocation(block.getLocation()).identify());
        }
        this.retract_location = new dLocation(event.getBlock().getRelative(event.getDirection(), 2).getLocation());
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

