/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.core;

import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Duration;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dScript;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;

public class CooldownCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        scriptEntry.addObject("type", (Object)Type.PLAYER);
        scriptEntry.addObject("script", scriptEntry.getScript());
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!arg.hasPrefix() && arg.matchesEnum(Type.values())) {
                scriptEntry.addObject("type", (Object)Type.valueOf(arg.getValue().toUpperCase()));
                continue;
            }
            if (!scriptEntry.hasObject("duration") && arg.matchesArgumentType(Duration.class)) {
                scriptEntry.addObject("duration", arg.asType(Duration.class));
                continue;
            }
            if (arg.matchesPrefix("script", "s")) {
                if (arg.matchesArgumentType(dScript.class)) {
                    scriptEntry.addObject("script", arg.asType(dScript.class));
                    continue;
                }
                throw new InvalidArgumentsException("Specified an invalid script!");
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("duration")) {
            throw new InvalidArgumentsException("Requires a valid duration!");
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        dScript script = (dScript)scriptEntry.getObject("script");
        Duration duration = (Duration)scriptEntry.getObject("duration");
        Type type = scriptEntry.hasObject("type") ? (Type)((Object)scriptEntry.getObject("type")) : Type.PLAYER;
        dB.report(scriptEntry, this.getName(), aH.debugObj("Type", type.name()) + script.debug() + (type.name().equalsIgnoreCase("player") ? ((BukkitScriptEntryData)scriptEntry.entryData).getPlayer().debug() : "") + duration.debug());
        switch (type) {
            case PLAYER: {
                CooldownCommand.setCooldown(((BukkitScriptEntryData)scriptEntry.entryData).getPlayer(), duration, script.getName(), false);
                break;
            }
            case GLOBAL: {
                CooldownCommand.setCooldown(null, duration, script.getName(), true);
            }
        }
    }

    public static Duration getCooldownDuration(dPlayer player, String scriptName) {
        Duration player_dur;
        scriptName = scriptName.toUpperCase();
        Duration duration = Duration.ZERO;
        if (DenizenAPI._saves().contains("Global.Scripts." + scriptName + ".Cooldown Time") && System.currentTimeMillis() < DenizenAPI._saves().getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
            duration = new Duration((double)(DenizenAPI._saves().getLong("Global.Scripts." + scriptName + ".Cooldown Time") - System.currentTimeMillis()) / 1000.0);
        }
        if (player == null) {
            return duration;
        }
        if (!DenizenAPI._saves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            return duration;
        }
        if (System.currentTimeMillis() <= DenizenAPI._saves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time") && (player_dur = new Duration((double)(DenizenAPI._saves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time") - System.currentTimeMillis()) / 1000.0)).getSeconds() > duration.getSeconds()) {
            return player_dur;
        }
        return duration;
    }

    public static boolean checkCooldown(dPlayer player, String scriptName) {
        scriptName = scriptName.toUpperCase();
        if (DenizenAPI._saves().contains("Global.Scripts." + scriptName + ".Cooldown Time")) {
            if (System.currentTimeMillis() < DenizenAPI._saves().getLong("Global.Scripts." + scriptName + ".Cooldown Time")) {
                return false;
            }
            DenizenAPI._saves().set("Global.Scripts." + scriptName + ".Cooldown Time", null);
        }
        if (player == null) {
            return true;
        }
        if (!DenizenAPI._saves().contains("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            return true;
        }
        if (System.currentTimeMillis() >= DenizenAPI._saves().getLong("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time")) {
            DenizenAPI._saves().set("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time", null);
            return true;
        }
        return false;
    }

    public static void setCooldown(dPlayer player, Duration duration, String scriptName, boolean global) {
        scriptName = scriptName.toUpperCase();
        if (global) {
            DenizenAPI._saves().set("Global.Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        } else {
            DenizenAPI._saves().set("Players." + player.getSaveName() + ".Scripts." + scriptName + ".Cooldown Time", (Object)(System.currentTimeMillis() + (long)(duration.getSecondsAsInt() * 1000)));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        GLOBAL,
        PLAYER;

    }
}

