/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.scripts.commands.world;

import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.exceptions.CommandExecutionException;
import net.aufdemrand.denizencore.exceptions.InvalidArgumentsException;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.commands.AbstractCommand;
import net.aufdemrand.denizencore.utilities.debugging.Debuggable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;

public class CreateWorldCommand
extends AbstractCommand {
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (aH.Argument arg : aH.interpret(scriptEntry.getArguments())) {
            if (!scriptEntry.hasObject("generator") && arg.matchesPrefix("generator", "g")) {
                scriptEntry.addObject("generator", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("worldtype") && arg.matchesPrefix("worldtype") && arg.matchesEnum((Enum<?>[])WorldType.values())) {
                scriptEntry.addObject("worldtype", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("world_name")) {
                scriptEntry.addObject("world_name", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("world_name")) {
            throw new InvalidArgumentsException("Must specify a world name.");
        }
        if (!scriptEntry.hasObject("worldtype")) {
            scriptEntry.addObject("worldtype", new Element("NORMAL"));
        }
    }

    public void execute(ScriptEntry scriptEntry) throws CommandExecutionException {
        Element World_Name = scriptEntry.getElement("world_name");
        Element Generator = scriptEntry.getElement("generator");
        Element worldType = scriptEntry.getElement("worldtype");
        dB.report(scriptEntry, this.getName(), World_Name.debug() + (Generator != null ? Generator.debug() : "") + worldType.debug());
        World world = Generator != null ? Bukkit.getServer().createWorld(WorldCreator.name((String)World_Name.asString()).generator(Generator.asString()).type(WorldType.valueOf((String)worldType.asString().toUpperCase()))) : Bukkit.getServer().createWorld(WorldCreator.name((String)World_Name.asString()).type(WorldType.valueOf((String)worldType.asString().toUpperCase())));
        if (world == null) {
            dB.echoDebug((Debuggable)scriptEntry, "World is null! :(");
        }
    }
}

