/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizencore.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.aufdemrand.denizencore.events.OldSmartEvent;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptBuilder;
import net.aufdemrand.denizencore.scripts.ScriptEntry;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.commands.core.DetermineCommand;
import net.aufdemrand.denizencore.scripts.containers.core.WorldScriptContainer;
import net.aufdemrand.denizencore.scripts.queues.ScriptQueue;
import net.aufdemrand.denizencore.scripts.queues.core.InstantQueue;
import net.aufdemrand.denizencore.utilities.YamlConfiguration;
import net.aufdemrand.denizencore.utilities.debugging.dB;
import net.aufdemrand.denizencore.utilities.text.StringHolder;

public class OldEventManager {
    public static Map<String, WorldScriptContainer> world_scripts = new ConcurrentHashMap<String, WorldScriptContainer>(8, 0.9f, 1);
    public static Map<String, List<WorldScriptContainer>> events = new HashMap<String, List<WorldScriptContainer>>();
    public static Set<OldSmartEvent> smart_events = new HashSet<OldSmartEvent>();

    public static void scanWorldEvents() {
        try {
            dB.log("Scanning " + world_scripts.size() + " world scripts...");
            for (WorldScriptContainer script : world_scripts.values()) {
                if (script == null) {
                    dB.echoError("Null world script?!");
                    continue;
                }
                if (script.contains("EVENTS")) {
                    YamlConfiguration configSection = script.getConfigurationSection("EVENTS");
                    if (configSection == null) {
                        dB.echoError("Script '" + script.getName() + "' has an invalid events block!");
                        break;
                    }
                    Set<StringHolder> keys = configSection.getKeys(false);
                    if (keys == null) {
                        dB.echoError("Script '" + script.getName() + "' has an empty events block!");
                        break;
                    }
                    for (StringHolder eventName1 : keys) {
                        String eventName = eventName1.str;
                        List<Object> list = events.containsKey(eventName) ? events.get(eventName) : new ArrayList();
                        list.add(script);
                        events.put(eventName, list);
                    }
                    continue;
                }
                dB.echoError("Script '" + script.getName() + "' does not have an events block!");
            }
            for (OldSmartEvent smartEvent : smart_events) {
                smartEvent.breakDown();
            }
            for (OldSmartEvent smartEvent : smart_events) {
                if (!smartEvent.shouldInitialize(events.keySet())) continue;
                smartEvent._initialize();
            }
        }
        catch (Exception e) {
            dB.echoError(e);
        }
    }

    public static List<String> trimEvents(List<String> original) {
        ArrayList<String> event = new ArrayList<String>();
        event.addAll(original);
        ArrayList<String> parsed = new ArrayList<String>();
        if (dB.showEventsTrimming) {
            dB.echoApproval("Trimming world events '" + ((Object)event).toString() + '\'');
        }
        block0: for (int i = 0; i < event.size(); ++i) {
            for (int x = 0; x < event.size(); ++x) {
                if (i == x || !((String)event.get(i)).equalsIgnoreCase((String)event.get(x))) continue;
                event.remove(i);
                --i;
                continue block0;
            }
        }
        for (String e : event) {
            if (!events.containsKey("ON " + e.toUpperCase())) continue;
            parsed.add(e);
        }
        return parsed;
    }

    public static boolean eventExists(String original) {
        return events.containsKey("ON " + original.toUpperCase());
    }

    public static List<String> addAlternates(List<String> events) {
        HashSet<String> newEvents = new HashSet<String>();
        for (String event : events) {
            if (event.indexOf(64) == -1) continue;
            StringBuilder sb = new StringBuilder();
            int len = event.length();
            char[] data = event.toCharArray();
            for (int i = 0; i < len; ++i) {
                if (data[i] >= 'a' && data[i] <= 'z' && i + 1 < len) {
                    if (i + 2 < len && data[i + 2] == '@') {
                        i += 2;
                        continue;
                    }
                    if (data[i + 1] == '@') {
                        ++i;
                        continue;
                    }
                }
                sb.append(data[i]);
            }
            newEvents.add(sb.toString());
        }
        ArrayList<String> finalEvents = new ArrayList<String>();
        finalEvents.addAll(events);
        finalEvents.addAll(newEvents);
        return finalEvents;
    }

    public static String StripIdentifiers(String original) {
        if (original.matches(".*?[a-z]+@[\\w ]+")) {
            return original.replaceAll("[a-z]+@", "");
        }
        return original;
    }

    public static List<String> doEvents(List<String> eventNames, ScriptEntryData data, Map<String, dObject> context, boolean strip_ids) {
        return OldEventManager.doEvents(OldEventManager.addAlternates(eventNames), data, context);
    }

    public static List<String> doEvents(List<String> eventNames, ScriptEntryData data, Map<String, dObject> context) {
        try {
            List<String> determinations = new ArrayList<String>();
            eventNames = OldEventManager.trimEvents(eventNames);
            for (String eventName : eventNames) {
                if (!events.containsKey("ON " + eventName.toUpperCase())) continue;
                for (WorldScriptContainer script : events.get("ON " + eventName.toUpperCase())) {
                    List<ScriptEntry> entries;
                    if (script == null || (entries = script.getEntries(data, "events.on " + eventName)).isEmpty()) continue;
                    dB.report(script, "Event", aH.debugObj("Type", "on " + eventName) + script.getAsScriptArg().debug() + data.toString() + (context != null ? aH.debugObj("Context", context.toString()) : ""));
                    dB.echoDebug(script, dB.DebugElement.Header, "Building event 'ON " + eventName.toUpperCase() + "' for " + script.getName());
                    long id = DetermineCommand.getNewId();
                    ScriptBuilder.addObjectToEntries(entries, "ReqId", id);
                    ScriptQueue queue = InstantQueue.getQueue(ScriptQueue.getNextId(script.getName())).addEntries(entries).setReqId(id);
                    if (context != null) {
                        for (Map.Entry<String, dObject> entry : context.entrySet()) {
                            queue.addContext(entry.getKey(), entry.getValue());
                        }
                    }
                    queue.start();
                    if (!DetermineCommand.hasOutcome(id)) continue;
                    determinations = DetermineCommand.getOutcome(id);
                }
            }
            return determinations;
        }
        catch (Exception e) {
            dB.echoError(e);
            return new ArrayList<String>();
        }
    }

    public void registerCoreMembers() {
    }

    public static void registerSmartEvent(OldSmartEvent event) {
        if (event != null) {
            smart_events.add(event);
        }
    }
}

