/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.block;

import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dMaterial;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.plugin.Plugin;

public class BlockDispensesScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static BlockDispensesScriptEvent instance;
    public dLocation location;
    public dItem item;
    private dLocation velocity;
    private dMaterial material;
    public BlockDispenseEvent event;

    public BlockDispensesScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("dispenses") && lower.length() >= 3;
    }

    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        if (!this.runInCheck(scriptContainer, s, lower, this.location)) {
            return false;
        }
        String dispenser = CoreUtilities.getXthArg(0, lower);
        String iTest = CoreUtilities.getXthArg(2, lower);
        return this.tryMaterial(this.material, dispenser) && (iTest.equals("item") || this.tryItem(this.item, iTest));
    }

    public String getName() {
        return "BlockDispenses";
    }

    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    public void destroy() {
        BlockDispenseEvent.getHandlerList().unregister((Listener)this);
    }

    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.velocity = new dLocation(this.velocity.multiply(aH.getDoubleFrom(determination)));
            return true;
        }
        if (dLocation.matches(determination)) {
            dLocation vel = dLocation.valueOf(determination);
            if (vel == null) {
                dB.echoError("[" + this.getName() + "] Invalid velocity!");
            } else {
                this.velocity = vel;
            }
        } else if (dItem.matches(determination)) {
            dItem it = dItem.valueOf(determination);
            if (it == null) {
                dB.echoError("[" + this.getName() + "] Invalid item!");
            } else {
                this.item = it;
            }
        }
        return super.applyDetermination(container, determination);
    }

    public dObject getContext(String name) {
        if (name.equals("location")) {
            return this.location;
        }
        if (name.equals("item")) {
            return this.item;
        }
        if (name.equals("velocity")) {
            return this.velocity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onBlockDispenses(BlockDispenseEvent event) {
        this.location = new dLocation(event.getBlock().getLocation());
        this.material = dMaterial.getMaterialFrom(event.getBlock().getType(), event.getBlock().getData());
        this.item = new dItem(event.getItem());
        this.cancelled = event.isCancelled();
        this.velocity = new dLocation(null, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
        this.event = event;
        this.fire();
        event.setVelocity(this.velocity.toVector());
        event.setItem(this.item.getItemStack());
        event.setCancelled(this.cancelled);
    }
}

