/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDamagedScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityDamagedScriptEvent instance;
    public dEntity entity;
    public Element cause;
    public Element damage;
    public Element final_damage;
    public dEntity damager;
    public dEntity projectile;
    public dItem held;
    public EntityDamageEvent event;

    public EntityDamagedScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("damaged") || cmd.equals("damages");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String target;
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String attacker = cmd.equals("damages") ? CoreUtilities.getXthArg(0, lower) : (CoreUtilities.getXthArg(2, lower).equals("by") ? CoreUtilities.getXthArg(3, lower) : "");
        String string = target = cmd.equals("damages") ? CoreUtilities.getXthArg(2, lower) : CoreUtilities.getXthArg(0, lower);
        if (attacker.length() > 0) {
            if (this.damager != null) {
                boolean projectileMatched = false;
                if (this.projectile != null) {
                    projectileMatched = this.projectile.matchesEntity(attacker);
                }
                if (!(projectileMatched || this.damager.matchesEntity(attacker) || this.cause.asString().equals(attacker))) {
                    return false;
                }
            } else if (!this.cause.asString().equals(attacker)) {
                return false;
            }
        }
        if (target.length() > 0 && !this.entity.matchesEntity(target)) {
            return false;
        }
        if (!this.runInCheck(scriptContainer, s, lower, this.entity.getLocation())) {
            return false;
        }
        return this.runWithCheck(scriptContainer, s, lower, this.held);
    }

    @Override
    public String getName() {
        return "EntityDamaged";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityDamageEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.damage = new Element(aH.getDoubleFrom(determination));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.damager != null && this.damager.isPlayer() ? this.damager.getDenizenPlayer() : (this.entity.isPlayer() ? this.entity.getDenizenPlayer() : null), this.damager != null && this.damager.isCitizensNPC() ? this.damager.getDenizenNPC() : (this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null));
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("damage", this.damage);
        context.put("final_damage", this.final_damage);
        context.put("cause", this.cause);
        if (this.damager != null) {
            context.put("damager", this.damager);
        }
        if (this.projectile != null) {
            context.put("projectile", this.projectile);
        }
        for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
            context.put("damage_" + dm.name(), new Element(this.event.getDamage(dm)));
        }
        return context;
    }

    @EventHandler
    public void onEntityDamaged(EntityDamageEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.damage = new Element(event.getDamage());
        this.final_damage = new Element(event.getFinalDamage());
        this.cause = new Element(event.getCause().name().toLowerCase());
        this.damager = null;
        this.projectile = null;
        this.held = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new dEntity(((EntityDamageByEntityEvent)event).getDamager());
            if (this.damager.isProjectile()) {
                this.projectile = this.damager;
                if (this.damager.hasShooter()) {
                    this.damager = this.damager.getShooter();
                }
            }
            if (this.damager != null) {
                this.held = this.damager.getItemInHand();
                if (this.held != null) {
                    this.held.setAmount(1);
                }
            }
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setDamage(this.damage.asDouble());
    }
}

