/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.entity;

import java.util.HashMap;
import net.aufdemrand.denizen.BukkitScriptEntryData;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dNPC;
import net.aufdemrand.denizen.objects.dPlayer;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.ScriptEntryData;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityKilledScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityKilledScriptEvent instance;
    public dEntity entity;
    public Element cause;
    public Element damage;
    public Element final_damage;
    public dEntity damager;
    public dEntity projectile;
    public EntityDamageEvent event;

    public EntityKilledScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        return cmd.equals("killed") || cmd.equals("kills");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String target;
        if (this.entity.isValid() && this.entity.isLivingEntity() && this.final_damage.asDouble() <= this.entity.getLivingEntity().getHealth()) {
            return false;
        }
        String lower = CoreUtilities.toLowerCase(s);
        String cmd = CoreUtilities.getXthArg(1, lower);
        String arg0 = CoreUtilities.getXthArg(0, lower);
        String arg2 = CoreUtilities.getXthArg(2, lower);
        String arg3 = CoreUtilities.getXthArg(3, lower);
        String attacker = cmd.equals("kills") ? arg0 : (arg2.equals("by") ? arg3 : "");
        String string = target = cmd.equals("kills") ? arg2 : arg0;
        if (attacker.length() > 0 && (this.damager != null ? !this.damager.matchesEntity(attacker) && !this.cause.asString().equals(attacker) : !this.cause.asString().equals(attacker))) {
            return false;
        }
        if (!this.entity.matchesEntity(target)) {
            return false;
        }
        return this.runInCheck(scriptContainer, s, lower, this.entity.getLocation());
    }

    @Override
    public String getName() {
        return "EntityKilled";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        EntityDamageEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        if (aH.matchesDouble(determination)) {
            this.damage = new Element(aH.getDoubleFrom(determination));
            return true;
        }
        return super.applyDetermination(container, determination);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        dNPC npc;
        dPlayer player;
        dPlayer dPlayer2 = player = this.entity.isPlayer() ? dEntity.getPlayerFrom(this.event.getEntity()) : null;
        if (this.damager != null && player == null && this.damager.isPlayer()) {
            player = dEntity.getPlayerFrom(this.damager.getBukkitEntity());
        }
        dNPC dNPC2 = npc = this.entity.isCitizensNPC() ? dEntity.getNPCFrom(this.event.getEntity()) : null;
        if (this.damager != null && npc == null && this.damager.isCitizensNPC()) {
            npc = dEntity.getNPCFrom(this.damager.getBukkitEntity());
        }
        return new BukkitScriptEntryData(player, npc);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("entity", this.entity);
        context.put("damage", this.damage);
        context.put("final_damage", this.final_damage);
        context.put("cause", this.cause);
        if (this.damager != null) {
            context.put("damager", this.damager);
        }
        if (this.projectile != null) {
            context.put("projectile", this.projectile);
        }
        for (EntityDamageEvent.DamageModifier dm : EntityDamageEvent.DamageModifier.values()) {
            context.put("damage_" + dm.name(), new Element(this.event.getDamage(dm)));
        }
        return context;
    }

    @EventHandler
    public void onEntityKilled(EntityDamageEvent event) {
        this.entity = new dEntity(event.getEntity());
        this.damage = new Element(event.getDamage());
        this.final_damage = new Element(event.getFinalDamage());
        this.cause = new Element(event.getCause().name().toLowerCase());
        this.damager = null;
        this.projectile = null;
        if (event instanceof EntityDamageByEntityEvent) {
            this.damager = new dEntity(((EntityDamageByEntityEvent)event).getDamager());
            if (this.damager.isProjectile()) {
                this.projectile = this.damager;
                if (this.damager.hasShooter()) {
                    this.damager = this.damager.getShooter();
                }
            }
        }
        this.cancelled = event.isCancelled();
        this.event = event;
        this.fire();
        event.setCancelled(this.cancelled);
        event.setDamage(this.damage.asDouble());
    }
}

