/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.events.world;

import java.util.HashMap;
import net.aufdemrand.denizen.events.BukkitScriptEvent;
import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.scripts.containers.ScriptContainer;
import net.aufdemrand.denizencore.utilities.CoreUtilities;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvPicksUpItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static InvPicksUpItemScriptEvent instance;
    public dInventory inventory;
    public dItem item;
    public InventoryPickupItemEvent event;

    public InvPicksUpItemScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        return lower.contains("picks up") && !lower.startsWith("player");
    }

    @Override
    public boolean matches(ScriptContainer scriptContainer, String s) {
        String lower = CoreUtilities.toLowerCase(s);
        String inv = CoreUtilities.getXthArg(0, lower);
        String itemName = CoreUtilities.getXthArg(3, lower);
        if (!inv.equals("inventory") && !inv.equals(CoreUtilities.toLowerCase(this.inventory.getInventoryType().toString()))) {
            return false;
        }
        return itemName.equals("item") || this.tryItem(this.item, itemName);
    }

    @Override
    public String getName() {
        return "InvPicksUpItem";
    }

    @Override
    public void init() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)DenizenAPI.getCurrentInstance());
    }

    @Override
    public void destroy() {
        InventoryPickupItemEvent.getHandlerList().unregister((Listener)this);
    }

    @Override
    public boolean applyDetermination(ScriptContainer container, String determination) {
        return super.applyDetermination(container, determination);
    }

    @Override
    public HashMap<String, dObject> getContext() {
        HashMap<String, dObject> context = super.getContext();
        context.put("inventory", this.inventory);
        context.put("item", this.item);
        return context;
    }

    @EventHandler
    public void onInvPicksUpItem(InventoryPickupItemEvent event) {
        this.inventory = dInventory.mirrorBukkitInventory(event.getInventory());
        this.item = new dItem(event.getItem());
        this.cancelled = event.isCancelled();
        this.fire();
        event.setCancelled(this.cancelled);
    }
}

