/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.aufdemrand.denizen.objects.dCuboid;
import net.aufdemrand.denizen.objects.dEntity;
import net.aufdemrand.denizen.objects.dLocation;
import net.aufdemrand.denizen.objects.dWorld;
import net.aufdemrand.denizen.utilities.DenizenAPI;
import net.aufdemrand.denizen.utilities.blocks.FakeBlock;
import net.aufdemrand.denizen.utilities.debugging.dB;
import net.aufdemrand.denizencore.objects.Adjustable;
import net.aufdemrand.denizencore.objects.Element;
import net.aufdemrand.denizencore.objects.Fetchable;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.aH;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.objects.properties.PropertyParser;
import net.aufdemrand.denizencore.tags.Attribute;
import net.aufdemrand.denizencore.tags.TagContext;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.CraftChunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class dChunk
implements dObject,
Adjustable {
    CraftChunk chunk = null;
    String prefix = "Chunk";

    public static dChunk valueOf(String string) {
        return dChunk.valueOf(string, null);
    }

    @Fetchable(value="ch")
    public static dChunk valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        String[] parts = (string = string.toLowerCase().replace("ch@", "")).split(",");
        if (parts.length == 3) {
            try {
                return new dChunk((CraftChunk)dWorld.valueOf(parts[2]).getWorld().getChunkAt(Integer.valueOf(parts[0]).intValue(), Integer.valueOf(parts[1]).intValue()));
            }
            catch (Exception e) {
                dB.log("valueOf dChunk returning null: ch@" + string);
                return null;
            }
        }
        dB.log("valueOf dChunk unable to handle malformed format: ch@" + string);
        return null;
    }

    public static boolean matches(String string) {
        return string.toLowerCase().startsWith("ch@");
    }

    public dChunk(CraftChunk chunk) {
        this.chunk = chunk;
    }

    public dChunk(Chunk chunk) {
        this((CraftChunk)chunk);
    }

    public dChunk(Location location) {
        this((CraftChunk)location.getChunk());
    }

    public dLocation getCenter() {
        return new dLocation(this.getWorld(), this.getX() * 16 + 8, 128.0, this.getZ() * 16 + 8);
    }

    public int getX() {
        return this.chunk.getX();
    }

    public int getZ() {
        return this.chunk.getZ();
    }

    public World getWorld() {
        return this.chunk.getWorld();
    }

    public ChunkSnapshot getSnapshot() {
        return this.chunk.getChunkSnapshot();
    }

    public String getObjectType() {
        return "Chunk";
    }

    public String getPrefix() {
        return this.prefix;
    }

    public dChunk setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String debug() {
        return "<G>" + this.prefix + "='<Y>" + this.identify() + "<G>'  ";
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "ch@" + this.getX() + ',' + this.getZ() + ',' + this.getWorld().getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_loaded")) {
            return new Element(this.chunk.isLoaded()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("x")) {
            return new Element(this.getX()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new Element(this.getZ()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return dWorld.mirrorBukkitWorld(this.getWorld()).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboid")) {
            return new dCuboid(new Location(this.getWorld(), (double)(this.getX() * 16), 0.0, (double)(this.getZ() * 16)), new Location(this.getWorld(), (double)(this.getX() * 16 + 15), 255.0, (double)(this.getZ() * 16 + 15))).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("entities")) {
            dList entities = new dList();
            for (Entity ent : this.chunk.getEntities()) {
                entities.add(new dEntity(ent).identify());
            }
            return entities.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("living_entities")) {
            dList entities = new dList();
            for (Entity ent : this.chunk.getEntities()) {
                if (!(ent instanceof LivingEntity)) continue;
                entities.add(new dEntity(ent).identify());
            }
            return entities.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("players")) {
            dList entities = new dList();
            for (Entity ent : this.chunk.getEntities()) {
                if (!dEntity.isPlayer(ent)) continue;
                entities.add(dEntity.getPlayerFrom(ent).identify());
            }
            return entities.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("height_map")) {
            ArrayList<String> height_map = new ArrayList<String>(this.chunk.getHandle().heightMap.length);
            for (int i : this.chunk.getHandle().heightMap) {
                height_map.add(String.valueOf(i));
            }
            return new dList((List<String>)height_map).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("average_height")) {
            int sum = 0;
            for (int i : this.chunk.getHandle().heightMap) {
                sum += i;
            }
            return new Element((double)sum / (double)this.chunk.getHandle().heightMap.length).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_flat")) {
            int tolerance = attribute.hasContext(1) && aH.matchesInteger(attribute.getContext(1)) ? Integer.valueOf(attribute.getContext(1)) : 2;
            int x = this.chunk.getHandle().heightMap[0];
            for (int i : this.chunk.getHandle().heightMap) {
                if (Math.abs(x - i) <= tolerance) continue;
                return Element.FALSE.getAttribute(attribute.fulfill(1));
            }
            return Element.TRUE.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("surface_blocks")) {
            dList surface_blocks = new dList();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    surface_blocks.add(new dLocation(this.chunk.getBlock(x, this.getSnapshot().getHighestBlockYAt(x, z) - 1, z).getLocation()).identify());
                }
            }
            return surface_blocks.getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("spawn_slimes")) {
            Random random = new Random(this.getWorld().getSeed() + (long)(this.getX() * this.getX() * 4987142) + (long)(this.getX() * 5947611) + (long)(this.getZ() * this.getZ()) * 4392871L + (long)(this.getZ() * 389711) ^ 0x3AD8025FL);
            return new Element(random.nextInt(10) == 0).getAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("type")) {
            return new Element("Chunk").getAttribute(attribute.fulfill(1));
        }
        for (Property property : PropertyParser.getProperties(this)) {
            String returned = property.getAttribute(attribute);
            if (returned == null) continue;
            return returned;
        }
        return new Element(this.identify()).getAttribute(attribute);
    }

    public void applyProperty(Mechanism mechanism) {
        dB.echoError("Cannot apply properties to a chunk!");
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("unload")) {
            this.chunk.unload(true);
        }
        if (mechanism.matches("unload_safely")) {
            this.chunk.unload(true, true);
        }
        if (mechanism.matches("unload_without_saving")) {
            this.chunk.unload(false);
        }
        if (mechanism.matches("load")) {
            this.chunk.load(true);
        }
        if (mechanism.matches("regenerate")) {
            this.getWorld().regenerateChunk(this.getX(), this.getZ());
        }
        if (mechanism.matches("refresh_chunk")) {
            final int chunkX = this.getX();
            final int chunkZ = this.getZ();
            this.getWorld().refreshChunk(chunkX, chunkZ);
            new BukkitRunnable(){

                public void run() {
                    for (Map<dLocation, FakeBlock> blocks : FakeBlock.getBlocks().values()) {
                        for (Map.Entry<dLocation, FakeBlock> locBlock : blocks.entrySet()) {
                            dLocation location = locBlock.getKey();
                            if (Math.floor(location.getX() / 16.0) != (double)chunkX || Math.floor(location.getZ() / 16.0) != (double)chunkZ) continue;
                            locBlock.getValue().updateBlock();
                        }
                    }
                }
            }.runTaskLater((Plugin)DenizenAPI.getCurrentInstance(), 2L);
        }
        if (!mechanism.fulfilled()) {
            mechanism.reportInvalid();
        }
        for (Property property : PropertyParser.getProperties(this)) {
            property.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            break;
        }
    }
}

