/*
 * Decompiled with CFR 0.152.
 */
package net.aufdemrand.denizen.objects.properties.inventory;

import net.aufdemrand.denizen.objects.dInventory;
import net.aufdemrand.denizen.objects.dItem;
import net.aufdemrand.denizencore.objects.Mechanism;
import net.aufdemrand.denizencore.objects.dList;
import net.aufdemrand.denizencore.objects.dObject;
import net.aufdemrand.denizencore.objects.properties.Property;
import net.aufdemrand.denizencore.tags.Attribute;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class InventoryContents
implements Property {
    dInventory inventory;

    public static boolean describes(dObject inventory) {
        return inventory instanceof dInventory;
    }

    public static InventoryContents getFrom(dObject inventory) {
        if (!InventoryContents.describes(inventory)) {
            return null;
        }
        return new InventoryContents((dInventory)inventory);
    }

    public InventoryContents(dInventory inventory) {
        this.inventory = inventory;
    }

    public dList getContents(int simpleOrFull) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        dList contents = new dList();
        boolean containsNonAir = false;
        for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) {
                containsNonAir = true;
                if (simpleOrFull == 1) {
                    contents.add(new dItem(item).identifySimple());
                    continue;
                }
                if (simpleOrFull == 2) {
                    contents.add(new dItem(item).getFullString());
                    continue;
                }
                contents.add(new dItem(item).identify());
                continue;
            }
            contents.add("i@air");
        }
        if (!containsNonAir) {
            contents.clear();
        } else {
            contents = dList.valueOf(contents.identify().replaceAll("(\\|i@air)*$", ""));
        }
        return contents;
    }

    public dList getContentsWithLore(String lore, boolean simple) {
        if (this.inventory.getInventory() == null) {
            return null;
        }
        dList contents = new dList();
        block0: for (ItemStack item : this.inventory.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || !item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
            for (String line : item.getItemMeta().getLore()) {
                if (!ChatColor.stripColor((String)line).equalsIgnoreCase(lore)) continue;
                if (simple) {
                    contents.add(new dItem(item).identifySimple());
                    continue block0;
                }
                contents.add(new dItem(item).identify());
                continue block0;
            }
        }
        return contents;
    }

    public String getPropertyString() {
        if (!this.inventory.getIdType().equals("generic") && !this.inventory.isUnique()) {
            return null;
        }
        dList contents = this.getContents(0);
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        return contents.identify();
    }

    public String getPropertyId() {
        return "contents";
    }

    public String getAttribute(Attribute attribute) {
        if (attribute == null) {
            return "null";
        }
        if (attribute.startsWith("list_contents")) {
            attribute.fulfill(1);
            if (attribute.startsWith("simple")) {
                return this.getContents(1).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("full")) {
                return this.getContents(2).getAttribute(attribute.fulfill(1));
            }
            if (attribute.startsWith("with_lore")) {
                if (!attribute.hasContext(1)) {
                    return null;
                }
                String lore = attribute.getContext(1);
                attribute.fulfill(1);
                if (attribute.startsWith("simple")) {
                    return this.getContentsWithLore(lore, true).getAttribute(attribute.fulfill(1));
                }
                return this.getContentsWithLore(lore, false).getAttribute(attribute);
            }
            return this.getContents(0).getAttribute(attribute);
        }
        return null;
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("contents") && this.inventory.getIdType().equals("generic")) {
            this.inventory.setContents(mechanism.getValue().asType(dList.class));
        }
    }
}

